/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.implantacaosaldos;

import com.touchcomp.basementor.constants.enums.paramcentroestoque.EnumConstParamCenEstEntSai;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemImpSaldo;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.ItemImplantaSaldo;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.dao.impl.DaoImplantacaoSaldosImpl;
import com.touchcomp.basementorservice.helpers.impl.centroestoque.HelperCentroEstoque;
import com.touchcomp.basementorservice.helpers.impl.wmsentradaprodutos.HelperWmsEntradaProdutos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceImplantacaoSaldosImpl
extends ServiceGenericEntityImpl<ImplantacaoSaldos, Long, DaoImplantacaoSaldosImpl> {
    HelperWmsEntradaProdutos wmsEntradaProdutos;
    private ServiceGradeCorImpl serviceGradeCor;
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    private HelperCentroEstoque helperCentroEstoque;

    @Autowired
    public ServiceImplantacaoSaldosImpl(DaoImplantacaoSaldosImpl genericDao, HelperWmsEntradaProdutos wmsEntradaProdutos, ServiceGradeCorImpl serviceGradeCor, ServiceLoteFabricacaoImpl serviceLoteFabricacao, HelperCentroEstoque helperCentroEstoque) {
        super(genericDao);
        this.wmsEntradaProdutos = wmsEntradaProdutos;
        this.serviceGradeCor = serviceGradeCor;
        this.serviceLoteFabricacao = serviceLoteFabricacao;
        this.helperCentroEstoque = helperCentroEstoque;
    }

    public Double getUltimoCusto(Produto produto, Empresa empresa) {
        return this.getUltimoCusto(produto.getIdentificador(), empresa.getIdentificador());
    }

    public Double getUltimoCusto(Long idProduto, Long idEmpresa) {
        return ((DaoImplantacaoSaldosImpl)this.getDao()).getUltimoCusto(idProduto, idEmpresa);
    }

    public Double getUltimoCusto(Long idProduto, Long idEmpresa, Date dataBase) {
        return ((DaoImplantacaoSaldosImpl)this.getDao()).getUltimoCusto(idProduto, idEmpresa, dataBase);
    }

    public Double getUltimoCusto(Long idProduto) {
        return ((DaoImplantacaoSaldosImpl)this.getDao()).getUltimoCusto(idProduto);
    }

    public Double getUltimoCusto(Long idProduto, Date dataBase) {
        return ((DaoImplantacaoSaldosImpl)this.getDao()).getUltimoCusto(idProduto, dataBase);
    }

    @Override
    public ImplantacaoSaldos saveOrUpdateOnly(ImplantacaoSaldos entity) {
        try {
            entity.setWmsEntradaEstoque(this.wmsEntradaProdutos.getWmsEntrada(entity, this.getSharedData().getWmsOpcoes(entity.getEmpresa())));
            return ((DaoImplantacaoSaldosImpl)this.getGenericDao()).saveOrUpdate(entity);
        }
        catch (ExceptionInvalidState ex) {
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
    }

    private void calculaQtdTotal(ItemImplantaSaldo i) {
        i.setQuantidadeTotal(Double.valueOf(i.getGradeItem().stream().mapToDouble(m -> m.getQuantidade()).sum()));
    }

    @Override
    public ImplantacaoSaldos beforeSave(ImplantacaoSaldos e) {
        e.getItemImplantaSaldo().forEach(i -> {
            i.setImplantacaoSaldos(e);
            if (i.getGradeItem().size() > 1) {
                this.calculaQtdTotal((ItemImplantaSaldo)i);
            } else {
                i.getGradeItem().forEach(g -> g.setQuantidade(i.getQuantidadeTotal()));
            }
            i.getGradeItem().forEach(g -> {
                g.setItemImplantaSaldo(i);
                g.setDataMovimentacao(e.getDataEntradaSaida());
                g.setEmpresa(e.getEmpresa());
                g.setCentroEstoque(i.getCentroEstoque());
                g.setValorUnitario(i.getValorUnitario());
                g.setValorUltCustoUnit(i.getValorUltCustoUnit());
            });
        });
        return e;
    }

    private List<GradeItemImpSaldo> getGrade(Produto produto, Double qtd, Double vlrUnit, Double vlrUltCusto) {
        ArrayList<GradeItemImpSaldo> res = new ArrayList<GradeItemImpSaldo>();
        GradeCor gradePrincipal = this.serviceGradeCor.getGradePrincipalbyProduto(produto);
        if (!this.isNull(gradePrincipal).booleanValue()) {
            GradeItemImpSaldo gi = this.criarGradeItem(gradePrincipal, qtd, vlrUnit, vlrUltCusto);
            res.add(gi);
            return res;
        }
        List<GradeCor> grades = this.serviceGradeCor.getByIdProduto(produto.getIdentificador());
        grades.forEach(g -> res.add(this.criarGradeItem((GradeCor)g, qtd, vlrUnit, vlrUltCusto)));
        return res;
    }

    public void setDefaultLoteFab(List<GradeItemImpSaldo> grades, Produto p) {
        if (this.isEquals(p.getLoteUnico(), (short)1)) {
            LoteFabricacao lote = this.serviceLoteFabricacao.findLoteUnico(p);
            grades.forEach(g -> g.setLoteFabricacao(lote));
        }
    }

    public List<GradeItemImpSaldo> getGradesProduto(Produto p, Double qtd, Double vlrUnit, Double vlrUltCusto) {
        List<GradeItemImpSaldo> grades = this.getGrade(p, qtd, vlrUnit, vlrUltCusto);
        this.setDefaultLoteFab(grades, p);
        return grades;
    }

    public ItemImplantaSaldo criarItem(Produto p, Empresa emp, Usuario user, OpcoesEstoque opEst, Double qtd, Double vlrUnit, Double vlrUltCusto) {
        ItemImplantaSaldo item = new ItemImplantaSaldo();
        item.setProduto(p);
        item.setUnidadeMedida(p.getUnidadeMedida());
        item.setValorUnitario(vlrUnit);
        item.setValorUltCustoUnit(vlrUltCusto);
        item.setGradeItem(this.getGradesProduto(p, qtd, vlrUnit, vlrUltCusto));
        this.calculaQtdTotal(item);
        CentroEstoque centroEstoque = this.helperCentroEstoque.getCentroEstoque(opEst, emp, p, user, EnumConstParamCenEstEntSai.ENTRADA);
        item.setCentroEstoque(centroEstoque);
        return item;
    }

    public GradeItemImpSaldo criarGradeItem(Long idGrade, Double qtd, Double vlrUnit, Double vlrUltCusto) {
        GradeCor grade = (GradeCor)this.serviceGradeCor.get(idGrade);
        return this.criarGradeItem(grade, qtd, vlrUnit, vlrUltCusto);
    }

    public GradeItemImpSaldo criarGradeItem(GradeCor grade, Double qtd, Double vlrUnit, Double vlrUltCusto) {
        GradeItemImpSaldo gi = new GradeItemImpSaldo(grade);
        gi.setQuantidade(qtd);
        gi.setValorUnitario(vlrUnit);
        gi.setValorUltCustoUnit(vlrUltCusto);
        if (this.isEquals(grade.getProdutoGrade().getProduto().getLoteUnico(), (short)1)) {
            LoteFabricacao lote = this.serviceLoteFabricacao.findLoteUnico(grade.getProdutoGrade().getProduto());
            gi.setLoteFabricacao(lote);
        }
        return gi;
    }

    public List<DTORastreioLoteFabricacao> rastreioLoteImplantacaoSaldo(Date dataInicial, Date dataFinal, List lotes, Long produtoInicial, Long produtoFinal) {
        return ((DaoImplantacaoSaldosImpl)this.getGenericDao()).rastreioLoteImplantacaoSaldo(dataInicial, dataFinal, lotes, produtoInicial, produtoFinal);
    }
}

