/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.importacaobi;

import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.model.vo.ImportacaoBi;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementorbinary.model.ArqImagemBI;
import com.touchcomp.basementorbinary.model.ArqImagemPrincipalBI;
import com.touchcomp.basementorbinary.service.impl.arqimagembi.ServiceBinaryArqImagemBIImpl;
import com.touchcomp.basementorbinary.service.impl.arqimagemprincipalbi.ServiceBinaryArqImagemPrincipalBIImpl;
import com.touchcomp.basementorservice.dao.impl.DaoImportacaoBiImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.formatogeracaobi.ServiceFormatoGeracaoBIImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceSmartComponentImpl;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.businessintelligence.web.DTOImagemBI;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIConsulta;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIRes;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceImportacaoBiImpl
extends ServiceGenericEntityImpl<ImportacaoBi, Long, DaoImportacaoBiImpl> {
    private ServiceBusinessIntelligenceImpl serviceBusinessIntelligence;
    private ServiceVersaoVersoesImpl serviceVersao;
    private ServiceSmartComponentImpl serviceSmartComponent;
    private ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI;
    private ServiceBinaryArqImagemPrincipalBIImpl serviceBinaryArqImgPrincipalBI;
    private ServiceBinaryArqImagemBIImpl serviceBinaryArqImgBI;

    @Autowired
    public ServiceImportacaoBiImpl(DaoImportacaoBiImpl genericDao, ServiceBusinessIntelligenceImpl serviceBusinessIntelligence, ServiceSmartComponentImpl serviceSmartComponent, ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI, ServiceBinaryArqImagemPrincipalBIImpl serviceBinaryArqImgPrincipalBI, ServiceBinaryArqImagemBIImpl serviceBinaryArqImgBI) {
        super(genericDao);
        this.serviceBusinessIntelligence = serviceBusinessIntelligence;
        this.serviceSmartComponent = serviceSmartComponent;
        this.serviceFormatoGeracaoBI = serviceFormatoGeracaoBI;
        this.serviceBinaryArqImgPrincipalBI = serviceBinaryArqImgPrincipalBI;
        this.serviceBinaryArqImgBI = serviceBinaryArqImgBI;
    }

    public Long getMaxNrControle() {
        return ((DaoImportacaoBiImpl)this.getGenericDao()).getMaxNrControle();
    }

    public ImportacaoBi getBySerial(String serialLocalBI) {
        return ((DaoImportacaoBiImpl)this.getGenericDao()).getBySerial(serialLocalBI);
    }

    public List<Map<String, Object>> getImportacaoBIMap(Long idNodo) {
        return ((DaoImportacaoBiImpl)this.getGenericDao()).getImportacaoBIMap(idNodo);
    }

    public List<ImportacaoBi> getImportacaoBILiberacao(Integer qtdRegistros, EnumConstTipoRepositorioBI tipoRepo) {
        return ((DaoImportacaoBiImpl)this.getDao()).getImportacaoBILiberacao(qtdRegistros, tipoRepo);
    }

    public List<DTOImportacaoBIConsulta> getImportacoesBINodoAtivas(Long idNodo, String cnpj, Short tipo) {
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        List<Map<String, Object>> importacoes = ((DaoImportacaoBiImpl)this.getDao()).getImportacoesAtivasNodo(idNodo, cnpj, EnumConstTipoRepositorioBI.get((Object)tipo));
        LinkedList<DTOImportacaoBIConsulta> ret = new LinkedList<DTOImportacaoBIConsulta>();
        for (Map<String, Object> imp : importacoes) {
            DTOImportacaoBIConsulta.TempRepositorioBI dtoR;
            DTOImportacaoBIConsulta dto;
            Long identificador = (Long)imp.get("identificador");
            String descricao = (String)imp.get("descricao");
            String serialLocalBI = (String)imp.get("serialLocalBI");
            String numeroControle = (String)imp.get("numeroControle");
            Short tipoClassificacaoBI = (Short)imp.get("tipoClassificacaoBI");
            Long numeroBI = (Long)imp.get("numeroBI");
            Long ridentificador = (Long)imp.get("identificador");
            Long rnumeroVersao = (Long)imp.get("rnumeroVersao");
            String rdescricao = (String)imp.get("rdescricao");
            String rnomeBi = (String)imp.get("rnomeBi");
            String ralteracao = (String)imp.get("ralteracao");
            Long videntificador = (Long)imp.get("identificador");
            Long vnumeroVersao = (Long)imp.get("vnumeroVersao");
            String vdescricaoAlteracoes = (String)imp.get("vdescricaoAlteracoes");
            Optional<DTOImportacaoBIConsulta> found = ret.stream().filter(i -> this.isEquals(identificador, i.getIdentificador())).findFirst();
            if (found.isPresent()) {
                dto = found.get();
            } else {
                dto = new DTOImportacaoBIConsulta();
                dto.setIdentificador(identificador);
                dto.setDescricao(descricao);
                dto.setNumeroBI(numeroBI);
                dto.setNumeroControle(numeroControle);
                dto.setSerialLocalBI(serialLocalBI);
                dto.setTipoClassificacaoBI(tipoClassificacaoBI);
                ret.add(dto);
            }
            Optional<DTOImportacaoBIConsulta.TempRepositorioBI> foundR = dto.getRepositorios().stream().filter(i -> this.isEquals(identificador, i.getIdentificador())).findFirst();
            if (found.isPresent()) {
                dtoR = foundR.get();
            } else {
                dtoR = new DTOImportacaoBIConsulta.TempRepositorioBI();
                dtoR.setIdentificador(ridentificador);
                dtoR.setDescricao(rdescricao);
                dtoR.setAlteracao(ralteracao);
                dtoR.setNomeBi(rnomeBi);
                dtoR.setNumeroVersao(rnumeroVersao);
                dto.getRepositorios().add(dtoR);
            }
            DTOImportacaoBIConsulta.TempRepositorioVersao dtoV = new DTOImportacaoBIConsulta.TempRepositorioVersao();
            dtoV.setDescricaoAlteracoes(vdescricaoAlteracoes);
            dtoV.setIdentificador(videntificador);
            dtoV.setNumeroVersao(vnumeroVersao);
            dtoR.getVersaosRepositorioBI().add(dtoV);
        }
        return ret;
    }

    public List<DTOImagemBI> searchThumbsBIs(Long[] numerosBI, EnumConstTipoRepositorioBI tipo) {
        List imagens;
        LinkedList<DTOImagemBI> ret = new LinkedList<DTOImagemBI>();
        if (this.isNotNull(numerosBI).booleanValue() && this.isNotNull(tipo).booleanValue() && ServiceImportacaoBiImpl.isWithData(imagens = this.serviceBinaryArqImgPrincipalBI.search(numerosBI, tipo))) {
            for (ArqImagemPrincipalBI img : imagens) {
                DTOImagemBI dto = new DTOImagemBI();
                dto.setHexImagem(img.getHexImagem());
                dto.setNumeroBI(img.getDocumento());
                dto.setTipo(Short.valueOf(tipo.getValue()));
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOImagemBI> searchImagesBI(Long numeroBI, EnumConstTipoRepositorioBI tipo) {
        List imagens;
        LinkedList<DTOImagemBI> ret = new LinkedList<DTOImagemBI>();
        if (this.isNotNull(numeroBI).booleanValue() && this.isNotNull(tipo).booleanValue() && ServiceImportacaoBiImpl.isWithData(imagens = this.serviceBinaryArqImgBI.getImagens(numeroBI, Short.valueOf(tipo.getValue())))) {
            for (ArqImagemBI img : imagens) {
                DTOImagemBI dto = new DTOImagemBI();
                dto.setHexImagem(img.getConteudoArquivo());
                dto.setNumeroBI(img.getIdDocumento());
                dto.setTipo(Short.valueOf(tipo.getValue()));
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOImportacaoBIConsulta> getImportacoesBINomeAtivas(String nome, String cnpj, Short tipo) {
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        List<Map<String, Object>> importacoes = ((DaoImportacaoBiImpl)this.getDao()).getImportacoesAtivasDescricao(nome, cnpj, EnumConstTipoRepositorioBI.get((Object)tipo));
        return this.buildDTOImportacaoBIConsulta(importacoes);
    }

    private List<DTOImportacaoBIConsulta> buildDTOImportacaoBIConsulta(List<Map<String, Object>> importacoes) {
        LinkedList<DTOImportacaoBIConsulta> ret = new LinkedList<DTOImportacaoBIConsulta>();
        for (Map<String, Object> imp : importacoes) {
            DTOImportacaoBIConsulta.TempRepositorioBI dtoR;
            DTOImportacaoBIConsulta dto;
            Long identificador = (Long)imp.get("identificador");
            String descricao = (String)imp.get("descricao");
            String serialLocalBI = (String)imp.get("serialLocalBI");
            String numeroControle = (String)imp.get("numeroControle");
            Short tipoClassificacaoBI = (Short)imp.get("tipoClassificacaoBI");
            Long numeroBI = (Long)imp.get("numeroBI");
            Long ridentificador = (Long)imp.get("identificador");
            Long rnumeroVersao = (Long)imp.get("rnumeroVersao");
            String rdescricao = (String)imp.get("rdescricao");
            String rnomeBi = (String)imp.get("rnomeBi");
            String ralteracao = (String)imp.get("ralteracao");
            Long videntificador = (Long)imp.get("identificador");
            Long vnumeroVersao = (Long)imp.get("vnumeroVersao");
            String vdescricaoAlteracoes = (String)imp.get("vdescricaoAlteracoes");
            Optional<DTOImportacaoBIConsulta> found = ret.stream().filter(i -> this.isEquals(identificador, i.getIdentificador())).findFirst();
            if (found.isPresent()) {
                dto = found.get();
            } else {
                dto = new DTOImportacaoBIConsulta();
                dto.setIdentificador(identificador);
                dto.setDescricao(descricao);
                dto.setNumeroBI(numeroBI);
                dto.setNumeroControle(numeroControle);
                dto.setSerialLocalBI(serialLocalBI);
                dto.setTipoClassificacaoBI(tipoClassificacaoBI);
                ret.add(dto);
            }
            Optional<DTOImportacaoBIConsulta.TempRepositorioBI> foundR = dto.getRepositorios().stream().filter(i -> this.isEquals(identificador, i.getIdentificador())).findFirst();
            if (found.isPresent()) {
                dtoR = foundR.get();
            } else {
                dtoR = new DTOImportacaoBIConsulta.TempRepositorioBI();
                dtoR.setIdentificador(ridentificador);
                dtoR.setDescricao(rdescricao);
                dtoR.setAlteracao(ralteracao);
                dtoR.setNomeBi(rnomeBi);
                dtoR.setNumeroVersao(rnumeroVersao);
                dto.getRepositorios().add(dtoR);
            }
            DTOImportacaoBIConsulta.TempRepositorioVersao dtoV = new DTOImportacaoBIConsulta.TempRepositorioVersao();
            dtoV.setDescricaoAlteracoes(vdescricaoAlteracoes);
            dtoV.setIdentificador(videntificador);
            dtoV.setNumeroVersao(vnumeroVersao);
            dtoR.getVersaosRepositorioBI().add(dtoV);
        }
        return ret;
    }

    public List<DTOImportacaoBIConsulta> getImportacoesBIAtivas(String search, String cnpj, Short tipo) {
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        List<Map<String, Object>> importacoes = ((DaoImportacaoBiImpl)this.getDao()).getImportacoesBIAtivas(search, cnpj, EnumConstTipoRepositorioBI.get((Object)tipo));
        return this.buildDTOImportacaoBIConsulta(importacoes);
    }

    public List<DTOImportacaoBIConsulta> getImportacoesBINumeroBIAtivas(Long numeroBI, String cnpj, EnumConstTipoRepositorioBI tipo) {
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        List<ImportacaoBi> importacoes = ((DaoImportacaoBiImpl)this.getDao()).getImportacoesAtivasNumeroBI(numeroBI, cnpj, tipo);
        List<DTOImportacaoBIConsulta> ret = this.buildToDTO(importacoes, DTOImportacaoBIConsulta.class);
        for (DTOImportacaoBIConsulta d : ret) {
            for (DTOImportacaoBIConsulta.TempRepositorioBI r : d.getRepositorios()) {
                r.getVersaosRepositorioBI().removeIf(i -> !this.isAffimative(i.getPublicado()) || this.isAffimative(i.getInativo()));
            }
            d.getRepositorios().removeIf(i -> this.isAffimative(i.getInativo()) || i.getVersaosRepositorioBI().isEmpty());
        }
        return ret;
    }

    public List<DTOImportacaoBIRes> getImportacoesBIs(String cnpj, EnumConstTipoRepositorioBI tipo) {
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        if (tipo == null) {
            tipo = EnumConstTipoRepositorioBI.BI;
        }
        List<Map<String, Object>> data = ((DaoImportacaoBiImpl)this.getDao()).getImportacoesBI(cnpj, tipo);
        LinkedList<DTOImportacaoBIRes> ret = new LinkedList<DTOImportacaoBIRes>();
        for (Map<String, Object> map : data) {
            Optional<DTOImportacaoBIRes.RepositorioVersaoRes> foundVersaoBI;
            DTOImportacaoBIRes dto;
            Long idClassificacao = (Long)map.get("idClassificacao");
            String classificacao = (String)map.get("classificacao");
            String descricao = (String)map.get("descricao");
            Long identificador = (Long)map.get("identificador");
            String numeroControle = (String)map.get("numeroControle");
            String serialLocalBI = (String)map.get("serialLocalBI");
            Long numeroBI = (Long)map.get("numeroBI");
            Short tipoClassificacaoBI = (Short)map.get("tipoClassificacaoBI");
            String observacoes = (String)map.get("observacoes");
            Long idRepositorio = (Long)map.get("idRepositorio");
            Long numeroVersaoRep = (Long)map.get("numeroVersaoRep");
            String descricaoRep = (String)map.get("descricaoRep");
            Short inativoRep = (Short)map.get("inativoRep");
            String nomeBi = (String)map.get("nomeBi");
            Long identificadorVersao = (Long)map.get("identificadorVersao");
            Long numeroVersaoVer = (Long)map.get("numeroVersaoVer");
            Date dataLiberacao = (Date)map.get("dataLiberacao");
            String nrAleatorioAcesso = (String)map.get("nrAleatorioAcesso");
            Short publicado = (Short)map.get("publicado");
            Short inativoVer = (Short)map.get("inativoVer");
            Long codigoVersaoMin = (Long)map.get("codigoVersaoMin");
            String descricaoAlteracoes = (String)map.get("descricaoAlteracoes");
            String alteracao = (String)map.get("alteracao");
            Optional<DTOImportacaoBIRes> found = ret.stream().filter(i -> this.isEquals(idClassificacao, i.getIdentificador())).findFirst();
            if (found.isPresent()) {
                dto = found.get();
            } else {
                dto = new DTOImportacaoBIRes();
                dto.setIdentificador(idClassificacao);
                dto.setDescricao(classificacao);
                ret.add(dto);
            }
            Optional<DTOImportacaoBIRes.ImportacaoBIRes> foundImpBI = dto.getImportacoesBI().stream().filter(i -> this.isEquals(numeroControle, i.getNumeroControle())).findFirst();
            DTOImportacaoBIRes.ImportacaoBIRes i2 = null;
            if (foundImpBI.isPresent()) {
                i2 = foundImpBI.get();
            } else {
                i2 = new DTOImportacaoBIRes.ImportacaoBIRes();
                i2.setIdentificador(identificador);
                i2.setDescricao(descricao);
                i2.setNumeroBI(numeroBI);
                i2.setNumeroControle(numeroControle);
                i2.setObservacoes(observacoes);
                i2.setSerialLocalBI(serialLocalBI);
                i2.setTipoClassificacaoBI(tipoClassificacaoBI);
                dto.getImportacoesBI().add(i2);
            }
            Optional<DTOImportacaoBIRes.RepositorioBIRes> foundRepBI = i2.getRepositoriosBI().stream().filter(j -> this.isEquals(numeroControle, j.getIdentificador())).findFirst();
            DTOImportacaoBIRes.RepositorioBIRes repositorio = null;
            if (foundRepBI.isPresent()) {
                repositorio = foundRepBI.get();
            } else {
                repositorio = new DTOImportacaoBIRes.RepositorioBIRes();
                repositorio.setDescricao(descricaoRep);
                repositorio.setIdentificador(idRepositorio);
                repositorio.setInativo(inativoRep);
                repositorio.setNomeBi(nomeBi);
                repositorio.setNumeroVersao(numeroVersaoRep);
                repositorio.setAlteracao(alteracao);
                repositorio.setVersaosRepositorioBI(new ArrayList());
                i2.getRepositoriosBI().add(repositorio);
            }
            if ((foundVersaoBI = repositorio.getVersaosRepositorioBI().stream().filter(k -> this.isEquals(numeroVersaoVer, k.getNumeroVersao())).findFirst()).isPresent()) continue;
            DTOImportacaoBIRes.RepositorioVersaoRes versao = new DTOImportacaoBIRes.RepositorioVersaoRes();
            versao.setCodigoVersaoMinSistema(codigoVersaoMin);
            versao.setDataLiberacao(dataLiberacao);
            versao.setIdentificador(identificadorVersao);
            versao.setInativo(inativoVer);
            versao.setNrAleatorioAcesso(nrAleatorioAcesso);
            versao.setNumeroVersao(numeroVersaoVer);
            versao.setPublicado(publicado);
            versao.setDescricaoAlteracoes(descricaoAlteracoes);
            repositorio.getVersaosRepositorioBI().add(versao);
        }
        return ret;
    }

    public List<DTOImportacaoBIConsulta> getImportacoesBINumeroAleatorio(String nrAleatorioAcesso, String cnpj, EnumConstTipoRepositorioBI tipo) {
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        if (tipo == null) {
            tipo = EnumConstTipoRepositorioBI.BI;
        }
        List<ImportacaoBi> importacoes = ((DaoImportacaoBiImpl)this.getDao()).getImportacoesBINumeroAleatorio(nrAleatorioAcesso, cnpj, tipo);
        List<DTOImportacaoBIConsulta> ret = this.buildToDTO(importacoes, DTOImportacaoBIConsulta.class);
        for (DTOImportacaoBIConsulta d : ret) {
            for (DTOImportacaoBIConsulta.TempRepositorioBI repositorio : d.getRepositorios()) {
                repositorio.getVersaosRepositorioBI().removeIf(i -> !this.isEquals(i.getNrAleatorioAcesso(), nrAleatorioAcesso));
            }
        }
        return ret;
    }

    public List<ImportacaoBi> getImportacaoBINodo(Nodo nodo, EnumConstTipoRepositorioBI tipo) {
        return ((DaoImportacaoBiImpl)this.getDao()).getImportaocaoBINodo(nodo, tipo);
    }

    public List<DTOImportacaoBIConsulta> getBIRepositorioDestaque(String cnpj, EnumConstTipoRepositorioBI tipo) {
        cnpj = ValidadeCPFCNPJ.getBaseCNPJ((String)cnpj);
        List<Map<String, Object>> importacoes = ((DaoImportacaoBiImpl)this.getDao()).getBIRepositorioDestaque(cnpj, tipo);
        return this.buildDTOImportacaoBIConsulta(importacoes);
    }
}

