/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.importacaobi;

import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.model.vo.ImportacaoBi;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RepositorioBi;
import com.touchcomp.basementor.model.vo.VersaoRepositorioBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.businessintelligence.CompBusinessIntelligence;
import com.touchcomp.basementorservice.service.impl.importacaobi.ServiceImportacaoBiImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIImportacao;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceImportacaoBiRepositorioImpl {
    @Autowired
    private ServiceImportacaoBiImpl serviceImportacaoBI;
    @Autowired
    private ServiceNodoImpl serviceNodo;
    @Autowired
    private ServicePessoaImpl servicePessoaImpl;
    @Autowired
    private CompBusinessIntelligence compBusinessIntelligence;

    public DTOImportacaoBIImportacao receiveAndProcessBI(DTOImportacaoBIImportacao msg, EnumConstTipoRepositorioBI tipoRepo) throws ExceptionInvalidData, ExceptionReflection {
        Pessoa resp = this.servicePessoaImpl.getByCPFCNPJAtiva(msg.getCpfPessoaReponsavel());
        if (resp == null) {
            throw new ExceptionInvalidData("E.ERP.0747.001", new Object[]{msg.getCpfPessoaReponsavel()});
        }
        ImportacaoBi imp = this.getImportacaoBI(msg, tipoRepo);
        RepositorioBi rep = this.getAndBuildRepositorioBI(msg, imp, resp);
        VersaoRepositorioBI ver = this.getAndBuildVersao(msg, rep, resp);
        imp = this.serviceImportacaoBI.saveOrUpdate(imp);
        ToolDTOBuilder builder = new ToolDTOBuilder(ImportacaoBi.class, DTOImportacaoBIImportacao.class);
        DTOImportacaoBIImportacao dto = (DTOImportacaoBIImportacao)builder.toDTO((Object)imp);
        dto.setNumeroVersao(ver.getNumeroVersao());
        dto.setNumeroVersaoRep(rep.getNumeroVersao());
        dto.setNumeroEstrutura(ver.getNrVersaoEstruturaBI());
        return dto;
    }

    private String getNumeroControle() {
        Long res = this.serviceImportacaoBI.getMaxNrControle();
        if (res == null) {
            res = 0L;
        }
        res = res + 1L;
        return ToolString.completaZeros((String)String.valueOf(res), (int)6, (boolean)true);
    }

    private Long getVersaoRepositorio(ImportacaoBi imp) {
        OptionalLong op = imp.getRepositorios().stream().mapToLong(i -> i.getNumeroVersao()).max();
        if (op.isPresent()) {
            return op.getAsLong() + 1L;
        }
        return 1L;
    }

    private Long getMaxNrVersao(RepositorioBi rep) {
        OptionalLong op = rep.getVersaosRepositorioBI().stream().mapToLong(i -> i.getNumeroVersao()).max();
        if (op.isPresent()) {
            return op.getAsLong() + 1L;
        }
        return 1L;
    }

    private RepositorioBi getAndBuildRepositorioBI(DTOImportacaoBIImportacao msg, ImportacaoBi imp, Pessoa resp) {
        Optional<RepositorioBi> found;
        if (msg.getTipoAlteracao() == 2 && (found = imp.getRepositorios().stream().filter(i -> TMethods.isEquals((Object)i.getNumeroVersao(), (Object)msg.getNumeroVersaoRep())).findFirst()).isPresent()) {
            return found.get();
        }
        RepositorioBi rep = new RepositorioBi();
        rep.setVersaosRepositorioBI(new LinkedList());
        rep.setNumeroVersao(Long.valueOf(1L));
        rep.setDescricao(msg.getDescricao());
        rep.setImportacaoBi(imp);
        rep.setNomeBi(msg.getNomeBI());
        rep.setPessoaResponsavel(resp);
        rep.setTipoBi(msg.getTipoBI());
        rep.setNodos(this.getNodos(msg.getNodos()));
        rep.setNumeroVersao(this.getVersaoRepositorio(imp));
        imp.getRepositorios().add(rep);
        rep.setAlteracao(msg.getAlteracao());
        rep.setDataUltimaModificacao(new Date());
        rep.setTipo(msg.getTipo());
        return rep;
    }

    private ImportacaoBi getImportacaoBI(DTOImportacaoBIImportacao msg, EnumConstTipoRepositorioBI tipoRepo) {
        ImportacaoBi imp = this.serviceImportacaoBI.getBySerial(msg.getSerialLocalBI());
        if (imp == null) {
            imp = new ImportacaoBi();
            imp.setRepositorios(new LinkedList());
            imp.setNumeroControle(this.getNumeroControle());
            imp.setSerialLocalBI(this.compBusinessIntelligence.generateSerialBI(msg, tipoRepo));
            imp.setDescricao(msg.getNomeBI());
            imp.setObservacoes(msg.getDescricao());
            imp.setTipoRepositorioBI(Short.valueOf(tipoRepo.getValue()));
        }
        return imp;
    }

    private List<Nodo> getNodos(List<Long> nodos) {
        if (nodos == null || nodos.isEmpty()) {
            return new ArrayList<Nodo>();
        }
        return this.serviceNodo.gets(nodos.toArray(new Long[0]));
    }

    private VersaoRepositorioBI getAndBuildVersao(DTOImportacaoBIImportacao msg, RepositorioBi rep, Pessoa resp) {
        Optional<VersaoRepositorioBI> found;
        OptionalLong maxVer = rep.getVersaosRepositorioBI().stream().mapToLong(i -> i.getNumeroVersao()).max();
        VersaoRepositorioBI ver = null;
        if (maxVer.isPresent() && (found = rep.getVersaosRepositorioBI().stream().filter(i -> TMethods.isEquals((Object)i.getNumeroVersao(), (Object)maxVer.getAsLong()) && !TMethods.isAffirmative((Number)i.getPublicado())).findFirst()).isPresent()) {
            ver = found.get();
        }
        if (ver == null) {
            ver = new VersaoRepositorioBI();
            ver.setNumeroVersao(this.getMaxNrVersao(rep));
            rep.getVersaosRepositorioBI().add(ver);
        }
        ver.setConteudoBI(msg.getArquivoBI().getBytes());
        ver.setDescricaoAlteracoes(msg.getAlteracao());
        ver.setPessoaResponsavel(resp);
        ver.setRepositorioBI(rep);
        ver.setPublicado(Short.valueOf((short)0));
        ver.setDataEnvio(new Date());
        ver.setNrVersaoEstruturaBI(msg.getNumeroEstrutura());
        if (!ToolMethods.isWithData((Number)ver.getNrVersaoEstruturaBI())) {
            ver.setNrVersaoEstruturaBI(Integer.valueOf(1));
        }
        return ver;
    }
}

