/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos;

import com.touchcomp.basementor.constants.enums.impostos.EnumConstantsTipoImp;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTipoAliqCBSIBS;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTpAplicacaoIBSCBS;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.model.vo.AliquotaPadraoImposto;
import com.touchcomp.basementor.model.vo.AliquotaReferenciaImposto;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClassNcm;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.aliquotapadraoimposto.ServiceAliquotaPadraoImpostoImpl;
import com.touchcomp.basementorservice.service.impl.aliquotareferenciaimposto.ServiceAliquotaReferenciaImpostoImpl;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibsclassncm.ServiceParamTribCbsIbsClassNcmImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;

public class AuxSetParamsCbsIbsOld {
    final ServiceParamTribCbsIbsClassNcmImpl serviceParamTribCbsIbsClassNcmImpl;
    final ServiceAliquotaPadraoImpostoImpl serviceAliquotaPadraoImpostoImpl;
    final ServiceAliquotaReferenciaImpostoImpl serviceAliquotaReferenciaImpostoImpl;

    public AuxSetParamsCbsIbsOld(ServiceParamTribCbsIbsClassNcmImpl serviceParamTribCbsIbsClassNcmImpl, ServiceAliquotaPadraoImpostoImpl serviceAliquotaPadraoImpostoImpl, ServiceAliquotaReferenciaImpostoImpl serviceAliquotaReferenciaImpostoImpl) {
        this.serviceParamTribCbsIbsClassNcmImpl = serviceParamTribCbsIbsClassNcmImpl;
        this.serviceAliquotaPadraoImpostoImpl = serviceAliquotaPadraoImpostoImpl;
        this.serviceAliquotaReferenciaImpostoImpl = serviceAliquotaReferenciaImpostoImpl;
    }

    public ClassificacaoTributariaCbsIbs getCodClassTributaria(Date dataEmissao, Empresa empresa, Ncm ncm, ModeloFiscalCbsIbs modelo, EnumConstModDocFiscal modeloDocFiscal, Cfop cfop) throws ExceptionInvalidData {
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = modelo.getIncidenciaTributariaClass();
        if (incidenciaTributariaClass == null) {
            ParamTribCbsIbsClassNcm found = this.serviceParamTribCbsIbsClassNcmImpl.getParametrizacaoOld(dataEmissao, empresa, ncm, modelo.getIncidenciaTributaria(), modeloDocFiscal, cfop);
            if (found == null) {
                throw new ExceptionInvalidData("E.ERP.2022.002", new Object[]{empresa, ncm, modelo.getIncidenciaTributaria(), dataEmissao});
            }
            incidenciaTributariaClass = found.getParamTribCbsIbsClass().getClassificacaoTrib();
        }
        return incidenciaTributariaClass;
    }

    public Double getAliquota(Date dataEmissao, Cidade cidade, ModeloFiscalCbsIbs modelo, EnumConstantsTipoImp tipoImposto, Double aliqInformada) throws ExceptionInvalidData {
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            return aliqInformada;
        }
        AliquotaReferenciaImposto aliquotaReferencia = this.serviceAliquotaReferenciaImpostoImpl.getAliquotaReferenciaImposto(tipoImposto, dataEmissao);
        if (aliquotaReferencia == null) {
            throw new ExceptionInvalidData("E.ERP.2022.001", new Object[]{tipoImposto.getDescricao(), dataEmissao});
        }
        Double aliquota = aliquotaReferencia.getValor();
        AliquotaPadraoImposto aliquotaPadrao = null;
        switch (tipoImposto) {
            case IBS_MUN: {
                aliquotaPadrao = this.serviceAliquotaPadraoImpostoImpl.getAliquota(aliquotaReferencia, cidade, dataEmissao);
                break;
            }
            case IBS_UF: {
                aliquotaPadrao = this.serviceAliquotaPadraoImpostoImpl.getAliquota(aliquotaReferencia, cidade.getUf(), dataEmissao);
                break;
            }
        }
        if (aliquotaPadrao != null) {
            EnumConstantsTpAplicacaoIBSCBS formaApp = EnumConstantsTpAplicacaoIBSCBS.get((Object)aliquotaPadrao.getTipoAplicacao());
            switch (formaApp) {
                case SOMAR: {
                    aliquota = aliquota + aliquotaPadrao.getValor();
                    break;
                }
                case SUBTRAIR: {
                    aliquota = aliquota - aliquotaPadrao.getValor();
                    if (!(aliquota < 0.0)) break;
                    aliquota = 0.0;
                    break;
                }
                default: {
                    aliquota = aliquotaPadrao.getValor();
                }
            }
        }
        return aliquota;
    }

    public Double getRedBC(ClassificacaoTributariaCbsIbs codClassTrib, ModeloFiscalCbsIbs modelo) {
        Double percRedBC = codClassTrib.getPercRedBaseCalculo();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedBC = modelo.getPercRedBC();
        }
        return percRedBC;
    }
}

