/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo;

import com.touchcomp.basementor.constants.enums.modelocbsibs.EnumConstModCbsIbsIndValorBC;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteItemCbs;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaCbs;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.RpsItemCbs;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.CompImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.CBSInterfaceCalculo;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.adapters.CteCBSCalcAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.adapters.ItemNotaPropriaCBSCalcAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.adapters.RpsCBSCalcAdapter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class SCompCBScalculo {
    CompImpostoCbsIbs compCalculo = CompImpostoCbsIbs.get();

    public void calcular(ItemNotaFiscalPropria item) throws ExceptionImpostoCbsIbs {
        if (item.getImpostoCBS() == null) {
            item.setImpostoCBS(new ItemNotaPropriaCbs());
        }
        if (ToolMethods.isAffirmative((Number)item.getImpostoCBS().getInfomarManualmente())) {
            return;
        }
        this.calcularInternal(new ItemNotaPropriaCBSCalcAdapter(item));
    }

    public void calcular(Rps rps) throws ExceptionImpostoCbsIbs {
        if (rps.getImpostoCBS() == null) {
            rps.setImpostoCBS(new RpsItemCbs());
        }
        this.calcularInternal(new RpsCBSCalcAdapter(rps));
    }

    public void calcular(Cte cte) throws ExceptionImpostoCbsIbs {
        if (cte.getCteVlrImpostos().getImpostoCBS() == null) {
            cte.getCteVlrImpostos().setImpostoCBS(new CteItemCbs());
        }
        this.calcularInternal(new CteCBSCalcAdapter(cte));
    }

    private void calcularInternal(CBSInterfaceCalculo item) throws ExceptionImpostoCbsIbs {
        if (item.getModeloFiscalCbsIbs() == null) {
            return;
        }
        if (item.getClassificacaoTributariaCbsIbs() == null) {
            return;
        }
        CbsIbsParams params = this.buildParams(item, item.getClassificacaoTributariaCbsIbs(), item.getAliquotaCBS(), item.getPercRedAliquotaCBS());
        CbsIbsCalculado calc = this.compCalculo.calcular(params.build());
        item.setAliquotaCBS(calc.getAliquota());
        item.setBaseCalculoCBS(calc.getBaseCalculo());
        item.setAliquotaEfetivaCBS(calc.getAliquotaEfetiva());
        item.setValorCBS(calc.getValor());
        if (ToolMethods.isAffirmative((Number)item.getClassificacaoTributariaCbsIbs().getIndGrupoTribReg()) && item.getClassificacaoTributariaCbsIbsReg() != null) {
            params = this.buildParams(item, item.getClassificacaoTributariaCbsIbsReg(), item.getAliquotaCBSReg(), item.getClassificacaoTributariaCbsIbsReg().getPercRedAliquotaCBS());
            calc = this.compCalculo.calcular(params.build());
            item.setAliquotaCBSReg(calc.getAliquota());
            item.setAliquotaEfetivaCBSReg(calc.getAliquotaEfetiva());
            item.setValorCBSReg(calc.getValor());
        }
    }

    private CbsIbsParams buildParams(CBSInterfaceCalculo item, ClassificacaoTributariaCbsIbs classificacao, Double aliquotaCbs, Double percRedAliquotaCbs) {
        CbsIbsParams params = new CbsIbsParams();
        params.setAliquota(aliquotaCbs);
        params.setPercRedAliquota(percRedAliquotaCbs);
        params.setIncluirFreteBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiFreteBC()));
        params.setIncluirSeguroBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiSeguroBC()));
        params.setIncluirValorDescontoBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiDescontoBC()));
        params.setIncluirValorDespAcessBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiDespAcessBC()));
        params.setIncluirValorCofinsBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiCofinsBC()));
        params.setIncluirValorPisBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiPisBC()));
        params.setIncluirValorIcmsBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsBC()));
        params.setIncluirValorIsBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiImpostoSeletivoBC()));
        params.setIncluirValorIssBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIssBC()));
        params.setIncluirValorIpiBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIpiBC()));
        params.setIncluirValorIIBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIIBC()));
        params.setModoArredondamento(item.getModoArredondamento());
        params.setPercRedBC(item.getPercRedBC());
        params.setQuantidade(item.getQuantidade());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setValorDesconto(item.getValorDesconto());
        params.setValorDespAcess(item.getValorDespAcess());
        params.setValorFrete(item.getValorFrete());
        params.setValorSeguro(item.getValorSeguro());
        params.setVrProdServ(item.getValorProdutosServicos());
        params.setIncidenciaCbsIbs(EnumConstNFeIncidenciaCbsIbs.valueOfCodigo((String)classificacao.getIncidenciaCbsIbs().getCodigo()));
        params.setCalcularCbsIbs(classificacao.getCalcularCbsIbs());
        params.setValorIss(item.getValorIss());
        params.setValorIcms(item.getValorIcms());
        params.setValorImpostoSeletivo(item.getImpostoSeletivo());
        params.setValorPis(item.getValorPis());
        params.setValorCofins(item.getValorCofins());
        params.setValorIpi(item.getValorIpi());
        params.setValorII(item.getValorImpostoImportacao());
        if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SOMA.getCodigo())) {
            params.setValorOutrosImpostosSoma(item.getValorIcmsST());
        } else if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SUBTRAI.getCodigo())) {
            params.setValorOutrosImpostosSubtrai(item.getValorIcmsST());
        }
        return params;
    }
}

