/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteItemCbs;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.CBSInterfaceCalculo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class CteCBSCalcAdapter
implements CBSInterfaceCalculo {
    final Cte cte;
    final CteItemCbs itemCbs;

    public CteCBSCalcAdapter(Cte cte) {
        this.cte = cte;
        this.itemCbs = cte.getCteVlrImpostos().getImpostoCBS();
    }

    @Override
    public void setAliquotaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaCBS(Double.valueOf(aliquotaCBS));
    }

    @Override
    public void setAliquotaEfetivaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaEfetivaCBS(Double.valueOf(aliquotaCBS));
    }

    @Override
    public void setBaseCalculoCBS(double baseCalculo) {
        this.itemCbs.setBaseCalculoCBS(Double.valueOf(baseCalculo));
    }

    @Override
    public void setValorCBS(double valorCBS) {
        this.itemCbs.setValorCBS(Double.valueOf(valorCBS));
    }

    @Override
    public Double getAliquotaCBS() {
        return this.itemCbs.getAliquotaCBS();
    }

    @Override
    public Double getPercRedAliquotaCBS() {
        return this.itemCbs.getPercRedAliquotaCBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return 1.0;
    }

    @Override
    public Double getValorDesconto() {
        return this.cte.getCteVlrImpostos().getVrDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return 0.0;
    }

    @Override
    public Double getValorFrete() {
        return 0.0;
    }

    @Override
    public Double getValorSeguro() {
        return 0.0;
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.cte.getCteVlrImpostos().getVrPrestacao();
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        if (ToolMethods.isAffirmative((Number)this.itemCbs.getInfomarManualmente())) {
            return EnumConstTipoCalcImp.NAO_CALCULAR;
        }
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        if (!ToolMethods.isAnyNull((Object[])new Object[]{this.cte.getCteVlrImpostos(), this.cte.getCteVlrImpostos().getImpostoCBS()})) {
            return this.cte.getCteVlrImpostos().getImpostoCBS().getIncidenciaTributariaClass();
        }
        return null;
    }

    @Override
    public Double getValorIss() {
        return 0.0;
    }

    @Override
    public Double getValorIcms() {
        if (this.cte.getCteVlrImpostos() == null) {
            return 0.0;
        }
        return this.cte.getCteVlrImpostos().getVrIcms();
    }

    @Override
    public Double getImpostoSeletivo() {
        return 0.0;
    }

    @Override
    public Double getValorPis() {
        if (this.cte.getCteVlrImpostos() == null) {
            return 0.0;
        }
        return this.cte.getCteVlrImpostos().getVrPis();
    }

    @Override
    public Double getValorCofins() {
        if (this.cte.getCteVlrImpostos() == null) {
            return 0.0;
        }
        return this.cte.getCteVlrImpostos().getVrCofins();
    }

    @Override
    public Double getValorIpi() {
        return 0.0;
    }

    @Override
    public Double getValorImpostoImportacao() {
        return 0.0;
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.cte.getParamTribCbsIbsClass();
    }

    @Override
    public void setAliquotaCBSReg(Double aliquota) {
        this.itemCbs.setAliquotaCBSReg(aliquota);
    }

    @Override
    public void setAliquotaEfetivaCBSReg(Double aliquotaEfetiva) {
        this.itemCbs.setAliquotaEfetivaCBSReg(aliquotaEfetiva);
    }

    @Override
    public void setValorCBSReg(Double valor) {
        this.itemCbs.setValorCBSReg(valor);
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemCbs.getIncidenciaTributariaClassReg();
    }

    @Override
    public Double getAliquotaCBSReg() {
        return this.itemCbs.getAliquotaCBSReg();
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.cte.getModeloFiscalCte() != null && this.cte.getModeloFiscalCte().getModeloFiscalCbsIbs() != null) {
            return this.cte.getModeloFiscalCte().getModeloFiscalCbsIbs();
        }
        if (this.cte.getParamTribCbsIbsClass() != null) {
            return this.cte.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Double getValorIcmsST() {
        return 0.0;
    }
}

