/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaCbs;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.CBSInterfaceCalculo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class ItemNotaPropriaCBSCalcAdapter
implements CBSInterfaceCalculo {
    final ItemNotaFiscalPropria item;
    final ItemNotaPropriaCbs itemCbs;

    public ItemNotaPropriaCBSCalcAdapter(ItemNotaFiscalPropria item) {
        this.item = item;
        this.itemCbs = item.getImpostoCBS();
    }

    @Override
    public void setAliquotaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaCBS(Double.valueOf(aliquotaCBS));
    }

    @Override
    public void setAliquotaEfetivaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaEfetivaCBS(Double.valueOf(aliquotaCBS));
    }

    @Override
    public void setBaseCalculoCBS(double baseCalculo) {
        this.itemCbs.setBaseCalculoCBS(Double.valueOf(baseCalculo));
    }

    @Override
    public void setValorCBS(double valorCBS) {
        this.itemCbs.setValorCBS(Double.valueOf(valorCBS));
    }

    @Override
    public Double getAliquotaCBS() {
        return this.itemCbs.getAliquotaCBS();
    }

    @Override
    public Double getPercRedAliquotaCBS() {
        return this.itemCbs.getPercRedAliquotaCBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return this.item.getQuantidadeTotal();
    }

    @Override
    public Double getValorDesconto() {
        return this.item.getValorDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return this.item.getValorDespAcessoria();
    }

    @Override
    public Double getValorFrete() {
        return this.item.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.item.getVrSeguro();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.item.getVrProduto() + this.item.getVrServico();
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        if (ToolMethods.isAffirmative((Number)this.item.getImpostoCBS().getInfomarManualmente())) {
            return EnumConstTipoCalcImp.NAO_CALCULAR;
        }
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.item.getImpostoCBS() != null ? this.item.getImpostoCBS().getIncidenciaTributariaClass() : null;
    }

    @Override
    public Double getValorIss() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIss();
    }

    @Override
    public Double getValorIcms() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIcms();
    }

    @Override
    public Double getImpostoSeletivo() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIss();
    }

    @Override
    public Double getValorPis() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrPis();
    }

    @Override
    public Double getValorCofins() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrCofins();
    }

    @Override
    public Double getValorIpi() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIpiIndustria() + this.item.getItemNotaLivroFiscal().getVrIpiComercio();
    }

    @Override
    public Double getValorImpostoImportacao() {
        if (this.item.getImpostoSeletivo() == null) {
            return 0.0;
        }
        return this.item.getImpostoSeletivo().getValorIS();
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.item.getParamTribCbsIbsClass();
    }

    @Override
    public void setAliquotaCBSReg(Double aliquota) {
        this.itemCbs.setAliquotaCBSReg(aliquota);
    }

    @Override
    public void setAliquotaEfetivaCBSReg(Double aliquotaEfetiva) {
        this.itemCbs.setAliquotaEfetivaCBSReg(aliquotaEfetiva);
    }

    @Override
    public void setValorCBSReg(Double valor) {
        this.itemCbs.setValorCBSReg(valor);
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemCbs.getIncidenciaTributariaClassReg();
    }

    @Override
    public Double getAliquotaCBSReg() {
        return this.itemCbs.getAliquotaCBSReg();
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.item.getModeloFiscal() != null && this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return this.item.getModeloFiscal().getModeloFiscalCbsIbs();
        }
        if (this.item.getParamTribCbsIbsClass() != null) {
            return this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Double getValorIcmsST() {
        return this.item.getItemNotaLivroFiscal() != null ? this.item.getItemNotaLivroFiscal().getVrIcmsSt() : 0.0;
    }
}

