/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.RpsItemCbs;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.CBSInterfaceCalculo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class RpsCBSCalcAdapter
implements CBSInterfaceCalculo {
    final Rps rps;
    final RpsItemCbs itemCbs;

    public RpsCBSCalcAdapter(Rps rps) {
        this.rps = rps;
        this.itemCbs = rps.getImpostoCBS();
    }

    @Override
    public void setAliquotaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaCBS(Double.valueOf(aliquotaCBS));
    }

    @Override
    public void setAliquotaEfetivaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaEfetivaCBS(Double.valueOf(aliquotaCBS));
    }

    @Override
    public void setBaseCalculoCBS(double baseCalculo) {
        this.itemCbs.setBaseCalculoCBS(Double.valueOf(baseCalculo));
    }

    @Override
    public void setValorCBS(double valorCBS) {
        this.itemCbs.setValorCBS(Double.valueOf(valorCBS));
    }

    @Override
    public Double getAliquotaCBS() {
        return this.itemCbs.getAliquotaCBS();
    }

    @Override
    public Double getPercRedAliquotaCBS() {
        return this.itemCbs.getPercRedAliquotaCBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return 1.0;
    }

    @Override
    public Double getValorDesconto() {
        return 0.0;
    }

    @Override
    public Double getValorDespAcess() {
        return 0.0;
    }

    @Override
    public Double getValorFrete() {
        return 0.0;
    }

    @Override
    public Double getValorSeguro() {
        return 0.0;
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.rps.getValorServico();
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        if (ToolMethods.isAffirmative((Number)this.rps.getImpostoCBS().getInfomarManualmente())) {
            return EnumConstTipoCalcImp.NAO_CALCULAR;
        }
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.rps.getImpostoCBS() != null ? this.rps.getImpostoCBS().getIncidenciaTributariaClass() : null;
    }

    @Override
    public Double getValorIss() {
        return this.rps.getValorIss();
    }

    @Override
    public Double getValorIcms() {
        return 0.0;
    }

    @Override
    public Double getImpostoSeletivo() {
        return 0.0;
    }

    @Override
    public Double getValorPis() {
        return this.rps.getValorPis();
    }

    @Override
    public Double getValorCofins() {
        return this.rps.getValorCofins();
    }

    @Override
    public Double getValorIpi() {
        return 0.0;
    }

    @Override
    public Double getValorImpostoImportacao() {
        return 0.0;
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.rps.getParamTribCbsIbsClass();
    }

    @Override
    public void setAliquotaCBSReg(Double aliquota) {
        this.itemCbs.setAliquotaCBSReg(aliquota);
    }

    @Override
    public void setAliquotaEfetivaCBSReg(Double aliquotaEfetiva) {
        this.itemCbs.setAliquotaEfetivaCBSReg(aliquotaEfetiva);
    }

    @Override
    public void setValorCBSReg(Double valor) {
        this.itemCbs.setValorCBSReg(valor);
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemCbs.getIncidenciaTributariaClassReg();
    }

    @Override
    public Double getAliquotaCBSReg() {
        return this.itemCbs.getAliquotaCBSReg();
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.rps.getModeloRps() != null && this.rps.getModeloRps().getModeloFiscalCbsIbs() != null) {
            return this.rps.getModeloRps().getModeloFiscalCbsIbs();
        }
        if (this.rps.getParamTribCbsIbsClass() != null) {
            return this.rps.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Double getValorIcmsST() {
        return 0.0;
    }
}

