/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.cbs.params;

import com.touchcomp.basementor.constants.enums.impostos.EnumConstantsTipoImp;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTipoAliqCBSIBS;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteItemCbs;
import com.touchcomp.basementor.model.vo.CteVlrImpostos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaCbs;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.RpsItemCbs;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.aliquotapadraoimposto.ServiceAliquotaPadraoImpostoImpl;
import com.touchcomp.basementorservice.service.impl.aliquotareferenciaimposto.ServiceAliquotaReferenciaImpostoImpl;
import com.touchcomp.basementorservice.service.impl.impostos.AuxSetParamsCbsIbs;
import com.touchcomp.basementorservice.service.impl.impostos.AuxSetParamsCbsIbsOld;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.params.CBSInterfaceSetParams;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.params.adapters.CteCBSAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.params.adapters.ItemNotaPropriaCBSAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.params.adapters.RpsCBSAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.EnumConstTipoMov;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibsclassncm.ServiceParamTribCbsIbsClassNcmImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class SCompCBSParams {
    final ServiceParamTribCbsIbsClassNcmImpl serviceParamTribCbsIbsClassNcmImpl;
    final ServiceAliquotaPadraoImpostoImpl serviceAliquotaPadraoImpostoImpl;
    final ServiceAliquotaReferenciaImpostoImpl serviceAliquotaReferenciaImpostoImpl;

    public SCompCBSParams(ServiceParamTribCbsIbsClassNcmImpl serviceParamTribCbsIbsClassNcmImpl, ServiceAliquotaPadraoImpostoImpl serviceAliquotaPadraoImpostoImpl, ServiceAliquotaReferenciaImpostoImpl serviceAliquotaReferenciaImpostoImpl) {
        this.serviceParamTribCbsIbsClassNcmImpl = serviceParamTribCbsIbsClassNcmImpl;
        this.serviceAliquotaPadraoImpostoImpl = serviceAliquotaPadraoImpostoImpl;
        this.serviceAliquotaReferenciaImpostoImpl = serviceAliquotaReferenciaImpostoImpl;
    }

    public void setParams(ItemNotaFiscalPropria item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal) throws ExceptionInvalidData {
        if (item.getImpostoCBS() == null) {
            item.setImpostoCBS(new ItemNotaPropriaCbs());
        }
        this.setParamsInternal(new ItemNotaPropriaCBSAdapter(item, empresa, dataEmissao, modeloDocFiscal));
    }

    public void setParams(Rps rps) throws ExceptionInvalidData {
        if (rps.getImpostoCBS() == null) {
            rps.setImpostoCBS(new RpsItemCbs());
        }
        this.setParamsInternal(new RpsCBSAdapter(rps));
    }

    public void setParams(Cte cte) throws ExceptionInvalidData {
        if (cte.getCteVlrImpostos() == null) {
            cte.setCteVlrImpostos(new CteVlrImpostos());
        }
        if (cte.getCteVlrImpostos().getImpostoCBS() == null) {
            cte.getCteVlrImpostos().setImpostoCBS(new CteItemCbs());
        }
        this.setParamsInternal(new CteCBSAdapter(cte));
    }

    void setParamsInternal(CBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCBSIBS() != null) {
            this.setParamsInternalOld(item);
        } else {
            this.setParamsInternalNew(item);
        }
    }

    void setParamsInternalNew(CBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getParamTribCBSIBS() == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbs auxSet = new AuxSetParamsCbsIbs(this.serviceAliquotaPadraoImpostoImpl, this.serviceAliquotaReferenciaImpostoImpl);
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = item.getParamTribCBSIBS().getClassificacaoTrib();
        item.setClassificacaoCBS(incidenciaTributariaClass);
        item.setIncidenciaCBS(incidenciaTributariaClass.getIncidenciaCbsIbs());
        ModeloFiscalCbsIbs modelo = item.getParamTribCBSIBS().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        Double percRedAliqCBS = incidenciaTributariaClass.getPercRedAliquotaCBS();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqCBS = modelo.getPercRedAliquotaCBS();
        }
        item.setAliquotaCBS(auxSet.getAliquota(dataEmissao, null, EnumConstantsTipoAliqCBSIBS.get((Object)modelo.getTipoAliquota()), EnumConstantsTipoImp.CBS, modelo.getAliquotaCBS()));
        item.setAliquotaPresumidaCBS(modelo.getAliquotaCBS());
        item.setPercRedAliquotaCBS(percRedAliqCBS);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        if (ToolMethods.isAffirmative((Number)incidenciaTributariaClass.getIndGrupoTribReg())) {
            item.setClassificacaoCBSReg(item.getParamTribCBSIBS().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncidenciaTributariaClassReg());
            item.setIncidenciaCBSReg(item.getParamTribCBSIBS().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncidenciaTributariaReg());
            item.setAliquotaCBSReg(auxSet.getAliquota(dataEmissao, null, EnumConstantsTipoAliqCBSIBS.CONFORME_PARAMETRIZACAO, EnumConstantsTipoImp.CBS, 0.0));
        } else {
            item.setClassificacaoCBSReg(null);
            item.setIncidenciaCBSReg(null);
            item.setAliquotaCBSReg(0.0);
        }
    }

    void setParamsInternalOld(CBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCBSIBS() == null) {
            return;
        }
        ModeloFiscalCbsIbs modelo = item.getModeloFiscalCBSIBS();
        if (modelo == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbsOld auxSet = new AuxSetParamsCbsIbsOld(this.serviceParamTribCbsIbsClassNcmImpl, this.serviceAliquotaPadraoImpostoImpl, this.serviceAliquotaReferenciaImpostoImpl);
        item.setIncidenciaCBS(modelo.getIncidenciaTributaria());
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = modelo.getIncidenciaTributariaClass();
        if ((item.getTipoMov().equals((Object)EnumConstTipoMov.RPS) || item.getTipoMov().equals((Object)EnumConstTipoMov.CTE)) && incidenciaTributariaClass == null) {
            throw new ExceptionInvalidData("E.ERP.2022.003", new Object[]{modelo});
        }
        if (incidenciaTributariaClass == null) {
            incidenciaTributariaClass = auxSet.getCodClassTributaria(dataEmissao, item.getEmpresa(), item.getNcm(), modelo, item.getModeloDocFiscal(), item.getCfop());
            item.setClassificacaoCBS(incidenciaTributariaClass);
        }
        Double percRedAliqCBS = incidenciaTributariaClass.getPercRedAliquotaCBS();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqCBS = modelo.getPercRedAliquotaCBS();
        }
        item.setClassificacaoCBS(modelo.getIncidenciaTributariaClass());
        item.setAliquotaCBS(auxSet.getAliquota(dataEmissao, null, modelo, EnumConstantsTipoImp.CBS, modelo.getAliquotaCBS()));
        item.setAliquotaPresumidaCBS(modelo.getAliquotaCBS());
        item.setPercRedAliquotaCBS(percRedAliqCBS);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        item.setClassificacaoCBS(incidenciaTributariaClass);
    }
}

