/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo;

import com.touchcomp.basementor.constants.enums.modelocbsibs.EnumConstModCbsIbsIndValorBC;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteItemIbs;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIbs;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.RpsItemIbs;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.CompImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.adapters.CteIBSCalcAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.adapters.ItemNotaPropriaIBSCalcAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.adapters.RpsIBSCalcAdapter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class SCompIBScalculo {
    CompImpostoCbsIbs compCalculo = CompImpostoCbsIbs.get();

    public void calcular(ItemNotaFiscalPropria item) throws ExceptionImpostoCbsIbs {
        if (item.getImpostoIBS() == null) {
            item.setImpostoIBS(new ItemNotaPropriaIbs());
        }
        if (ToolMethods.isAffirmative((Number)item.getImpostoIBS().getInfomarManualmente())) {
            return;
        }
        this.calcularValores(new ItemNotaPropriaIBSCalcAdapter(item));
    }

    public void calcular(Rps rps) throws ExceptionImpostoCbsIbs {
        if (rps.getImpostoIBS() == null) {
            rps.setImpostoIBS(new RpsItemIbs());
        }
        this.calcularValores(new RpsIBSCalcAdapter(rps));
    }

    public void calcular(Cte cte) throws ExceptionImpostoCbsIbs {
        if (cte.getCteVlrImpostos().getImpostoIBS() == null) {
            cte.getCteVlrImpostos().setImpostoIBS(new CteItemIbs());
        }
        this.calcularValores(new CteIBSCalcAdapter(cte));
    }

    protected void calcularValores(IBSInterfaceCalculo item) throws ExceptionImpostoCbsIbs {
        CbsIbsParams params = new CbsIbsParams();
        if (item.getClassificacaoTributariaCbsIbs() == null) {
            return;
        }
        if (item.getModeloFiscalCbsIbs() == null) {
            return;
        }
        this.buildCommonParamsIbsMun(item, params);
        CbsIbsCalculado calc = this.compCalculo.calcular(params.build());
        item.setAliquotaIBSMun(calc.getAliquota());
        item.setAliquotaEfetivaIBSMun(calc.getAliquotaEfetiva());
        item.setValorBaseCalcIBS(calc.getBaseCalculo());
        item.setValorIBSMun(calc.getValor());
        if (ToolMethods.isAffirmative((Number)item.getClassificacaoTributariaCbsIbs().getIndGrupoTribReg()) && item.getClassificacaoTributariaCbsIbsReg() != null) {
            params = new CbsIbsParams();
            this.buildCommonParamsIbsMunReg(item, params);
            calc = this.compCalculo.calcular(params.build());
            item.setAliquotaEfetivaIBSMunReg(calc.getAliquotaEfetiva());
            item.setValorIBSMunReg(calc.getValor());
        }
        this.buildCommonParamsIbsUF(item, params);
        calc = this.compCalculo.calcular(params.build());
        item.setAliquotaIBSUF(calc.getAliquota());
        item.setAliquotaEfetivaIBSUF(calc.getAliquotaEfetiva());
        item.setValorBaseCalcIBS(calc.getBaseCalculo());
        item.setValorIBSUF(calc.getValor());
        if (ToolMethods.isAffirmative((Number)item.getClassificacaoTributariaCbsIbs().getIndGrupoTribReg()) && item.getClassificacaoTributariaCbsIbsReg() != null) {
            params = new CbsIbsParams();
            this.buildCommonParamsIbsUFReg(item, params);
            calc = this.compCalculo.calcular(params.build());
            item.setAliquotaEfetivaIBSUFReg(calc.getAliquotaEfetiva());
            item.setValorIBSUFReg(calc.getValor());
        }
    }

    void buildCommonParams(IBSInterfaceCalculo item, CbsIbsParams params, ClassificacaoTributariaCbsIbs classificacao) {
        params.setIncluirFreteBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiFreteBC()));
        params.setIncluirSeguroBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiSeguroBC()));
        params.setIncluirValorDescontoBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiDescontoBC()));
        params.setIncluirValorDespAcessBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiDespAcessBC()));
        params.setIncluirValorCofinsBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiCofinsBC()));
        params.setIncluirValorPisBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiPisBC()));
        params.setIncluirValorIcmsBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsBC()));
        params.setIncluirValorIsBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiImpostoSeletivoBC()));
        params.setIncluirValorIssBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIssBC()));
        params.setIncluirValorIpiBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIpiBC()));
        params.setIncluirValorIIBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIIBC()));
        params.setModoArredondamento(item.getModoArredondamento());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setPercRedBC(item.getPercRedBC());
        params.setQuantidade(item.getQuantidade());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setValorDesconto(item.getValorDesconto());
        params.setValorDespAcess(item.getValorDespAcess());
        params.setValorFrete(item.getValorFrete());
        params.setValorSeguro(item.getValorSeguro());
        params.setVrProdServ(item.getValorProdutosServicos());
        params.setValorIss(item.getValorIss());
        params.setValorIcms(item.getValorIcms());
        params.setValorImpostoSeletivo(item.getImpostoSeletivo());
        params.setValorPis(item.getValorPis());
        params.setValorCofins(item.getValorCofins());
        params.setValorIpi(item.getValorIpi());
        params.setValorII(item.getValorImpostoImportacao());
        if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SOMA.getCodigo())) {
            params.setValorOutrosImpostosSoma(item.getValorIcmsST());
        } else if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SUBTRAI.getCodigo())) {
            params.setValorOutrosImpostosSubtrai(item.getValorIcmsST());
        }
        params.setIncidenciaCbsIbs(EnumConstNFeIncidenciaCbsIbs.valueOfCodigo((String)classificacao.getIncidenciaCbsIbs().getCodigo()));
        params.setCalcularCbsIbs(classificacao.getCalcularCbsIbs());
    }

    void buildCommonParamsIbsUF(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbs());
        params.setAliquota(item.getAliquotaIBSUF());
        params.setPercRedAliquota(item.getPercRedAliquotaIBSUF());
    }

    void buildCommonParamsIbsMun(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbs());
        params.setAliquota(item.getAliquotaIBSMun());
        params.setPercRedAliquota(item.getPercRedAliquotaIBSMun());
    }

    void buildCommonParamsIbsUFReg(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbsReg());
        params.setAliquota(item.getAliquotaIBSUFReg());
        params.setPercRedAliquota(item.getClassificacaoTributariaCbsIbsReg().getPercRedAliquotaIBSUF());
    }

    void buildCommonParamsIbsMunReg(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbsReg());
        params.setAliquota(item.getAliquotaIBSMunReg());
        params.setPercRedAliquota(item.getClassificacaoTributariaCbsIbsReg().getPercRedAliquotaIBSMun());
    }
}

