/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteItemIbs;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class CteIBSCalcAdapter
implements IBSInterfaceCalculo {
    final Cte cte;
    final CteItemIbs itemIbs;

    public CteIBSCalcAdapter(Cte cte) {
        this.cte = cte;
        this.itemIbs = cte.getCteVlrImpostos().getImpostoIBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return 1.0;
    }

    @Override
    public Double getValorDesconto() {
        return this.cte.getCteVlrImpostos().getVrDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return 0.0;
    }

    @Override
    public Double getValorFrete() {
        return 0.0;
    }

    @Override
    public Double getValorSeguro() {
        return 0.0;
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        if (ToolMethods.isAffirmative((Number)this.itemIbs.getInfomarManualmente())) {
            return EnumConstTipoCalcImp.NAO_CALCULAR;
        }
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public void setAliquotaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaIBSMun(Double.valueOf(aliquota));
    }

    @Override
    public void setAliquotaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaIBSUF(Double.valueOf(aliquota));
    }

    @Override
    public void setValorBaseCalcIBS(double baseCalculo) {
        this.itemIbs.setValorBaseCalcIBS(Double.valueOf(baseCalculo));
    }

    @Override
    public void setValorIBSMun(double valor) {
        this.itemIbs.setValorIBSMun(Double.valueOf(valor));
    }

    @Override
    public void setValorIBSUF(double valor) {
        this.itemIbs.setValorIBSUF(Double.valueOf(valor));
    }

    @Override
    public Double getAliquotaIBSMun() {
        return this.itemIbs.getAliquotaIBSMun();
    }

    @Override
    public Double getAliquotaIBSUF() {
        return this.itemIbs.getAliquotaIBSUF();
    }

    @Override
    public Double getPercRedAliquotaIBSMun() {
        return this.itemIbs.getPercRedAliquotaIBSMun();
    }

    @Override
    public Double getPercRedAliquotaIBSUF() {
        return this.itemIbs.getPercRedAliquotaIBSUF();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.cte.getCteVlrImpostos().getVrPrestacao();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        if (this.cte.getCteVlrImpostos() == null || this.cte.getCteVlrImpostos().getImpostoIBS() == null) {
            return null;
        }
        return this.cte.getCteVlrImpostos().getImpostoIBS().getIncidenciaTributariaClass();
    }

    @Override
    public Double getValorIss() {
        return 0.0;
    }

    @Override
    public Double getValorIcms() {
        if (this.cte.getCteVlrImpostos() == null) {
            return 0.0;
        }
        return this.cte.getCteVlrImpostos().getVrIcms();
    }

    @Override
    public Double getImpostoSeletivo() {
        return 0.0;
    }

    @Override
    public Double getValorPis() {
        if (this.cte.getCteVlrImpostos() == null) {
            return 0.0;
        }
        return this.cte.getCteVlrImpostos().getVrPis();
    }

    @Override
    public Double getValorCofins() {
        if (this.cte.getCteVlrImpostos() == null) {
            return 0.0;
        }
        return this.cte.getCteVlrImpostos().getVrCofins();
    }

    @Override
    public Double getValorIpi() {
        return 0.0;
    }

    @Override
    public Double getValorImpostoImportacao() {
        return 0.0;
    }

    @Override
    public void setAliquotaEfetivaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSMun(Double.valueOf(aliquota));
    }

    @Override
    public void setAliquotaEfetivaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSUF(Double.valueOf(aliquota));
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.cte.getParamTribCbsIbsClass();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemIbs.getIncidenciaTributariaClassReg();
    }

    @Override
    public Double getAliquotaIBSUFReg() {
        return this.itemIbs.getAliquotaIBSUFReg();
    }

    @Override
    public Double getAliquotaIBSMunReg() {
        return this.itemIbs.getAliquotaIBSMunReg();
    }

    @Override
    public void setAliquotaEfetivaIBSUFReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSUFReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSUFReg(Double valor) {
        this.itemIbs.setValorIBSUFReg(valor);
    }

    @Override
    public void setAliquotaEfetivaIBSMunReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSMunReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSMunReg(Double valor) {
        this.itemIbs.setValorIBSMunReg(valor);
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.cte.getModeloFiscalCte() != null && this.cte.getModeloFiscalCte().getModeloFiscalCbsIbs() != null) {
            return this.cte.getModeloFiscalCte().getModeloFiscalCbsIbs();
        }
        if (this.cte.getParamTribCbsIbsClass() != null) {
            return this.cte.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Double getValorIcmsST() {
        return 0.0;
    }
}

