/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIbs;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class ItemNotaPropriaIBSCalcAdapter
implements IBSInterfaceCalculo {
    final ItemNotaFiscalPropria item;
    final ItemNotaPropriaIbs itemIbs;

    public ItemNotaPropriaIBSCalcAdapter(ItemNotaFiscalPropria item) {
        this.item = item;
        this.itemIbs = item.getImpostoIBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return this.item.getQuantidadeTotal();
    }

    @Override
    public Double getValorDesconto() {
        return this.item.getValorDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return this.item.getValorDespAcessoria();
    }

    @Override
    public Double getValorFrete() {
        return this.item.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.item.getVrSeguro();
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        if (ToolMethods.isAffirmative((Number)this.item.getImpostoCBS().getInfomarManualmente())) {
            return EnumConstTipoCalcImp.NAO_CALCULAR;
        }
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public void setAliquotaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaIBSMun(Double.valueOf(aliquota));
    }

    @Override
    public void setAliquotaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaIBSUF(Double.valueOf(aliquota));
    }

    @Override
    public void setValorBaseCalcIBS(double baseCalculo) {
        this.itemIbs.setValorBaseCalcIBS(Double.valueOf(baseCalculo));
    }

    @Override
    public void setValorIBSMun(double valor) {
        this.itemIbs.setValorIBSMun(Double.valueOf(valor));
    }

    @Override
    public void setValorIBSUF(double valor) {
        this.itemIbs.setValorIBSUF(Double.valueOf(valor));
    }

    @Override
    public Double getAliquotaIBSMun() {
        return this.itemIbs.getAliquotaIBSMun();
    }

    @Override
    public Double getAliquotaIBSUF() {
        return this.itemIbs.getAliquotaIBSUF();
    }

    @Override
    public Double getPercRedAliquotaIBSMun() {
        return this.itemIbs.getPercRedAliquotaIBSMun();
    }

    @Override
    public Double getPercRedAliquotaIBSUF() {
        return this.itemIbs.getPercRedAliquotaIBSUF();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.item.getVrProduto() + this.item.getVrServico();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.item.getImpostoIBS() != null ? this.item.getImpostoIBS().getIncidenciaTributariaClass() : null;
    }

    @Override
    public Double getValorIss() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIss();
    }

    @Override
    public Double getValorIcms() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIcms();
    }

    @Override
    public Double getImpostoSeletivo() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIss();
    }

    @Override
    public Double getValorPis() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrPis();
    }

    @Override
    public Double getValorCofins() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrCofins();
    }

    @Override
    public Double getValorIpi() {
        if (this.item.getItemNotaLivroFiscal() == null) {
            return 0.0;
        }
        return this.item.getItemNotaLivroFiscal().getVrIpiIndustria() + this.item.getItemNotaLivroFiscal().getVrIpiComercio();
    }

    @Override
    public Double getValorImpostoImportacao() {
        if (this.item.getItemNotaLivroFiscal() != null) {
            return this.item.getItemNotaLivroFiscal().getVrImpostoImportacao();
        }
        return 0.0;
    }

    @Override
    public void setAliquotaEfetivaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSMun(Double.valueOf(aliquota));
    }

    @Override
    public void setAliquotaEfetivaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSUF(Double.valueOf(aliquota));
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.item.getParamTribCbsIbsClass();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemIbs.getIncidenciaTributariaClassReg();
    }

    @Override
    public Double getAliquotaIBSUFReg() {
        return this.itemIbs.getAliquotaIBSUFReg();
    }

    @Override
    public Double getAliquotaIBSMunReg() {
        return this.itemIbs.getAliquotaIBSMunReg();
    }

    @Override
    public void setAliquotaEfetivaIBSUFReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSUFReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSUFReg(Double valor) {
        this.itemIbs.setValorIBSUFReg(valor);
    }

    @Override
    public void setAliquotaEfetivaIBSMunReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSMunReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSMunReg(Double valor) {
        this.itemIbs.setValorIBSMunReg(valor);
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.item.getModeloFiscal() != null && this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return this.item.getModeloFiscal().getModeloFiscalCbsIbs();
        }
        if (this.item.getParamTribCbsIbsClass() != null) {
            return this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Double getValorIcmsST() {
        return this.item.getItemNotaLivroFiscal() != null ? this.item.getItemNotaLivroFiscal().getVrIcmsSt() : 0.0;
    }
}

