/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.RpsItemIbs;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class RpsIBSCalcAdapter
implements IBSInterfaceCalculo {
    final Rps rps;
    final RpsItemIbs itemIbs;

    public RpsIBSCalcAdapter(Rps rps) {
        this.rps = rps;
        this.itemIbs = rps.getImpostoIBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return 1.0;
    }

    @Override
    public Double getValorDesconto() {
        return this.rps.getValorDescontoIncondicionado() + this.rps.getValorDeducoes();
    }

    @Override
    public Double getValorDespAcess() {
        return 0.0;
    }

    @Override
    public Double getValorFrete() {
        return 0.0;
    }

    @Override
    public Double getValorSeguro() {
        return 0.0;
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        if (ToolMethods.isAffirmative((Number)this.rps.getImpostoCBS().getInfomarManualmente())) {
            return EnumConstTipoCalcImp.NAO_CALCULAR;
        }
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public void setAliquotaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaIBSMun(Double.valueOf(aliquota));
    }

    @Override
    public void setAliquotaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaIBSUF(Double.valueOf(aliquota));
    }

    @Override
    public void setValorBaseCalcIBS(double baseCalculo) {
        this.itemIbs.setValorBaseCalcIBS(Double.valueOf(baseCalculo));
    }

    @Override
    public void setValorIBSMun(double valor) {
        this.itemIbs.setValorIBSMun(Double.valueOf(valor));
    }

    @Override
    public void setValorIBSUF(double valor) {
        this.itemIbs.setValorIBSUF(Double.valueOf(valor));
    }

    @Override
    public Double getAliquotaIBSMun() {
        return this.itemIbs.getAliquotaIBSMun();
    }

    @Override
    public Double getAliquotaIBSUF() {
        return this.itemIbs.getAliquotaIBSUF();
    }

    @Override
    public Double getPercRedAliquotaIBSMun() {
        return this.itemIbs.getPercRedAliquotaIBSMun();
    }

    @Override
    public Double getPercRedAliquotaIBSUF() {
        return this.itemIbs.getPercRedAliquotaIBSUF();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.rps.getValorServico();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.rps.getImpostoIBS() != null ? this.rps.getImpostoIBS().getIncidenciaTributariaClass() : null;
    }

    @Override
    public Double getValorIss() {
        return this.rps.getValorIss();
    }

    @Override
    public Double getValorIcms() {
        return 0.0;
    }

    @Override
    public Double getImpostoSeletivo() {
        return 0.0;
    }

    @Override
    public Double getValorPis() {
        return this.rps.getValorPis();
    }

    @Override
    public Double getValorCofins() {
        return this.rps.getValorCofins();
    }

    @Override
    public Double getValorIpi() {
        return 0.0;
    }

    @Override
    public Double getValorImpostoImportacao() {
        return 0.0;
    }

    @Override
    public void setAliquotaEfetivaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSMun(Double.valueOf(aliquota));
    }

    @Override
    public void setAliquotaEfetivaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSUF(Double.valueOf(aliquota));
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.rps.getParamTribCbsIbsClass();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemIbs.getIncidenciaTributariaClassReg();
    }

    @Override
    public Double getAliquotaIBSUFReg() {
        return this.itemIbs.getAliquotaIBSUFReg();
    }

    @Override
    public Double getAliquotaIBSMunReg() {
        return this.itemIbs.getAliquotaIBSMunReg();
    }

    @Override
    public void setAliquotaEfetivaIBSUFReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSUFReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSUFReg(Double valor) {
        this.itemIbs.setValorIBSUFReg(valor);
    }

    @Override
    public void setAliquotaEfetivaIBSMunReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSMunReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSMunReg(Double valor) {
        this.itemIbs.setValorIBSMunReg(valor);
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.rps.getModeloRps() != null && this.rps.getModeloRps().getModeloFiscalCbsIbs() != null) {
            return this.rps.getModeloRps().getModeloFiscalCbsIbs();
        }
        if (this.rps.getParamTribCbsIbsClass() != null) {
            return this.rps.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Double getValorIcmsST() {
        return 0.0;
    }
}

