/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.ibs.params;

import com.touchcomp.basementor.constants.enums.impostos.EnumConstantsTipoImp;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTipoAliqCBSIBS;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteVlrImpostos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIbs;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.RpsItemIbs;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.aliquotapadraoimposto.ServiceAliquotaPadraoImpostoImpl;
import com.touchcomp.basementorservice.service.impl.aliquotareferenciaimposto.ServiceAliquotaReferenciaImpostoImpl;
import com.touchcomp.basementorservice.service.impl.impostos.AuxSetParamsCbsIbs;
import com.touchcomp.basementorservice.service.impl.impostos.AuxSetParamsCbsIbsOld;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.EnumConstTipoMov;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.IBSInterfaceSetParams;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.adapters.CteIBSAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.adapters.ItemNotaPropriaIBSAdapter;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.adapters.RpsIBSAdapter;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibsclassncm.ServiceParamTribCbsIbsClassNcmImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class SCompIBSParams {
    final ServiceParamTribCbsIbsClassNcmImpl serviceParamTribCbsIbsClassNcmImpl;
    final ServiceAliquotaPadraoImpostoImpl serviceAliquotaPadraoImpostoImpl;
    final ServiceAliquotaReferenciaImpostoImpl serviceAliquotaReferenciaImpostoImpl;

    public SCompIBSParams(ServiceParamTribCbsIbsClassNcmImpl serviceParamTribCbsIbsClassNcmImpl, ServiceAliquotaPadraoImpostoImpl serviceAliquotaPadraoImpostoImpl, ServiceAliquotaReferenciaImpostoImpl serviceAliquotaReferenciaImpostoImpl) {
        this.serviceParamTribCbsIbsClassNcmImpl = serviceParamTribCbsIbsClassNcmImpl;
        this.serviceAliquotaPadraoImpostoImpl = serviceAliquotaPadraoImpostoImpl;
        this.serviceAliquotaReferenciaImpostoImpl = serviceAliquotaReferenciaImpostoImpl;
    }

    public void setParams(ItemNotaFiscalPropria item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal, Cidade cidadeCliente) throws ExceptionInvalidData {
        if (item.getImpostoIBS() == null) {
            item.setImpostoIBS(new ItemNotaPropriaIbs());
        }
        this.setParamsInternal(new ItemNotaPropriaIBSAdapter(item, empresa, dataEmissao, modeloDocFiscal, cidadeCliente));
    }

    public void setParams(Rps rps) throws ExceptionInvalidData {
        if (rps.getImpostoIBS() == null) {
            rps.setImpostoIBS(new RpsItemIbs());
        }
        this.setParamsInternal(new RpsIBSAdapter(rps));
    }

    public void setParams(Cte cte) throws ExceptionInvalidData {
        if (cte.getCteVlrImpostos() == null) {
            cte.setCteVlrImpostos(new CteVlrImpostos());
        }
        this.setParamsInternal(new CteIBSAdapter(cte));
    }

    private void setParamsInternal(IBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCBSIBS() != null) {
            this.setParamsInternalOld(item);
        } else {
            this.setParamsInternalNew(item);
        }
    }

    private void setParamsInternalNew(IBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getParamTribCbsIbs() == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        if (item.getCidadeCliente() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbs auxSet = new AuxSetParamsCbsIbs(this.serviceAliquotaPadraoImpostoImpl, this.serviceAliquotaReferenciaImpostoImpl);
        item.setIncidenciaIBS(item.getParamTribCbsIbs().getClassificacaoTrib().getIncidenciaCbsIbs());
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = item.getParamTribCbsIbs().getClassificacaoTrib();
        item.setClassificacaoIBS(incidenciaTributariaClass);
        Double percRedAliqIBSMun = incidenciaTributariaClass.getPercRedAliquotaIBSMun();
        Double percRedAliqIBSUF = incidenciaTributariaClass.getPercRedAliquotaIBSUF();
        ModeloFiscalCbsIbs modelo = item.getParamTribCbsIbs().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqIBSMun = modelo.getPercRedAliquotaIBSMun();
            percRedAliqIBSUF = modelo.getPercRedAliquotaIBSUF();
        }
        item.setPercRedAliquotaIBSMun(percRedAliqIBSMun);
        item.setPercRedAliquotaIBSUF(percRedAliqIBSUF);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        item.setAliquotaIBSMun(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), EnumConstantsTipoAliqCBSIBS.get((Object)modelo.getTipoAliquota()), EnumConstantsTipoImp.IBS_MUN, modelo.getAliquotaIBSMun()));
        item.setAliquotaIBSUF(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), EnumConstantsTipoAliqCBSIBS.get((Object)modelo.getTipoAliquota()), EnumConstantsTipoImp.IBS_UF, modelo.getAliquotaIBSUF()));
        if (ToolMethods.isAffirmative((Number)incidenciaTributariaClass.getIndGrupoTribReg())) {
            item.setClassificacaoCBSReg(item.getParamTribCbsIbs().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncidenciaTributariaClassReg());
            item.setIncidenciaCBSReg(item.getParamTribCbsIbs().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncidenciaTributariaReg());
            item.setAliquotaIbsMunReg(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), EnumConstantsTipoAliqCBSIBS.CONFORME_PARAMETRIZACAO, EnumConstantsTipoImp.IBS_MUN, 0.0));
            item.setAliquotaIbsUFReg(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), EnumConstantsTipoAliqCBSIBS.CONFORME_PARAMETRIZACAO, EnumConstantsTipoImp.IBS_UF, 0.0));
        } else {
            item.setClassificacaoCBSReg(null);
            item.setIncidenciaCBSReg(null);
            item.setAliquotaIbsMunReg(0.0);
            item.setAliquotaIbsUFReg(0.0);
        }
    }

    private void setParamsInternalOld(IBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCBSIBS() == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        if (item.getCidadeCliente() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbsOld auxSet = new AuxSetParamsCbsIbsOld(this.serviceParamTribCbsIbsClassNcmImpl, this.serviceAliquotaPadraoImpostoImpl, this.serviceAliquotaReferenciaImpostoImpl);
        ModeloFiscalCbsIbs modelo = item.getModeloFiscalCBSIBS();
        item.setIncidenciaIBS(modelo.getIncidenciaTributaria());
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = modelo.getIncidenciaTributariaClass();
        if ((item.getTipoMov().equals((Object)EnumConstTipoMov.RPS) || item.getTipoMov().equals((Object)EnumConstTipoMov.CTE)) && incidenciaTributariaClass == null) {
            throw new ExceptionInvalidData("E.ERP.2022.003", new Object[]{modelo});
        }
        if (incidenciaTributariaClass == null) {
            incidenciaTributariaClass = auxSet.getCodClassTributaria(dataEmissao, item.getEmpresa(), item.getNcm(), modelo, item.getModeloDocFiscal(), item.getCfop());
        }
        item.setClassificacaoIBS(incidenciaTributariaClass);
        Double percRedAliqIBSMun = incidenciaTributariaClass.getPercRedAliquotaIBSMun();
        Double percRedAliqIBSUF = incidenciaTributariaClass.getPercRedAliquotaIBSUF();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqIBSMun = modelo.getPercRedAliquotaIBSMun();
            percRedAliqIBSUF = modelo.getPercRedAliquotaIBSUF();
        }
        item.setPercRedAliquotaIBSMun(percRedAliqIBSMun);
        item.setPercRedAliquotaIBSUF(percRedAliqIBSUF);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        item.setAliquotaIBSMun(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), modelo, EnumConstantsTipoImp.IBS_MUN, modelo.getAliquotaIBSMun()));
        item.setAliquotaIBSUF(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), modelo, EnumConstantsTipoImp.IBS_UF, modelo.getAliquotaIBSUF()));
    }
}

