/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.ibs.params.adapters;

import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaCbsIbs;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.EnumConstTipoMov;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.IBSInterfaceSetParams;
import java.util.Date;

public class ItemNotaPropriaIBSAdapter
implements IBSInterfaceSetParams {
    final ItemNotaFiscalPropria item;
    final Empresa empresa;
    final Date dataEmissao;
    final Cidade cidade;
    final ModeloDocFiscal modeloDocFiscal;

    public ItemNotaPropriaIBSAdapter(ItemNotaFiscalPropria item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal, Cidade cidade) {
        this.item = item;
        this.empresa = empresa;
        this.dataEmissao = dataEmissao;
        this.modeloDocFiscal = modeloDocFiscal;
        this.cidade = cidade;
    }

    @Override
    public void setIncidenciaIBS(IncidenciaCbsIbs incidencia) {
        this.item.getImpostoIBS().setIncidenciaTributaria(incidencia);
    }

    @Override
    public void setClassificacaoIBS(ClassificacaoTributariaCbsIbs classificacao) {
        this.item.getImpostoIBS().setIncidenciaTributariaClass(classificacao);
    }

    @Override
    public void setAliquotaIBSUF(Double aliquota) {
        this.item.getImpostoIBS().setAliquotaIBSUF(aliquota);
    }

    @Override
    public void setAliquotaIBSMun(Double aliquota) {
        this.item.getImpostoIBS().setAliquotaIBSMun(aliquota);
    }

    @Override
    public void setPercRedAliquotaIBSUF(Double aliquota) {
        this.item.getImpostoIBS().setPercRedAliquotaIBSUF(aliquota);
    }

    @Override
    public void setPercRedAliquotaIBSMun(Double aliquota) {
        this.item.getImpostoIBS().setPercRedAliquotaIBSMun(aliquota);
    }

    @Override
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Override
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Override
    public Ncm getNcm() {
        if (this.item.getNcm() != null) {
            return this.item.getNcm();
        }
        return this.item.getProduto() != null ? this.item.getProduto().getNcm() : null;
    }

    @Override
    public EnumConstModDocFiscal getModeloDocFiscal() {
        return EnumConstModDocFiscal.get((Object)this.modeloDocFiscal.getCodigo());
    }

    @Override
    public void setPercRedBC(Double percRedBC) {
        this.item.getImpostoIBS().setPercRedBC(percRedBC);
    }

    @Override
    public Cidade getCidadeCliente() {
        return this.cidade;
    }

    @Override
    public Cfop getCfop() {
        return this.item.getItemNotaLivroFiscal() != null ? this.item.getItemNotaLivroFiscal().getCfop() : null;
    }

    @Override
    public EnumConstTipoMov getTipoMov() {
        return EnumConstTipoMov.NOTA_PROPRIA;
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.item.getParamTribCbsIbsClass();
    }

    @Override
    public void setClassificacaoCBSReg(ClassificacaoTributariaCbsIbs incidenciaTributariaClassReg) {
        this.item.getImpostoIBS().setIncidenciaTributariaClassReg(incidenciaTributariaClassReg);
    }

    @Override
    public void setIncidenciaCBSReg(IncidenciaCbsIbs incidenciaTributariaReg) {
        this.item.getImpostoIBS().setIncidenciaTributariaReg(incidenciaTributariaReg);
    }

    @Override
    public void setAliquotaIbsMunReg(Double aliquota) {
        this.item.getImpostoIBS().setAliquotaIBSMunReg(aliquota);
    }

    @Override
    public void setAliquotaIbsUFReg(Double aliquota) {
        this.item.getImpostoIBS().setAliquotaIBSUFReg(aliquota);
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCBSIBS() {
        if (this.item.getModeloFiscal() != null) {
            return this.item.getModeloFiscal().getModeloFiscalCbsIbs();
        }
        return null;
    }
}

