/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.is.calculo;

import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIS;
import com.touchcomp.basementorrules.constants.EnumConstSimNaoImp;
import com.touchcomp.basementorrules.impostos.is.CompImpostoISeletivo;
import com.touchcomp.basementorrules.impostos.is.model.ISCalculado;
import com.touchcomp.basementorrules.impostos.is.model.ISParams;
import com.touchcomp.basementorservice.service.impl.impostos.is.calculo.ISInterfaceCalculo;
import com.touchcomp.basementorservice.service.impl.impostos.is.calculo.adapters.ItemNotaPropriaISCalcAdapter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class SCompIScalculo {
    public void calcular(ItemNotaFiscalPropria item) {
        if (item.getImpostoSeletivo() == null) {
            item.setImpostoSeletivo(new ItemNotaPropriaIS());
        }
        if (ToolMethods.isAffirmative((Number)item.getImpostoSeletivo().getInfomarManualmente())) {
            return;
        }
        this.calcularInternal(new ItemNotaPropriaISCalcAdapter(item));
    }

    private void calcularInternal(ISInterfaceCalculo item) {
        ISParams params = new ISParams();
        params.setAliquotaIS(item.getAliquotaIS());
        if (item.getModeloFiscalIs() == null) {
            return;
        }
        params.setIncluirFreteBC(EnumConstSimNaoImp.get((Object)item.getModeloFiscalIs().getIncluiFreteBC()));
        params.setIncluirSeguroBC(EnumConstSimNaoImp.get((Object)item.getModeloFiscalIs().getIncluiSeguroBC()));
        params.setIncluirValorDescontoBC(EnumConstSimNaoImp.get((Object)item.getModeloFiscalIs().getIncluiDescontoBC()));
        params.setIncluirValorDespAcessBC(EnumConstSimNaoImp.get((Object)item.getModeloFiscalIs().getIncluiDespAcessBC()));
        params.setModoArredondamento(item.getModoArredondamento());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setQuantidade(item.getQuantidade());
        params.setValorDesconto(item.getValorDesconto());
        params.setValorDespAcess(item.getValorDespAcess());
        params.setValorFrete(item.getValorFrete());
        params.setValorSeguro(item.getValorSeguro());
        params.setVrProdServ(item.getValorProdutosServicos());
        ISCalculado calc = CompImpostoISeletivo.get().calcular(params.build());
        item.setAliquotaIS(calc.getAliquotaIS());
        item.setBaseCalculo(calc.getBaseCalculo());
        item.setValorIS(calc.getValorIS());
    }
}

