/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.impostos.is.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIS;
import com.touchcomp.basementor.model.vo.ModeloFiscalIs;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorservice.service.impl.impostos.is.calculo.ISInterfaceCalculo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class ItemNotaPropriaISCalcAdapter
implements ISInterfaceCalculo {
    final ItemNotaFiscalPropria item;
    final ItemNotaPropriaIS itemIs;

    public ItemNotaPropriaISCalcAdapter(ItemNotaFiscalPropria item) {
        this.item = item;
        this.itemIs = item.getImpostoSeletivo();
    }

    @Override
    public Double getQuantidade() {
        return this.item.getQuantidadeTotal();
    }

    @Override
    public Double getValorDesconto() {
        return this.item.getValorDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return this.item.getValorDespAcessoria();
    }

    @Override
    public Double getValorFrete() {
        return this.item.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.item.getVrSeguro();
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        if (ToolMethods.isAffirmative((Number)this.item.getImpostoSeletivo().getInfomarManualmente())) {
            return EnumConstTipoCalcImp.NAO_CALCULAR;
        }
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public void setAliquotaIS(double aliquota) {
        this.itemIs.setAliquotaIS(Double.valueOf(aliquota));
    }

    @Override
    public void setBaseCalculo(double baseCalculo) {
        this.itemIs.setBaseCalculo(Double.valueOf(baseCalculo));
    }

    @Override
    public void setValorIS(double valor) {
        this.itemIs.setValorIS(Double.valueOf(valor));
    }

    @Override
    public Double getAliquotaIS() {
        return this.itemIs.getAliquotaIS();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.item.getVrProduto() + this.item.getVrServico();
    }

    @Override
    public ModeloFiscalIs getModeloFiscalIs() {
        return this.item.getModeloFiscal().getModeloFiscalIs();
    }
}

