/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.imptransfsaldocontabil;

import com.touchcomp.basementor.constants.enums.imptransfsaldocontabil.ConstEnumImpTransfSaldoContabil;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ImpTransfSaldoContabil;
import com.touchcomp.basementor.model.vo.ImpTransfSaldoContabilItem;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.imptransfsaldoscontabeis.CompLancamentoImpTransSaldosContabeis;
import com.touchcomp.basementorservice.dao.impl.DaoImpTransfSaldoContabilImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.touchvomodel.vo.imptransfsaldocontabilitem.web.DTOImpTransfSaldoContabilItem;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ServiceImpTransfSaldoContabilImpl
extends ServiceGenericEntityImpl<ImpTransfSaldoContabil, Long, DaoImpTransfSaldoContabilImpl> {
    private final CompLancamentoImpTransSaldosContabeis compLancamentoImpTransSaldosContabeis;
    ServicePlanoContaImpl servicePlanoContaImpl;

    public ServiceImpTransfSaldoContabilImpl(CompLancamentoImpTransSaldosContabeis compLancamentoImpTransSaldosContabeis, DaoImpTransfSaldoContabilImpl genericDao, ServicePlanoContaImpl servicePlanoContaImpl) {
        super(genericDao);
        this.compLancamentoImpTransSaldosContabeis = compLancamentoImpTransSaldosContabeis;
        this.servicePlanoContaImpl = servicePlanoContaImpl;
    }

    public ImpTransfSaldoContabil getImportacao(Empresa empresa, Date dataEscrituracao, ConstEnumImpTransfSaldoContabil tipoImportacao) {
        return ((DaoImpTransfSaldoContabilImpl)this.getDao()).get(empresa, dataEscrituracao, tipoImportacao);
    }

    @Override
    public ImpTransfSaldoContabil beforeSaveEntity(ImpTransfSaldoContabil aux) {
        for (ImpTransfSaldoContabilItem item : aux.getItensSaldo()) {
            item.setImpTransfSaldoContabil(aux);
            if (item.getEmpresaImportacao() == null) {
                item.setEmpresaImportacao(aux.getEmpresa());
            }
            if (item.getDataLancamento() == null) {
                item.setDataLancamento(aux.getDataEscrituracao());
            }
            item.setCodigoContaAlterado(Short.valueOf((short)1));
            if (item.getCentroResultadoContFin() != null || aux.getEmpresa() == null) continue;
            item.setCentroResultadoContFin(aux.getEmpresa().getEmpresaDados().getCentroResultadoContFin());
        }
        return aux;
    }

    @Override
    public ImpTransfSaldoContabil saveOrUpdateOnly(ImpTransfSaldoContabil entity) {
        try {
            this.compLancamentoImpTransSaldosContabeis.contabilizarImpTransf(entity);
            return super.saveOrUpdateOnly(entity);
        }
        catch (ExceptionInvalidData ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
    }

    public List<DTOImpTransfSaldoContabilItem> getImpTransfSaldoContabilItem(Long[] ids) {
        List planosConta = this.servicePlanoContaImpl.gets(ids);
        List impTransfSaldoContabilItem = planosConta.stream().map(i -> {
            ImpTransfSaldoContabilItem item = new ImpTransfSaldoContabilItem();
            item.setPlanoContaAtual(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(impTransfSaldoContabilItem, DTOImpTransfSaldoContabilItem.class);
    }
}

