/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indiceeconomico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.model.impl.LinhasIndiceEcoCalculado;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IndiceEconomico;
import com.touchcomp.basementor.model.vo.LinhasIndiceEconomico;
import com.touchcomp.basementor.model.vo.MetaControleContLinha;
import com.touchcomp.basementor.model.vo.MetaControleContLinhaVlr;
import com.touchcomp.basementor.model.vo.MetaControleContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.indiceeconomico.EnumExcepIndiceEconomico;
import com.touchcomp.basementorexceptions.exceptions.impl.indiceeconomico.ExceptionIndiceEconomico;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.encerramentocontabil.ServiceEncerramentoContabilPorCentroResultadoImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.basementorservice.service.impl.saldoconta.ServiceSaldoContaImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.jep.ToolJepExpressionParser;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AuxIndiceEconomico
extends BaseMethods {
    private final ServicePlanoContaImpl servicePlanoConta;
    private final ServiceSaldoContaImpl serviceSaldoConta;
    private static final TLogger logger = TLogger.get(AuxIndiceEconomico.class);

    public AuxIndiceEconomico(ServicePlanoContaImpl servicePlanoConta, ServiceSaldoContaImpl serviceSaldoConta) {
        this.servicePlanoConta = servicePlanoConta;
        this.serviceSaldoConta = serviceSaldoConta;
    }

    public List<HashMap> gerarIndiceEconomico(IndiceEconomico indiceEconomico, MetaControleContabil meta, GrupoEmpresa empresa, CentroResultadoContFin centroResultado, Date dataInicial, Date dataFinal, Integer tipoRel, Short imprimirDataAnteriores, Short desconsiderarEncerramento) throws ExceptionIndiceEconomico {
        Date dataInUmAnoAnterior = ToolDate.nextDays((Date)dataInicial, (int)1, (int)-1);
        Date dataFimUmAnoAnterior = ToolDate.nextDays((Date)dataFinal, (int)1, (int)-1);
        Date dataInDoisAnosAnteriores = ToolDate.nextDays((Date)dataInicial, (int)1, (int)-2);
        Date dataFimDoisAnosAnteriores = ToolDate.nextDays((Date)dataFinal, (int)1, (int)-2);
        return this.getValores(indiceEconomico, dataInicial, dataFinal, imprimirDataAnteriores, dataInUmAnoAnterior, dataFimUmAnoAnterior, dataInDoisAnosAnteriores, dataFimDoisAnosAnteriores, tipoRel, empresa, centroResultado, meta, desconsiderarEncerramento);
    }

    public List<LinhasIndiceEcoCalculado> gerarIndiceEconomico(IndiceEconomico indiceEconomico, MetaControleContabil meta, GrupoEmpresa empresa, Date dataInicial, Date dataFinal, Integer tipoRel, EnumConstantsMentorSimNao imprimirDataAnteriores) throws ExceptionIndiceEconomico {
        Date dataInUmAnoAnterior = ToolDate.nextDays((Date)dataInicial, (int)1, (int)-1);
        Date dataFimUmAnoAnterior = ToolDate.nextDays((Date)dataFinal, (int)1, (int)-1);
        Date dataInDoisAnosAnteriores = ToolDate.nextDays((Date)dataInicial, (int)1, (int)-2);
        Date dataFimDoisAnosAnteriores = ToolDate.nextDays((Date)dataFinal, (int)1, (int)-2);
        return this.getValores(indiceEconomico, dataInicial, dataFinal, imprimirDataAnteriores, dataInUmAnoAnterior, dataFimUmAnoAnterior, dataInDoisAnosAnteriores, dataFimDoisAnosAnteriores, tipoRel, empresa, meta);
    }

    private List<LinhasIndiceEcoCalculado> getValores(IndiceEconomico indiceEconomico, Date dataInicial, Date dataFinal, EnumConstantsMentorSimNao imprimirDataAnteriores, Date dataInUmAnoAnterior, Date dataFimUmAnoAnterior, Date dataInDoisAnosAnteriores, Date dataFimDoisAnosAnteriores, Integer tipoRel, GrupoEmpresa grupoEmpresa, MetaControleContabil meta) throws ExceptionIndiceEconomico {
        List lista = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInicial, dataFinal, grupoEmpresa, null, tipoRel, meta, null);
        ArrayList<LinhasIndiceEcoCalculado> maps = new ArrayList<LinhasIndiceEcoCalculado>();
        for (Object linha : lista) {
            LinhasIndiceEcoCalculado map = new LinhasIndiceEcoCalculado();
            map.setIdLinhaIndiceEconomico(linha.getIdentificador());
            map.setNrLinhaIndice(linha.getIndice());
            map.setDescricaoLinha(linha.getDescricao());
            map.setValor(linha.getValor());
            map.setValorMeta(linha.getValorMeta());
            map.setNegrito(linha.getNegrito());
            map.setDataInicial(dataInicial);
            map.setDataFinal(dataFinal);
            map.setLinha((LinhasIndiceEconomico)linha);
            maps.add(map);
        }
        if (this.isAffimative(imprimirDataAnteriores.getValue())) {
            List anoAnterior = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInUmAnoAnterior, dataFimUmAnoAnterior, grupoEmpresa, null, tipoRel, meta, null);
            for (LinhasIndiceEcoCalculado map : maps) {
                for (Object o : anoAnterior) {
                    LinhasIndiceEconomico linha = (LinhasIndiceEconomico)o;
                    if (!map.getIdLinhaIndiceEconomico().equals(linha.getIdentificador())) continue;
                    map.setValorUmAnoAntes(linha.getValor());
                    map.setDataInUmAnoAntes(dataInUmAnoAnterior);
                    map.setDataFimUmAnoAntes(dataFimUmAnoAnterior);
                }
            }
            List doisAnosAnteriores = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInDoisAnosAnteriores, dataFimDoisAnosAnteriores, grupoEmpresa, null, tipoRel, meta, null);
            for (LinhasIndiceEcoCalculado map : maps) {
                for (LinhasIndiceEconomico linha : doisAnosAnteriores) {
                    if (!map.getIdLinhaIndiceEconomico().equals(linha.getIdentificador())) continue;
                    map.setValorDoisAnosAntes(linha.getValor());
                    map.setDataInDoisAnosAntes(dataInDoisAnosAnteriores);
                    map.setDataFimDoisAnosAntes(dataFimDoisAnosAnteriores);
                }
            }
        }
        return maps;
    }

    private List<HashMap> getValores(IndiceEconomico indiceEconomico, Date dataInicial, Date dataFinal, Short imprimirDataAnteriores, Date dataInUmAnoAnterior, Date dataFimUmAnoAnterior, Date dataInDoisAnosAnteriores, Date dataFimDoisAnosAnteriores, Integer tipoRel, GrupoEmpresa grupoEmpresa, CentroResultadoContFin centroResultado, MetaControleContabil meta, Short desconsiderarEncerramento) throws ExceptionIndiceEconomico {
        List lista = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInicial, dataFinal, grupoEmpresa, centroResultado, tipoRel, meta, desconsiderarEncerramento);
        ArrayList<HashMap> maps = new ArrayList<HashMap>();
        for (Object linha : lista) {
            HashMap map = new HashMap();
            map.put("F_ID_LINHA_INDICE", linha.getIdentificador());
            map.put("F_NR_LINHA_INDICE", linha.getIndice());
            map.put("F_DESCRICAO_LINHA", linha.getDescricao());
            map.put("F_VALOR", linha.getValor());
            map.put("F_VALOR_META", linha.getValorMeta());
            map.put("F_NEGRITO", linha.getNegrito());
            map.put("F_DATA_INICIAL", dataInicial);
            map.put("F_DATA_FINAL", dataFinal);
            map.put("F_LINHA", linha);
            maps.add(map);
        }
        if (this.isAffimative(imprimirDataAnteriores)) {
            List anoAnterior = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInUmAnoAnterior, dataFimUmAnoAnterior, grupoEmpresa, centroResultado, tipoRel, meta, desconsiderarEncerramento);
            for (HashMap map : maps) {
                for (LinhasIndiceEconomico linha : anoAnterior) {
                    if (!map.get("F_ID_LINHA_INDICE").equals(linha.getIdentificador())) continue;
                    map.put("F_SALDO_UM_ANO_ANTES", linha.getValor());
                    map.put("F_DATA_IN_UM_ANO_ANT", dataInUmAnoAnterior);
                    map.put("F_DATA_FIM_UM_ANO_ANT", dataFimUmAnoAnterior);
                }
            }
            List doisAnosAnteriores = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInDoisAnosAnteriores, dataFimDoisAnosAnteriores, grupoEmpresa, centroResultado, tipoRel, meta, desconsiderarEncerramento);
            for (HashMap map : maps) {
                for (LinhasIndiceEconomico linha : doisAnosAnteriores) {
                    if (!map.get("F_ID_LINHA_INDICE").equals(linha.getIdentificador())) continue;
                    map.put("F_SALDO_DOIS_ANOS_ANTES", linha.getValor());
                    map.put("F_DATA_IN_DOIS_ANOS_ANT", dataInDoisAnosAnteriores);
                    map.put("F_DATA_FIM_DOIS_ANOS_ANT", dataFimDoisAnosAnteriores);
                }
            }
        }
        return maps;
    }

    public List getValuesFromRows(List<LinhasIndiceEconomico> linhas, Date dataInicial, Date dataFinal, GrupoEmpresa gr, CentroResultadoContFin centroResultado, Integer tipoRel, MetaControleContabil meta, Short desconsiderarEncerramento) throws ExceptionIndiceEconomico {
        this.orderLinhas(linhas);
        Double soma = 0.0;
        Double somaMeta = 0.0;
        Double valor = 0.0;
        Double valorMeta = 0.0;
        for (LinhasIndiceEconomico linha : linhas) {
            if (!this.isEquals(linha.getSinal(), 2)) {
                if (this.isAffimative(linha.getInformaValor())) {
                    valor = linha.getValor();
                    valorMeta = linha.getValorMeta();
                } else {
                    String descricaoLinha = linha.getIndice() + " - " + linha.getDescricao();
                    valor = this.getTotalFormula(linha.getExpressao(), dataInicial, dataFinal, linhas, gr, centroResultado, tipoRel, descricaoLinha, desconsiderarEncerramento);
                    valorMeta = this.getTotalFormulaMeta(linha.getExpressao(), linhas, dataInicial, dataFinal, meta, descricaoLinha);
                }
                valor = valor == null ? 0.0 : valor;
                valorMeta = valorMeta == null ? 0.0 : valorMeta;
                boolean isSub = this.isEquals(linha.getSinal(), 1);
                valor = isSub ? valor * -1.0 : valor;
                valorMeta = isSub ? valorMeta * -1.0 : valorMeta;
                linha.setValor(valor);
                linha.setValorMeta(valorMeta);
                linha.setDifMetaReal(Double.valueOf(valorMeta - valor));
                if (valorMeta != 0.0) {
                    linha.setPercMetaRealizado(Double.valueOf((valor / valorMeta - 1.0) * 100.0));
                } else {
                    linha.setPercMetaRealizado(Double.valueOf(0.0));
                }
                soma = soma + valor;
                somaMeta = somaMeta + valorMeta;
                continue;
            }
            linha.setValor(soma);
            linha.setValorMeta(somaMeta);
            linha.setDifMetaReal(Double.valueOf(somaMeta - soma));
            if (somaMeta != 0.0) {
                linha.setPercMetaRealizado(Double.valueOf((soma / somaMeta - 1.0) * 100.0));
                continue;
            }
            linha.setPercMetaRealizado(Double.valueOf(0.0));
        }
        return linhas;
    }

    private Double getTotalFormula(String expressao, Date dataInicial, Date dataFinal, List linhas, GrupoEmpresa gr, CentroResultadoContFin centroResultado, Integer tipoRel, String descricaoLinha, Short desconsiderarEncerramento) throws ExceptionIndiceEconomico {
        try {
            if (expressao == null || expressao.isEmpty()) {
                return 0.0;
            }
            List token = ToolString.getReplaceTokens((String)expressao);
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (StringToken sk : token) {
                m.put(sk.getChave(), this.getFixedValue(sk.getChave(), dataInicial, dataFinal, linhas, gr, centroResultado, tipoRel, descricaoLinha, desconsiderarEncerramento));
            }
            Double b = ToolJepExpressionParser.evaluate((String)expressao, m);
            if (b.isInfinite() || b.isNaN()) {
                return 0.0;
            }
            return b;
        }
        catch (ExceptionJEPParser ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.EXPRESSAO_INVALIDA, new Object[]{expressao});
        }
    }

    private Double getTotalFormulaMeta(String expressao, List linhas, Date dataInicial, Date dataFinal, MetaControleContabil meta, String descricaoLinha) throws ExceptionIndiceEconomico {
        try {
            if (expressao == null || expressao.isEmpty()) {
                return 0.0;
            }
            List token = ToolString.getReplaceTokens((String)expressao);
            HashMap<String, String> m = new HashMap<String, String>();
            for (StringToken sk : token) {
                Double valor = this.getFixedValueMeta(sk.getChave(), dataInicial, dataFinal, linhas, meta, descricaoLinha);
                if (this.isNull(valor).booleanValue()) {
                    valor = 0.0;
                }
                m.put(sk.getChave(), String.valueOf(valor));
            }
            Double b = ToolJepExpressionParser.evaluate((String)expressao, m);
            if (b.isInfinite() || b.isNaN()) {
                return 0.0;
            }
            return b;
        }
        catch (ExceptionJEPParser ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.EXPRESSAO_INVALIDA, new Object[]{expressao});
        }
    }

    private Double getSaldoAtualConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        Double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador(), centroResultado);
        if (saldo != null) {
            valor = saldo.getSaldoAtual();
        }
        return valor;
    }

    private Double getSaldoAnteriorConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        Double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador(), centroResultado);
        if (saldo != null) {
            valor = saldo.getSaldoAnterior();
        }
        return valor;
    }

    private Double getDebitosConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        Double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador(), centroResultado);
        if (saldo != null) {
            valor = saldo.getValorDebito();
        }
        return valor;
    }

    private Double getCreditosConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        Double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador(), centroResultado);
        if (saldo != null) {
            valor = saldo.getValorCredito();
        }
        return valor;
    }

    private Double getSaldoEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr, centroResultado);
        return s.getSaldoAtual();
    }

    private Double getDebitosEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr, centroResultado);
        return s.getValorDebito();
    }

    private Double getCreditosEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr, centroResultado);
        return s.getValorCredito();
    }

    private Double getSaldoAnteriorEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr, centroResultado);
        return s.getSaldoAnterior();
    }

    private Object getFixedValue(String chave, Date dataInicial, Date dataFinal, List<LinhasIndiceEconomico> linhas, GrupoEmpresa gr, CentroResultadoContFin centroResultado, Integer tipoRel, String descricaoLinha, Short desconsiderarEncerramento) throws ExceptionIndiceEconomico {
        String codigoPC;
        PlanoConta pc;
        if (chave.startsWith("linha")) {
            String linha = chave.substring(chave.indexOf("_") + 1);
            Integer index = Integer.valueOf(linha);
            if (index > linhas.size()) {
                throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.LINHA_INDICE_INVALIDO, new Object[]{chave});
            }
            LinhasIndiceEconomico ind = linhas.get(index - 1);
            Double valor = ind.getValor();
            valor = valor == null ? 0.0 : valor;
            return valor.toString();
        }
        if (chave.startsWith("saldo.anterior.pc")) {
            String codigoPC2 = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc2 = this.getPlanoConta(codigoPC2);
            if (pc2 != null) {
                return this.getSaldoPCAnterior(pc2, dataInicial, dataFinal, gr, centroResultado, tipoRel);
            }
        } else if (chave.startsWith("creditos.pc")) {
            String codigoPC3 = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc3 = this.getPlanoConta(codigoPC3);
            if (pc3 != null) {
                return this.getCreditosPC(pc3, dataInicial, dataFinal, gr, centroResultado, tipoRel);
            }
        } else if (chave.startsWith("debitos.pc")) {
            String codigoPC4 = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc4 = this.getPlanoConta(codigoPC4);
            if (pc4 != null) {
                return this.getDebitosPC(pc4, dataInicial, dataFinal, gr, centroResultado, tipoRel);
            }
        } else if (chave.startsWith("plano.conta") && (pc = this.getPlanoConta(codigoPC = chave.substring(chave.indexOf("_") + 1))) != null) {
            return this.getSaldoPC(pc, dataInicial, dataFinal, gr, centroResultado, tipoRel, desconsiderarEncerramento);
        }
        throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.TOKEN_FORMULA_INVALIDO, new Object[]{chave});
    }

    public Double getFixedValueMeta(String chave, Date dataInicial, Date dataFinal, List<LinhasIndiceEconomico> linhas, MetaControleContabil meta, String descricaoLinha) throws ExceptionIndiceEconomico {
        String codigoPC;
        PlanoConta pc;
        if (chave.startsWith("linha")) {
            String linha = chave.substring(chave.indexOf("_") + 1);
            Integer index = Integer.valueOf(linha);
            if (index > linhas.size()) {
                throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.LINHA_INDICE_INVALIDO, new Object[]{chave});
            }
            LinhasIndiceEconomico ind = linhas.get(index - 1);
            Double valor = ind.getValorMeta();
            if (valor == null) {
                valor = 0.0;
            } else if (valor.isNaN() || valor.isInfinite()) {
                valor = 0.0;
            }
            return valor;
        }
        if (chave.startsWith("saldo.anterior.pc")) {
            String codigoPC2 = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc2 = this.getPlanoConta(codigoPC2);
            if (pc2 != null) {
                return this.getMetaContabilGerencial(pc2, (short)2, dataInicial, dataFinal, meta);
            }
        } else if (chave.startsWith("creditos.pc")) {
            String codigoPC3 = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc3 = this.getPlanoConta(codigoPC3);
            if (pc3 != null) {
                return this.getMetaContabilGerencial(pc3, (short)1, dataInicial, dataFinal, meta);
            }
        } else if (chave.startsWith("debitos.pc")) {
            String codigoPC4 = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc4 = this.getPlanoConta(codigoPC4);
            if (pc4 != null) {
                return this.getMetaContabilGerencial(pc4, (short)0, dataInicial, dataFinal, meta);
            }
        } else if (chave.startsWith("plano.conta") && (pc = this.getPlanoConta(codigoPC = chave.substring(chave.indexOf("_") + 1))) != null) {
            return this.getMetaContabilGerencial(pc, (short)3, dataInicial, dataFinal, meta);
        }
        throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.TOKEN_FORMULA_INVALIDO, new Object[]{chave});
    }

    private PlanoConta getPlanoConta(String codigoPC) throws ExceptionIndiceEconomico {
        PlanoConta pc = this.servicePlanoConta.findByCodigo(codigoPC);
        if (pc == null) {
            throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.PLANO_CONTAS_NAO_EXISTE, new Object[]{codigoPC});
        }
        return pc;
    }

    private Double getSaldoPC(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, CentroResultadoContFin centroResultado, Integer tipoRel, Short desconsiderarEncerramento) {
        ServiceEncerramentoContabilPorCentroResultadoImpl serviceEncerramento;
        EncerramentoContabil ence;
        Boolean desconsiderarEncerramentoAndExisteEnrrante = false;
        if (this.isAffimative(desconsiderarEncerramento) && !this.isNull(ence = (serviceEncerramento = (ServiceEncerramentoContabilPorCentroResultadoImpl)Context.get(ServiceEncerramentoContabilPorCentroResultadoImpl.class)).getVerificarExisteEncerramentoContabilDeDataFinal(dataFinal, gr)).booleanValue()) {
            desconsiderarEncerramentoAndExisteEnrrante = true;
        }
        if (!this.isAffimative(tipoRel) && !desconsiderarEncerramentoAndExisteEnrrante.booleanValue()) {
            return this.getSaldoAtualConta(dataInicial, dataFinal, planoConta, gr, centroResultado);
        }
        return this.getSaldoEncerramentoConta(dataFinal, planoConta, gr, centroResultado);
    }

    private Double getSaldoPCAnterior(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, CentroResultadoContFin centroResultado, Integer tipoRel) {
        if (!this.isAffimative(tipoRel)) {
            return this.getSaldoAnteriorConta(dataInicial, dataFinal, planoConta, gr, centroResultado);
        }
        return this.getSaldoAnteriorEncerramentoConta(dataFinal, planoConta, gr, centroResultado);
    }

    private Double getDebitosPC(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, CentroResultadoContFin centroResultado, Integer tipoRel) {
        if (!this.isAffimative(tipoRel)) {
            return this.getDebitosConta(dataInicial, dataFinal, planoConta, gr, centroResultado);
        }
        return this.getDebitosEncerramentoConta(dataFinal, planoConta, gr, centroResultado);
    }

    private Double getCreditosPC(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, CentroResultadoContFin centroResultado, Integer tipoRel) {
        if (!this.isAffimative(tipoRel)) {
            return this.getCreditosConta(dataInicial, dataFinal, planoConta, gr, centroResultado);
        }
        return this.getCreditosEncerramentoConta(dataFinal, planoConta, gr, centroResultado);
    }

    private void orderLinhas(List<LinhasIndiceEconomico> linhas) {
        Collections.sort(linhas, (o1, o2) -> o1.getIndice().compareTo(o2.getIndice()));
    }

    private double getMetaContabilGerencial(PlanoConta planoContaCont, Short tipoSaldo, Date dataInicial, Date dataFinal, MetaControleContabil meta) {
        if (meta == null) {
            return 0.0;
        }
        for (MetaControleContLinha mt : meta.getMetasLinhas()) {
            if (!this.isEquals(mt.getPlanoConta(), planoContaCont) || mt.getTipoValor() == null || !this.isEquals(mt.getTipoValor(), tipoSaldo)) continue;
            return this.filtraSomaValores(mt.getValoresLinhas(), dataInicial, dataFinal);
        }
        return 0.0;
    }

    private double filtraSomaValores(List<MetaControleContLinhaVlr> valoresLinhas, Date dataInicial, Date dataFinal) {
        double soma = 0.0;
        for (MetaControleContLinhaVlr vlr : valoresLinhas) {
            if (vlr.getIntervaloControleContPer() == null || !ToolDate.dateBetween((Date)vlr.getIntervaloControleContPer().getDataInicial(), (Date)dataInicial, (Date)dataFinal).booleanValue() || !ToolDate.dateBetween((Date)vlr.getIntervaloControleContPer().getDataFinal(), (Date)dataInicial, (Date)dataFinal).booleanValue()) continue;
            soma += vlr.getValorMeta().doubleValue();
        }
        return soma;
    }

    private SaldoContaContabil getSaldoContabil(String codigo, Date dataInicial, Date dataFinal, Long identificador, CentroResultadoContFin centroResultado) {
        if (centroResultado != null) {
            return this.serviceSaldoConta.findSaldoContaUnica(centroResultado.getIdentificador(), centroResultado.getIdentificador(), codigo, dataInicial, dataFinal, identificador, EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO);
        }
        return this.serviceSaldoConta.findSaldoContaUnica(null, null, codigo, dataInicial, dataFinal, identificador, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL);
    }

    private SaldoContaContabil getSaldo(Date data, PlanoConta pc, GrupoEmpresa gr, CentroResultadoContFin centroResultado) {
        if (centroResultado != null) {
            return this.serviceSaldoConta.findSaldoContaUnicaEncerramento(centroResultado.getIdentificador(), centroResultado.getIdentificador(), pc.getCodigo(), data, gr.getIdentificador(), EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO);
        }
        return this.serviceSaldoConta.findSaldoContaUnicaEncerramento(null, null, pc.getCodigo(), data, gr.getIdentificador(), EnumConstantsTipoSaldo.TIPO_SALDO_GERAL);
    }
}

