/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indiceeconomico;

import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.IndiceEconomico;
import com.touchcomp.basementor.model.vo.LinhasIndiceEconomico;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.indiceeconomico.ExceptionIndiceEconomico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.indiceeconomico.CompIndiceEconomico;
import com.touchcomp.basementorservice.dao.impl.DaoIndiceEconomicoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.buildindiceeconomico.ServiceBuildIndiceEconomicoImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.indiceeconomico.web.DTOIndiceEconomico;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceIndiceEconomicoImpl
extends ServiceGenericEntityImpl<IndiceEconomico, Long, DaoIndiceEconomicoImpl> {
    @Autowired
    private ServiceBuildIndiceEconomicoImpl serviceBuildIndiceEconomico;
    @Autowired
    private ServicePlanoContaImpl servicePlanoConta;
    @Autowired
    private ServiceContaValoresImpl serviceContaValores;
    @Autowired
    private CompIndiceEconomico comp;

    @Autowired
    public ServiceIndiceEconomicoImpl(DaoIndiceEconomicoImpl dao) {
        super(dao);
    }

    @Override
    public IndiceEconomico beforeSaveEntity(IndiceEconomico entity) {
        if (ServiceIndiceEconomicoImpl.isWithData(entity.getLinhas())) {
            this.comp.reorderIndex(entity);
            entity.getLinhas().forEach(i -> i.setIndiceEconomico(entity));
        }
        return entity;
    }

    public String processarExpressao(String formula, DTOIndiceEconomico dto) throws ExceptionInvalidData, ExceptionIndiceEconomico {
        IndiceEconomico vo = (IndiceEconomico)this.buildToEntity(dto);
        String expressao = this.classificarEMontar(formula, vo.getLinhas());
        if (this.isStrWithData(expressao)) {
            return ToolHexString.encodeToHex((String)expressao);
        }
        return "";
    }

    private String classificarEMontar(String expressao, List<LinhasIndiceEconomico> linhas) throws ExceptionInvalidData, ExceptionIndiceEconomico {
        List token = ToolString.getReplaceTokens((String)expressao);
        for (StringToken stringToken : token) {
            String aux = this.montarExpressao(linhas, stringToken.getChave());
            stringToken.setValor(aux);
        }
        return ToolString.build((String)expressao, (List)token);
    }

    private String montarExpressao(List<LinhasIndiceEconomico> linhas, String chave) throws ExceptionInvalidData, ExceptionIndiceEconomico {
        if (chave.startsWith("linha")) {
            String linha = chave.substring(chave.indexOf("_") + 1);
            Integer index = Integer.parseInt(linha) - 1;
            if (index > linhas.size()) {
                throw new ExceptionInvalidData("Verifique as formulas pois utilizam uma linha invalida: " + chave, new Object[0]);
            }
            LinhasIndiceEconomico ind = linhas.get(index);
            String exp = ind.getExpressao();
            System.out.println(exp);
            return "\nlinha_" + (index + 1) + "{ " + this.classificarEMontar(ind.getExpressao(), linhas) + " }\n";
        }
        if (chave.startsWith("saldo.anterior.pc") || chave.startsWith("debitos.pc") || chave.startsWith("creditos.pc") || chave.startsWith("plano.conta")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc = this.servicePlanoConta.findByCodigo(codigoPC);
            return pc != null ? pc.getDescricao() : "Conta n\u00e3o encontrada ou inativa";
        }
        return "";
    }

    public DTOIndiceEconomico criarLinhaIndiceEconomico(Integer numeroLinha, DTOIndiceEconomico dto) {
        IndiceEconomico vo = (IndiceEconomico)this.buildToEntity(dto);
        return this.buildToDTO(this.comp.criarLinhaIndiceEconomico(vo, numeroLinha), DTOIndiceEconomico.class);
    }

    public DTOIndiceEconomico reordenarLinhas(DTOIndiceEconomico dto) {
        IndiceEconomico vo = (IndiceEconomico)this.buildToEntity(dto);
        this.comp.reorderIndex(vo);
        return this.buildToDTO(vo, DTOIndiceEconomico.class);
    }

    public String getVariavelPlanoConta(Short filtrarCentroCusto, String codigoCC, Long[] idsPlanoConta) {
        List planos = this.servicePlanoConta.gets(idsPlanoConta);
        return ToolHexString.encodeToHex((String)this.comp.criarVariavelPlanoConta(planos, filtrarCentroCusto, codigoCC));
    }

    public String getVariavelLinha(Integer numeroLinha) {
        if (this.isNull(numeroLinha).booleanValue() || numeroLinha < 0) {
            return "";
        }
        return ToolHexString.encodeToHex((String)this.comp.getFormatLinha(numeroLinha));
    }

    public String getVariavelVariavel(String variavel) {
        if (!this.isStrWithData(variavel)) {
            return "";
        }
        return ToolHexString.encodeToHex((String)this.comp.getFormatVariavelSemMarcacoes(variavel));
    }

    public String getVariavelVlrInicialContaValores(Long identificador) throws ExceptionObjNotFound {
        ContaValores conta = (ContaValores)this.serviceContaValores.getOrThrow(identificador);
        return ToolHexString.encodeToHex((String)this.comp.getFormatValorInicialContaValores(conta.getIdentificador()));
    }

    public String getVariavelVlrFinalContaValores(Long identificador) throws ExceptionObjNotFound {
        ContaValores conta = (ContaValores)this.serviceContaValores.getOrThrow(identificador);
        return ToolHexString.encodeToHex((String)this.comp.getFormatValorFinalContaValores(conta.getIdentificador()));
    }

    public String getVariavelLinhaAcumulada(Integer numeroLinha) {
        if (this.isNull(numeroLinha).booleanValue() || numeroLinha < 0) {
            return "";
        }
        return ToolHexString.encodeToHex((String)this.comp.getFormatValorLinhaAcumulada(numeroLinha));
    }

    public String getVariavelPlanoConta(Long idPlanoConta) {
        PlanoConta planoConta = (PlanoConta)this.servicePlanoConta.get(idPlanoConta);
        return ToolHexString.encodeToHex((String)this.comp.getFormatPlanoConta(planoConta.getCodigo()));
    }

    public String getVariavelPlanoContaSaldoAnterior(Long idPlanoConta) {
        PlanoConta planoConta = (PlanoConta)this.servicePlanoConta.get(idPlanoConta);
        return ToolHexString.encodeToHex((String)this.comp.getFormatVariavelSaldoAnterior(planoConta.getCodigo()));
    }

    public String getVariavelPlanoContaDebitos(Long idPlanoConta) {
        PlanoConta planoConta = (PlanoConta)this.servicePlanoConta.get(idPlanoConta);
        return ToolHexString.encodeToHex((String)this.comp.getFormatVariavelDebitos(planoConta.getCodigo()));
    }

    public String getVariavelPlanoContaCreditos(Long idPlanoConta) {
        PlanoConta planoConta = (PlanoConta)this.servicePlanoConta.get(idPlanoConta);
        return ToolHexString.encodeToHex((String)this.comp.getFormatVariavelCreditos(planoConta.getCodigo()));
    }
}

