/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indicegerencial;

import com.touchcomp.basementor.model.impl.IndiceGerencialCalculado;
import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.LinhasIndiceGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.indicegerencial.EnumExcepIndiceGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.indicegerencial.ExceptionIndiceGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.AuxBuildIndiceGerencial;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.SourceVariables;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.SourceVariablesImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.SourceVariablesMetaImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.SourceVariablesOrcadoImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.SourceVariablesProvisionadoImpl;
import com.touchcomp.basementorservice.service.impl.planejamentoorcamentario.ServicePlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.impl.planocontagerencial.ServicePlanoContaGerencialImpl;
import com.touchcomp.basementorservice.service.impl.saldocontagerencial.ServiceSaldoContaGerencialImpl;
import com.touchcomp.basementorservice.service.impl.saldocontavalores.ServiceSaldoContaValoresImpl;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.jep.ToolJepExpressionParser;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceBuildIndiceGerencialImpl
extends ServiceGenericImpl {
    private SourceVariables source;
    private SourceVariables sourceMeta;
    private SourceVariables sourceProv;
    private SourceVariables sourceOrcado;
    private final AuxBuildIndiceGerencial auxBuildIndiceGerencial;
    private final ServiceCentroCustoImpl serviceCentroCusto;
    private final ServicePlanoContaGerencialImpl servicePlanoConta;
    private final ServiceContaValoresImpl serviceContaValores;
    private final ServiceSaldoContaValoresImpl serviceSaldoContaValores;
    private final ServiceSaldoContaGerencialImpl serviceSaldoContaGerencial;
    private final ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl;
    private final ServiceGrupoEmpresaImpl serviceGrupoEmpresa;
    private final ServiceEmpresaImpl serviceEmpresa;
    private IndiceGerencialParams params;
    private static final TLogger logger = TLogger.get(ServiceBuildIndiceGerencialImpl.class);

    public ServiceBuildIndiceGerencialImpl(ServiceCentroCustoImpl serviceCentroCusto, ServicePlanoContaGerencialImpl servicePlanoConta, ServiceContaValoresImpl serviceContaValores, ServiceSaldoContaValoresImpl serviceSaldoContaValores, ServiceSaldoContaGerencialImpl serviceSaldoContaGerencial, ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl, ServiceGrupoEmpresaImpl serviceGrupoEmpresa, ServiceEmpresaImpl serviceEmpresa) {
        this.serviceCentroCusto = serviceCentroCusto;
        this.servicePlanoConta = servicePlanoConta;
        this.serviceContaValores = serviceContaValores;
        this.serviceSaldoContaValores = serviceSaldoContaValores;
        this.serviceSaldoContaGerencial = serviceSaldoContaGerencial;
        this.servicePlanejamentoOrcamentarioImpl = servicePlanejamentoOrcamentarioImpl;
        this.serviceGrupoEmpresa = serviceGrupoEmpresa;
        this.serviceEmpresa = serviceEmpresa;
        this.auxBuildIndiceGerencial = new AuxBuildIndiceGerencial(serviceCentroCusto, servicePlanoConta, serviceContaValores);
    }

    public IndiceGerencialCalculado calcularIndiceGerencial(IndiceGerencialParams params) throws ExceptionJEPParser, ExceptionInvalidData, ExceptionIndiceGerencial {
        this.params = params;
        this.source = new SourceVariablesImpl(params, this.serviceSaldoContaValores, this.serviceSaldoContaGerencial, this.servicePlanejamentoOrcamentarioImpl, this.auxBuildIndiceGerencial, this.serviceGrupoEmpresa, this.serviceEmpresa);
        this.sourceMeta = new SourceVariablesMetaImpl(params, this.serviceSaldoContaValores, this.serviceSaldoContaGerencial, this.servicePlanejamentoOrcamentarioImpl, this.auxBuildIndiceGerencial, this.serviceGrupoEmpresa, this.serviceEmpresa);
        this.sourceProv = new SourceVariablesProvisionadoImpl(params, this.serviceSaldoContaValores, this.serviceSaldoContaGerencial, this.servicePlanejamentoOrcamentarioImpl, this.auxBuildIndiceGerencial, this.serviceGrupoEmpresa, this.serviceEmpresa);
        this.sourceOrcado = new SourceVariablesOrcadoImpl(params, this.serviceSaldoContaValores, this.serviceSaldoContaGerencial, this.servicePlanejamentoOrcamentarioImpl, this.auxBuildIndiceGerencial, this.serviceGrupoEmpresa, this.serviceEmpresa);
        return this.calcularIndice();
    }

    public List<String> getVarCentroCusto(IndiceGerencial i) throws ExceptionInvalidData {
        List<AuxBuildIndiceGerencial.TokenType> data = this.getVar(i, AuxBuildIndiceGerencial.Type.PLANO_CONTA_CC_VAR);
        LinkedList<String> ret = new LinkedList<String>();
        for (AuxBuildIndiceGerencial.TokenType tokenType : data) {
            if (ret.contains(tokenType.getVar2())) continue;
            ret.add(tokenType.getVar2());
        }
        return ret;
    }

    public List<String> getVarAbertas(IndiceGerencial i) throws ExceptionInvalidData {
        List<AuxBuildIndiceGerencial.TokenType> data = this.getVar(i, AuxBuildIndiceGerencial.Type.VARIAVEL);
        LinkedList<String> ret = new LinkedList<String>();
        for (AuxBuildIndiceGerencial.TokenType tokenType : data) {
            ret.add(tokenType.getVar1());
        }
        return ret;
    }

    public List<AuxBuildIndiceGerencial.TokenType> getVar(IndiceGerencial i, AuxBuildIndiceGerencial.Type typeReq) throws ExceptionInvalidData {
        LinkedList<AuxBuildIndiceGerencial.TokenType> ret = new LinkedList<AuxBuildIndiceGerencial.TokenType>();
        for (LinhasIndiceGerencial currentLinha : i.getLinhas()) {
            List token = ToolString.getReplaceTokens((String)currentLinha.getExpressao());
            for (StringToken stringToken : token) {
                AuxBuildIndiceGerencial.TokenType type = this.auxBuildIndiceGerencial.classificar(stringToken.getChave());
                if (!typeReq.equals((Object)type.getType())) continue;
                ret.add(type);
            }
        }
        return ret;
    }

    private IndiceGerencialCalculado calcularIndice() throws ExceptionJEPParser, ExceptionInvalidData, ExceptionIndiceGerencial {
        IndiceGerencialCalculado ret = new IndiceGerencialCalculado();
        ret.setIndiceGerencial(this.params.getIndiceGerencial());
        List linhas = this.params.getIndiceGerencial().getLinhas();
        Collections.sort(linhas, (o1, o2) -> o1.getIndice().compareTo(o2.getIndice()));
        this.calcularLinhas(linhas, ret);
        this.removerLinhasZeradas(ret);
        return ret;
    }

    private void calcularLinhas(List<LinhasIndiceGerencial> linhas, IndiceGerencialCalculado ret) throws ExceptionJEPParser, ExceptionInvalidData, ExceptionIndiceGerencial {
        int contLinha = 1;
        for (LinhasIndiceGerencial currentLinha : linhas) {
            System.out.println("\n\n\nLinha " + contLinha + " = " + currentLinha.getDescricao());
            Double valorReal = 0.0;
            Double valorProv = 0.0;
            Double valorMeta = 0.0;
            Double valorOrcado = 0.0;
            if (this.params.isCalcularRealizado()) {
                valorReal = this.getTotalFormula(currentLinha.getExpressao(), ret, contLinha, this.source);
            }
            if (this.params.isCalcularProvisionado()) {
                valorProv = this.getTotalFormula(currentLinha.getExpressao(), ret, contLinha, this.sourceProv);
            }
            if (this.params.getIntervaloControleGerPer() != null) {
                if (this.params.isCalcularMeta()) {
                    valorMeta = this.getTotalFormula(currentLinha.getExpressao(), ret, contLinha, this.sourceMeta);
                }
                if (this.params.isCalcularOrcado()) {
                    valorOrcado = this.getTotalFormula(currentLinha.getExpressao(), ret, contLinha, this.sourceOrcado);
                }
            }
            ret.setSomaRealizado(Double.valueOf(ret.getSomaRealizado() + valorReal));
            ret.setSomaProvisionado(Double.valueOf(ret.getSomaProvisionado() + valorProv));
            ret.setSomaMeta(Double.valueOf(ret.getSomaMeta() + valorMeta));
            ret.setSomaOrcado(Double.valueOf(ret.getSomaOrcado() + valorOrcado));
            IndiceGerencialCalculado.LinhaIndice linha = this.addNewLinha(ret, currentLinha, valorReal, valorProv, valorMeta, valorOrcado);
            if (valorMeta != 0.0) {
                linha.setPercMetaRealizado(ToolNumber.calcPercentual((Double)valorReal, (Double)valorMeta));
                linha.setPercMetaRealizadoProv(ToolNumber.calcPercentual((Double)(valorProv + valorReal), (Double)valorMeta));
            } else {
                linha.setPercMetaRealizado(Double.valueOf(0.0));
                linha.setPercMetaRealizadoProv(Double.valueOf(0.0));
            }
            linha.setValorRealProvisionado(Double.valueOf(linha.getValor() + linha.getValorProvisionado()));
            linha.setDifMetaReal(Double.valueOf(valorMeta - valorReal));
            linha.setDifMetaRealProv(Double.valueOf(valorMeta - (valorProv + valorReal)));
            ++contLinha;
        }
    }

    private Double getTotalFormula(String expressao, IndiceGerencialCalculado ret, int contLinha, SourceVariables source) throws ExceptionInvalidData, ExceptionJEPParser, ExceptionIndiceGerencial {
        if (!ToolMethods.isStrWithData((String)expressao)) {
            return 0.0;
        }
        List token = ToolString.getReplaceTokens((String)expressao);
        HashMap<String, String> m = new HashMap<String, String>();
        for (StringToken sk : token) {
            m.put(sk.getChave(), String.valueOf(this.getFixedValue(sk.getChave(), ret, contLinha, source)));
        }
        try {
            return ToolJepExpressionParser.evaluate((String)expressao, m);
        }
        catch (Exception ex) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nLinha: ");
            sb.append(contLinha);
            sb.append("\nExpressao: ");
            sb.append(expressao);
            sb.append("\nErro: ");
            sb.append(ex.getMessage());
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionIndiceGerencial(EnumExcepIndiceGerencial.EXPRESSAO_INVALIDA, new Object[]{sb.toString()});
        }
    }

    private Object getFixedValue(String chave, IndiceGerencialCalculado ret, int contLinha, SourceVariables source) throws ExceptionInvalidData {
        return source.getFixedValue(chave, ret, contLinha);
    }

    private IndiceGerencialCalculado.LinhaIndice addNewLinha(IndiceGerencialCalculado ret, LinhasIndiceGerencial currentLinha, double valorRealizado, double valorProvisionado, double valorMeta, double valorOrcado) {
        IndiceGerencialCalculado.LinhaIndice linha = new IndiceGerencialCalculado.LinhaIndice();
        linha.setNegrito(currentLinha.getNegrito());
        linha.setLinhaIndiceGerencial(currentLinha);
        linha.setValor(Double.valueOf(valorRealizado));
        linha.setValorProvisionado(Double.valueOf(valorProvisionado));
        linha.setValorMeta(Double.valueOf(valorMeta));
        linha.setValorOrcado(Double.valueOf(valorOrcado));
        linha.setDifMetaReal(Double.valueOf(linha.getValorMeta() - linha.getValor()));
        linha.setDifMetaRealProv(Double.valueOf(linha.getValorMeta() - (linha.getValor() + linha.getValorProvisionado())));
        linha.setDifOrcadoReal(Double.valueOf(linha.getValorOrcado() - linha.getValor()));
        linha.setDifOrcadoRealProv(Double.valueOf(linha.getValorOrcado() - (linha.getValor() + linha.getValorProvisionado())));
        ret.getLinhas().add(linha);
        return linha;
    }

    public String montarExpressao(List<LinhasIndiceGerencial> linhas, String expressao) throws ExceptionInvalidData {
        List token = ToolString.getReplaceTokens((String)expressao);
        for (StringToken stringToken : token) {
            String aux = this.auxBuildIndiceGerencial.classificarEMontar(linhas, stringToken.getChave());
            stringToken.setValor(aux);
        }
        return ToolString.build((String)expressao, (List)token);
    }

    private void removerLinhasZeradas(IndiceGerencialCalculado ret) {
        LinkedList<IndiceGerencialCalculado.LinhaIndice> aux = new LinkedList<IndiceGerencialCalculado.LinhaIndice>();
        for (IndiceGerencialCalculado.LinhaIndice ob : ret.getLinhas()) {
            if (!ToolMethods.isEquals((Object)this.params.getExibirLinhasZeradas(), (Object)1) && ob.getValor() == 0.0 && ob.getValorMeta() == 0.0 && ob.getValorOrcado() == 0.0 && ob.getValorProvisionado() == 0.0) continue;
            aux.add(ob);
        }
        ret.setLinhas(aux);
    }
}

