/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indicegerencial;

import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.indicegerencial.CompIndiceGerencial;
import com.touchcomp.basementorservice.dao.impl.DaoIndiceGerencialImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.ServiceBuildIndiceGerencialImpl;
import com.touchcomp.basementorservice.service.impl.planocontagerencial.ServicePlanoContaGerencialImpl;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.touchvomodel.vo.DTOIndiceGerencial;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceIndiceGerencialImpl
extends ServiceGenericEntityImpl<IndiceGerencial, Long, DaoIndiceGerencialImpl> {
    @Autowired
    private ServiceBuildIndiceGerencialImpl serviceBuildIndiceGerencial;
    @Autowired
    private ServicePlanoContaGerencialImpl servicePlanoContaGerencial;
    @Autowired
    private ServiceContaValoresImpl serviceContaValores;
    @Autowired
    private CompIndiceGerencial comp;

    public ServiceIndiceGerencialImpl(DaoIndiceGerencialImpl genericDao) {
        super(genericDao);
    }

    @Override
    public IndiceGerencial beforeSaveEntity(IndiceGerencial entity) {
        if (ServiceIndiceGerencialImpl.isWithData(entity.getLinhas())) {
            this.comp.reorderIndex(entity);
            entity.getLinhas().forEach(i -> i.setIndiceGerencial(entity));
        }
        return entity;
    }

    public String processarExpressao(String formula, DTOIndiceGerencial dto) throws ExceptionInvalidData {
        IndiceGerencial vo = (IndiceGerencial)this.buildToEntity(dto);
        String expressao = this.serviceBuildIndiceGerencial.montarExpressao(vo.getLinhas(), formula);
        if (this.isStrWithData(expressao)) {
            return ToolHexString.encodeToHex((String)expressao);
        }
        return "";
    }

    public DTOIndiceGerencial criarLinhaIndiceGerencial(Integer numeroLinha, DTOIndiceGerencial dto) {
        IndiceGerencial vo = (IndiceGerencial)this.buildToEntity(dto);
        return this.buildToDTO(this.comp.criarLinhaIndiceGerencial(vo, numeroLinha), DTOIndiceGerencial.class);
    }

    public DTOIndiceGerencial reordenarLinhas(DTOIndiceGerencial dto) {
        IndiceGerencial vo = (IndiceGerencial)this.buildToEntity(dto);
        this.comp.reorderIndex(vo);
        return this.buildToDTO(vo, DTOIndiceGerencial.class);
    }

    public String getVariavelPlanoConta(Short filtrarCentroCusto, String codigoCC, Long[] idsPlanoConta) {
        List planos = this.servicePlanoContaGerencial.gets(idsPlanoConta);
        return ToolHexString.encodeToHex((String)this.comp.criarVariavelPlanoConta(planos, filtrarCentroCusto, codigoCC));
    }

    public String getVariavelLinha(Integer numeroLinha) {
        if (this.isNull(numeroLinha).booleanValue() || numeroLinha < 0) {
            return "";
        }
        return ToolHexString.encodeToHex((String)this.comp.getFormatLinha(numeroLinha));
    }

    public String getVariavelVariavel(String variavel) {
        if (!this.isStrWithData(variavel)) {
            return "";
        }
        return ToolHexString.encodeToHex((String)this.comp.getFormatVariavelSemMarcacoes(variavel));
    }

    public String getVariavelVlrInicialContaValores(Long identificador) throws ExceptionObjNotFound {
        ContaValores conta = (ContaValores)this.serviceContaValores.getOrThrow(identificador);
        return ToolHexString.encodeToHex((String)this.comp.getFormatValorInicialContaValores(conta.getIdentificador()));
    }

    public String getVariavelVlrFinalContaValores(Long identificador) throws ExceptionObjNotFound {
        ContaValores conta = (ContaValores)this.serviceContaValores.getOrThrow(identificador);
        return ToolHexString.encodeToHex((String)this.comp.getFormatValorFinalContaValores(conta.getIdentificador()));
    }

    public String getVariavelLinhaAcumulada(Integer numeroLinha) {
        if (this.isNull(numeroLinha).booleanValue() || numeroLinha < 0) {
            return "";
        }
        return ToolHexString.encodeToHex((String)this.comp.getFormatValorLinhaAcumulada(numeroLinha));
    }
}

