/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indicegerencial.sources;

import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.LinhasIndiceGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementorservice.service.impl.planocontagerencial.ServicePlanoContaGerencialImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.List;

public class AuxBuildIndiceGerencial {
    protected ServiceCentroCustoImpl serviceCentroCusto;
    protected ServicePlanoContaGerencialImpl servicePlanoConta;
    protected ServiceContaValoresImpl serviceContaValores;

    public AuxBuildIndiceGerencial(ServiceCentroCustoImpl serviceCentroCusto, ServicePlanoContaGerencialImpl servicePlanoConta, ServiceContaValoresImpl serviceContaValores) {
        this.serviceCentroCusto = serviceCentroCusto;
        this.servicePlanoConta = servicePlanoConta;
        this.serviceContaValores = serviceContaValores;
    }

    public TokenType classificar(String chave) throws ExceptionInvalidData {
        if (chave.startsWith("linha")) {
            String linha = chave.substring(chave.indexOf("_") + 1);
            return new TokenType(Type.LINHA, linha);
        }
        if (chave.startsWith("plano.conta")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            String centroCusto = null;
            Type type = Type.PLANO_CONTA;
            if (codigoPC.indexOf("_") > 0) {
                int aux = codigoPC.indexOf("_");
                centroCusto = codigoPC.substring(aux + 1);
                codigoPC = codigoPC.substring(0, aux);
            }
            if (ToolMethods.isStrWithDataLength(centroCusto, (int)9) && ToolString.isAIntegerNumber(centroCusto)) {
                type = Type.PLANO_CONTA_CC_CODIGO;
                return new TokenType(type, codigoPC, centroCusto);
            }
            if (ToolMethods.isStrWithData(centroCusto) && ToolString.isAIntegerNumber(centroCusto)) {
                type = Type.PLANO_CONTA_CC_ID;
                return new TokenType(type, codigoPC, centroCusto);
            }
            if (ToolMethods.isStrWithData(centroCusto)) {
                type = Type.PLANO_CONTA_CC_VAR;
                return new TokenType(type, codigoPC, centroCusto);
            }
            return new TokenType(type, codigoPC);
        }
        if (chave.startsWith("valor.linha.acumulada")) {
            chave = chave.substring(chave.indexOf("_") + 1);
            return new TokenType(Type.VALOR_LINHA_ACUMULADA, chave);
        }
        if (chave.startsWith("valor.inicial.conta")) {
            chave = chave.substring(chave.indexOf("_") + 1);
            return new TokenType(Type.VALOR_INICIAL_CONTA_VALORES, chave);
        }
        if (chave.startsWith("var.final.conta")) {
            chave = chave.substring(chave.indexOf("_") + 1);
            return new TokenType(Type.VALOR_FINAL_CONTA_VALORES, chave);
        }
        if (chave.startsWith("var")) {
            chave = chave.substring(chave.indexOf("_") + 1);
            return new TokenType(Type.VARIAVEL, chave);
        }
        throw new ExceptionInvalidData("01-02-00730", new Object[0]);
    }

    public String classificarEMontar(List<LinhasIndiceGerencial> linhas, String chave) throws ExceptionInvalidData {
        TokenType token = this.classificar(chave);
        switch (token.getType().ordinal()) {
            case 4: {
                Integer index = Integer.valueOf(token.getVar1());
                if (index > linhas.size()) {
                    return "LINHA_INVALIDA=" + index;
                }
                LinhasIndiceGerencial ind = linhas.get(index - 1);
                return "Linha= " + ind.getDescricao();
            }
            case 0: {
                PlanoContaGerencial pc = this.getPlanoConta(token.getVar1());
                return "PC= " + (pc != null ? pc.getDescricao() : "ND");
            }
            case 1: {
                PlanoContaGerencial pc = this.getPlanoConta(token.getVar1());
                CentroCusto cc = this.getCentroCusto(token.getVar2(), null);
                return "PC/CC= " + (pc != null ? pc.getDescricao() : "ND") + " / " + (cc != null ? cc.getNome() : "ND");
            }
            case 2: {
                PlanoContaGerencial pc = this.getPlanoConta(token.getVar1());
                CentroCusto cc = this.getCentroCusto(token.getVar2(), null);
                return "PC/CC= " + (pc != null ? pc.getDescricao() : "ND") + " / " + (cc != null ? cc.getNome() : "ND");
            }
            case 3: {
                PlanoContaGerencial pc = this.getPlanoConta(token.getVar1());
                CentroCusto cc = this.getCentroCusto(token.getVar2(), null);
                return "PC/CC= " + (pc != null ? pc.getDescricao() : "ND") + " / " + (cc != null ? cc.getNome() : "ND");
            }
            case 8: {
                ContaValores conta = this.getContaValores(Long.valueOf(token.getVar1()));
                return "Linha Acumulada= " + conta.getDescricao();
            }
            case 7: {
                return "Linha Acumulada= " + token.getVar1();
            }
            case 5: {
                return "Variavel= " + chave;
            }
            case 6: {
                return "Variavel Fixa= " + chave;
            }
        }
        return chave;
    }

    public PlanoContaGerencial getPlanoConta(String codigoPC) {
        return this.servicePlanoConta.findByCodigo(codigoPC);
    }

    public CentroCusto getCentroCusto(String centroCusto, List<IndiceGerencialParams.VarCentroCusto> variaveisCentroCusto) {
        if (centroCusto == null) {
            return null;
        }
        if (ToolMethods.isStrWithDataLength((String)centroCusto, (int)9) && ToolString.isAIntegerNumber((String)centroCusto)) {
            return this.serviceCentroCusto.findByCodigo(centroCusto);
        }
        if (ToolString.isAIntegerNumber((String)centroCusto)) {
            return (CentroCusto)this.serviceCentroCusto.get(Long.valueOf(centroCusto));
        }
        for (IndiceGerencialParams.VarCentroCusto h : variaveisCentroCusto) {
            if (!ToolMethods.isEquals((Object)h.getVariavel(), (Object)centroCusto)) continue;
            return h.getCentroCusto();
        }
        return null;
    }

    public ContaValores getContaValores(Long id) {
        return (ContaValores)this.serviceContaValores.get(id);
    }

    public static class TokenType {
        private Type type;
        private String var1;
        private String var2;

        public TokenType(Type type, String var1) {
            this.type = type;
            this.var1 = var1;
        }

        public TokenType(Type type, String var1, String var2) {
            this.type = type;
            this.var1 = var1;
            this.var2 = var2;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getVar1() {
            return this.var1;
        }

        public void setVar1(String var1) {
            this.var1 = var1;
        }

        public String getVar2() {
            return this.var2;
        }

        public void setVar2(String var2) {
            this.var2 = var2;
        }
    }

    public static enum Type {
        PLANO_CONTA,
        PLANO_CONTA_CC_CODIGO,
        PLANO_CONTA_CC_ID,
        PLANO_CONTA_CC_VAR,
        LINHA,
        VARIAVEL,
        VALOR_FINAL_CONTA_VALORES,
        VALOR_LINHA_ACUMULADA,
        VALOR_INICIAL_CONTA_VALORES;

    }
}

