/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indicegerencial.sources;

import com.touchcomp.basementor.model.impl.IndiceGerencialCalculado;
import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.impl.SaldoContaValores;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.AuxBuildIndiceGerencial;
import com.touchcomp.basementorservice.service.impl.planejamentoorcamentario.ServicePlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.impl.saldocontagerencial.ServiceSaldoContaGerencialImpl;
import com.touchcomp.basementorservice.service.impl.saldocontavalores.ServiceSaldoContaValoresImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import lombok.Generated;

public abstract class SourceVariables {
    private IndiceGerencialParams params;
    protected ServiceSaldoContaValoresImpl serviceSaldoContaValores;
    protected ServiceSaldoContaGerencialImpl serviceSaldoContaGerencial;
    protected ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl;
    protected ServiceGrupoEmpresaImpl serviceGrupoEmpresa;
    protected ServiceEmpresaImpl serviceEmpresa;
    private AuxBuildIndiceGerencial auxBuildIndiceGerencial;

    public SourceVariables(IndiceGerencialParams params, ServiceSaldoContaValoresImpl serviceSaldoContaValores, ServiceSaldoContaGerencialImpl serviceSaldoContaGerencial, ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl, AuxBuildIndiceGerencial auxBuildIndiceGerencia, ServiceGrupoEmpresaImpl serviceGrupoEmpresa, ServiceEmpresaImpl serviceEmpresa) {
        this.params = params;
        this.serviceSaldoContaValores = serviceSaldoContaValores;
        this.serviceSaldoContaGerencial = serviceSaldoContaGerencial;
        this.auxBuildIndiceGerencial = auxBuildIndiceGerencia;
        this.servicePlanejamentoOrcamentarioImpl = servicePlanejamentoOrcamentarioImpl;
        this.serviceGrupoEmpresa = serviceGrupoEmpresa;
        this.serviceEmpresa = serviceEmpresa;
    }

    public Double getFixedValue(String chave, IndiceGerencialCalculado ret, int contLinha) throws ExceptionInvalidData {
        AuxBuildIndiceGerencial.TokenType token = this.auxBuildIndiceGerencial.classificar(chave);
        if (!this.canUse(token)) {
            return 0.0;
        }
        switch (token.getType()) {
            case LINHA: {
                return this.getValorLinhaInternal(ret, contLinha, token);
            }
            case PLANO_CONTA: {
                PlanoContaGerencial pc = this.auxBuildIndiceGerencial.getPlanoConta(token.getVar1());
                if (pc == null) {
                    TLogger.get(this.getClass()).debug("Indice invalido.");
                    throw new ExceptionInvalidData("01-02-00727 Plano Conta nao encontrado. Codigo: " + token.getVar1() + " Verifique a Linha: " + contLinha, new Object[0]);
                }
                return this.getSaldoContabilGerencial(pc, null);
            }
            case PLANO_CONTA_CC_CODIGO: {
                PlanoContaGerencial pc = this.auxBuildIndiceGerencial.getPlanoConta(token.getVar1());
                if (pc == null) {
                    TLogger.get(this.getClass()).debug("Indice invalido.");
                    throw new ExceptionInvalidData("01-02-00727 Plano Conta nao encontrado. Codigo: " + token.getVar1() + " Verifique a Linha: " + contLinha, new Object[0]);
                }
                CentroCusto cc = this.auxBuildIndiceGerencial.getCentroCusto(token.getVar2(), this.params.getVariaveisCentroCusto());
                return this.getSaldoContabilGerencial(pc, cc);
            }
            case PLANO_CONTA_CC_ID: {
                PlanoContaGerencial pc = this.auxBuildIndiceGerencial.getPlanoConta(token.getVar1());
                if (pc == null) {
                    TLogger.get(this.getClass()).debug("Indice invalido.");
                    throw new ExceptionInvalidData("01-02-00727 Plano Conta nao encontrado. Codigo: " + token.getVar1() + " Verifique a Linha: " + contLinha, new Object[0]);
                }
                CentroCusto cc = this.auxBuildIndiceGerencial.getCentroCusto(token.getVar2(), this.params.getVariaveisCentroCusto());
                return this.getSaldoContabilGerencial(pc, cc);
            }
            case PLANO_CONTA_CC_VAR: {
                PlanoContaGerencial pc = this.auxBuildIndiceGerencial.getPlanoConta(token.getVar1());
                if (pc == null) {
                    TLogger.get(this.getClass()).debug("Indice invalido.");
                    throw new ExceptionInvalidData("01-02-00727 Plano Conta nao encontrado. Codigo: " + token.getVar1() + " Verifique a Linha: " + contLinha, new Object[0]);
                }
                CentroCusto cc = this.auxBuildIndiceGerencial.getCentroCusto(token.getVar2(), this.params.getVariaveisCentroCusto());
                return this.getSaldoContabilGerencial(pc, cc);
            }
            case VALOR_INICIAL_CONTA_VALORES: {
                ContaValores conta = this.auxBuildIndiceGerencial.getContaValores(Long.valueOf(token.getVar1()));
                return this.getSaldoContaValoresInicial(conta);
            }
            case VALOR_LINHA_ACUMULADA: {
                return this.getResultLinhaAcumulada(token.getVar1());
            }
            case VARIAVEL: {
                return this.getResultVariavelAberta(token.getVar1());
            }
            case VALOR_FINAL_CONTA_VALORES: {
                ContaValores conta = this.auxBuildIndiceGerencial.getContaValores(Long.valueOf(token.getVar1()));
                return this.getSaldoContaValoresFinal(conta);
            }
        }
        return 0.0;
    }

    protected abstract Double getSaldoContabilGerencial(PlanoContaGerencial var1, CentroCusto var2);

    private Double getSaldoContaValoresInicial(ContaValores conta) {
        Date dataSaldo = ToolDate.previousDays((Date)this.params.getDataInicial(), (int)1);
        SaldoContaValores saldoConta = this.serviceSaldoContaValores.findSaldoEmissao(this.params.getDataInicial(), this.params.getDataInicial(), conta);
        Double saldo = saldoConta.getValorSaldoAnterior();
        return saldo;
    }

    private Double getSaldoContaValoresFinal(ContaValores conta) {
        SaldoContaValores saldoConta = this.serviceSaldoContaValores.findSaldoEmissao(this.params.getDataFinal(), this.params.getDataFinal(), conta);
        Double saldo = saldoConta.getValor();
        return saldo;
    }

    private Double getResultVariavelAberta(String chave) {
        for (IndiceGerencialParams.VarAberta var : this.params.getVariaveisAbertas()) {
            if (!ToolMethods.isEquals((Object)var.getVariavel(), (Object)chave)) continue;
            Double valor = var.getValor();
            return valor;
        }
        return 0.0;
    }

    private Double getResultLinhaAcumulada(String chave) {
        if (this.params.getAnterior() == null) {
            return 0.0;
        }
        String linha = chave.substring(chave.indexOf("_") + 1);
        Integer index = Integer.valueOf(linha);
        IndiceGerencialCalculado.LinhaIndice ret = (IndiceGerencialCalculado.LinhaIndice)this.params.getAnterior().getLinhas().get(index - 1);
        return ret.getValor();
    }

    protected boolean canUse(AuxBuildIndiceGerencial.TokenType token) {
        return true;
    }

    private Double getValorLinhaInternal(IndiceGerencialCalculado ret, int contLinha, AuxBuildIndiceGerencial.TokenType token) throws ExceptionInvalidData {
        Integer index = Integer.valueOf(token.getVar1());
        if (index <= 0 || index > ret.getLinhas().size()) {
            TLogger.get(this.getClass()).debug("Indice invalido.");
            throw new ExceptionInvalidData("01-02-00727 Indice invalido. Verifique a Linha: " + contLinha, new Object[0]);
        }
        IndiceGerencialCalculado.LinhaIndice ind = (IndiceGerencialCalculado.LinhaIndice)ret.getLinhas().get(index - 1);
        return this.getValorLinha(ind);
    }

    protected abstract Double getValorLinha(IndiceGerencialCalculado.LinhaIndice var1);

    @Generated
    public IndiceGerencialParams getParams() {
        return this.params;
    }

    @Generated
    public ServiceSaldoContaValoresImpl getServiceSaldoContaValores() {
        return this.serviceSaldoContaValores;
    }

    @Generated
    public ServiceSaldoContaGerencialImpl getServiceSaldoContaGerencial() {
        return this.serviceSaldoContaGerencial;
    }

    @Generated
    public ServicePlanejamentoOrcamentarioImpl getServicePlanejamentoOrcamentarioImpl() {
        return this.servicePlanejamentoOrcamentarioImpl;
    }

    @Generated
    public ServiceGrupoEmpresaImpl getServiceGrupoEmpresa() {
        return this.serviceGrupoEmpresa;
    }

    @Generated
    public ServiceEmpresaImpl getServiceEmpresa() {
        return this.serviceEmpresa;
    }

    @Generated
    public AuxBuildIndiceGerencial getAuxBuildIndiceGerencial() {
        return this.auxBuildIndiceGerencial;
    }

    @Generated
    public void setParams(IndiceGerencialParams params) {
        this.params = params;
    }

    @Generated
    public void setServiceSaldoContaValores(ServiceSaldoContaValoresImpl serviceSaldoContaValores) {
        this.serviceSaldoContaValores = serviceSaldoContaValores;
    }

    @Generated
    public void setServiceSaldoContaGerencial(ServiceSaldoContaGerencialImpl serviceSaldoContaGerencial) {
        this.serviceSaldoContaGerencial = serviceSaldoContaGerencial;
    }

    @Generated
    public void setServicePlanejamentoOrcamentarioImpl(ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl) {
        this.servicePlanejamentoOrcamentarioImpl = servicePlanejamentoOrcamentarioImpl;
    }

    @Generated
    public void setServiceGrupoEmpresa(ServiceGrupoEmpresaImpl serviceGrupoEmpresa) {
        this.serviceGrupoEmpresa = serviceGrupoEmpresa;
    }

    @Generated
    public void setServiceEmpresa(ServiceEmpresaImpl serviceEmpresa) {
        this.serviceEmpresa = serviceEmpresa;
    }

    @Generated
    public void setAuxBuildIndiceGerencial(AuxBuildIndiceGerencial auxBuildIndiceGerencial) {
        this.auxBuildIndiceGerencial = auxBuildIndiceGerencial;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceVariables)) {
            return false;
        }
        SourceVariables other = (SourceVariables)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IndiceGerencialParams this$params = this.getParams();
        IndiceGerencialParams other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        ServiceSaldoContaValoresImpl this$serviceSaldoContaValores = this.getServiceSaldoContaValores();
        ServiceSaldoContaValoresImpl other$serviceSaldoContaValores = other.getServiceSaldoContaValores();
        if (this$serviceSaldoContaValores == null ? other$serviceSaldoContaValores != null : !this$serviceSaldoContaValores.equals(other$serviceSaldoContaValores)) {
            return false;
        }
        ServiceSaldoContaGerencialImpl this$serviceSaldoContaGerencial = this.getServiceSaldoContaGerencial();
        ServiceSaldoContaGerencialImpl other$serviceSaldoContaGerencial = other.getServiceSaldoContaGerencial();
        if (this$serviceSaldoContaGerencial == null ? other$serviceSaldoContaGerencial != null : !this$serviceSaldoContaGerencial.equals(other$serviceSaldoContaGerencial)) {
            return false;
        }
        ServicePlanejamentoOrcamentarioImpl this$servicePlanejamentoOrcamentarioImpl = this.getServicePlanejamentoOrcamentarioImpl();
        ServicePlanejamentoOrcamentarioImpl other$servicePlanejamentoOrcamentarioImpl = other.getServicePlanejamentoOrcamentarioImpl();
        if (this$servicePlanejamentoOrcamentarioImpl == null ? other$servicePlanejamentoOrcamentarioImpl != null : !this$servicePlanejamentoOrcamentarioImpl.equals(other$servicePlanejamentoOrcamentarioImpl)) {
            return false;
        }
        ServiceGrupoEmpresaImpl this$serviceGrupoEmpresa = this.getServiceGrupoEmpresa();
        ServiceGrupoEmpresaImpl other$serviceGrupoEmpresa = other.getServiceGrupoEmpresa();
        if (this$serviceGrupoEmpresa == null ? other$serviceGrupoEmpresa != null : !this$serviceGrupoEmpresa.equals(other$serviceGrupoEmpresa)) {
            return false;
        }
        ServiceEmpresaImpl this$serviceEmpresa = this.getServiceEmpresa();
        ServiceEmpresaImpl other$serviceEmpresa = other.getServiceEmpresa();
        if (this$serviceEmpresa == null ? other$serviceEmpresa != null : !this$serviceEmpresa.equals(other$serviceEmpresa)) {
            return false;
        }
        AuxBuildIndiceGerencial this$auxBuildIndiceGerencial = this.getAuxBuildIndiceGerencial();
        AuxBuildIndiceGerencial other$auxBuildIndiceGerencial = other.getAuxBuildIndiceGerencial();
        return !(this$auxBuildIndiceGerencial == null ? other$auxBuildIndiceGerencial != null : !this$auxBuildIndiceGerencial.equals(other$auxBuildIndiceGerencial));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceVariables;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndiceGerencialParams $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        ServiceSaldoContaValoresImpl $serviceSaldoContaValores = this.getServiceSaldoContaValores();
        result = result * 59 + ($serviceSaldoContaValores == null ? 43 : $serviceSaldoContaValores.hashCode());
        ServiceSaldoContaGerencialImpl $serviceSaldoContaGerencial = this.getServiceSaldoContaGerencial();
        result = result * 59 + ($serviceSaldoContaGerencial == null ? 43 : $serviceSaldoContaGerencial.hashCode());
        ServicePlanejamentoOrcamentarioImpl $servicePlanejamentoOrcamentarioImpl = this.getServicePlanejamentoOrcamentarioImpl();
        result = result * 59 + ($servicePlanejamentoOrcamentarioImpl == null ? 43 : $servicePlanejamentoOrcamentarioImpl.hashCode());
        ServiceGrupoEmpresaImpl $serviceGrupoEmpresa = this.getServiceGrupoEmpresa();
        result = result * 59 + ($serviceGrupoEmpresa == null ? 43 : $serviceGrupoEmpresa.hashCode());
        ServiceEmpresaImpl $serviceEmpresa = this.getServiceEmpresa();
        result = result * 59 + ($serviceEmpresa == null ? 43 : $serviceEmpresa.hashCode());
        AuxBuildIndiceGerencial $auxBuildIndiceGerencial = this.getAuxBuildIndiceGerencial();
        result = result * 59 + ($auxBuildIndiceGerencial == null ? 43 : $auxBuildIndiceGerencial.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SourceVariables(params=" + String.valueOf(this.getParams()) + ", serviceSaldoContaValores=" + String.valueOf(this.getServiceSaldoContaValores()) + ", serviceSaldoContaGerencial=" + String.valueOf(this.getServiceSaldoContaGerencial()) + ", servicePlanejamentoOrcamentarioImpl=" + String.valueOf(this.getServicePlanejamentoOrcamentarioImpl()) + ", serviceGrupoEmpresa=" + String.valueOf(this.getServiceGrupoEmpresa()) + ", serviceEmpresa=" + String.valueOf(this.getServiceEmpresa()) + ", auxBuildIndiceGerencial=" + String.valueOf(this.getAuxBuildIndiceGerencial()) + ")";
    }
}

