/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indicegerencial.sources;

import com.touchcomp.basementor.model.impl.IndiceGerencialCalculado;
import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.MetaControleGerLinha;
import com.touchcomp.basementor.model.vo.MetaControleGerLinhaVlr;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.AuxBuildIndiceGerencial;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.SourceVariables;
import com.touchcomp.basementorservice.service.impl.planejamentoorcamentario.ServicePlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.impl.saldocontagerencial.ServiceSaldoContaGerencialImpl;
import com.touchcomp.basementorservice.service.impl.saldocontavalores.ServiceSaldoContaValoresImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import java.util.Optional;

public class SourceVariablesMetaImpl
extends SourceVariables {
    public SourceVariablesMetaImpl(IndiceGerencialParams params, ServiceSaldoContaValoresImpl serviceSaldoContaValores, ServiceSaldoContaGerencialImpl serviceSaldoContaGerencial, ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl, AuxBuildIndiceGerencial auxBuildIndiceGerencia, ServiceGrupoEmpresaImpl serviceGrupoEmpresa, ServiceEmpresaImpl serviceEmpresa) {
        super(params, serviceSaldoContaValores, serviceSaldoContaGerencial, servicePlanejamentoOrcamentarioImpl, auxBuildIndiceGerencia, serviceGrupoEmpresa, serviceEmpresa);
    }

    @Override
    protected Double getSaldoContabilGerencial(PlanoContaGerencial pc, CentroCusto cc) {
        if (this.getParams().getValoresMeta() == null) {
            return 0.0;
        }
        if (cc != null) {
            Optional<MetaControleGerLinha> found = this.getParams().getValoresMeta().getMetasLinhas().stream().filter(i -> ToolMethods.isEquals((Object)cc, (Object)i.getCentroCusto()) && ToolMethods.isEquals((Object)pc, (Object)i.getPlanoContaGerencial())).findFirst();
            if (found.isPresent()) {
                return this.filtraSomaValoresMeta(found.get().getValoresLinhas());
            }
        } else {
            Optional<MetaControleGerLinha> found = this.getParams().getValoresMeta().getMetasLinhas().stream().filter(i -> i.getCentroCusto() == null && ToolMethods.isEquals((Object)pc, (Object)i.getPlanoContaGerencial())).findFirst();
            if (found.isPresent()) {
                return this.filtraSomaValoresMeta(found.get().getValoresLinhas());
            }
        }
        return 0.0;
    }

    private double filtraSomaValoresMeta(List<MetaControleGerLinhaVlr> valoresLinhas) {
        double soma = 0.0;
        for (MetaControleGerLinhaVlr vlr : valoresLinhas) {
            if (!ToolMethods.isEquals((Object)vlr.getIntervaloControleGerPer(), (Object)this.getParams().getIntervaloControleGerPer())) continue;
            soma += vlr.getValorMeta().doubleValue();
        }
        return soma;
    }

    @Override
    protected Double getValorLinha(IndiceGerencialCalculado.LinhaIndice ind) {
        return ind.getValorMeta();
    }
}

