/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.indicegerencial.sources;

import com.touchcomp.basementor.constants.enums.filtroanaliseorcamentaria.EnumConstFiltroAnaliseOrcamentaria;
import com.touchcomp.basementor.model.impl.IndiceGerencialCalculado;
import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.impl.SaldoContaGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.AuxBuildIndiceGerencial;
import com.touchcomp.basementorservice.service.impl.indicegerencial.sources.SourceVariables;
import com.touchcomp.basementorservice.service.impl.planejamentoorcamentario.ServicePlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.impl.saldocontagerencial.ServiceSaldoContaGerencialImpl;
import com.touchcomp.basementorservice.service.impl.saldocontavalores.ServiceSaldoContaValoresImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;

public class SourceVariablesProvisionadoImpl
extends SourceVariables {
    private List<SaldoContaGerencial> saldosContasGerenciais;

    public SourceVariablesProvisionadoImpl(IndiceGerencialParams params, ServiceSaldoContaValoresImpl serviceSaldoContaValores, ServiceSaldoContaGerencialImpl serviceSaldoContaGerencial, ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl, AuxBuildIndiceGerencial auxBuildIndiceGerencia, ServiceGrupoEmpresaImpl serviceGrupoEmpresa, ServiceEmpresaImpl serviceEmpresa) {
        super(params, serviceSaldoContaValores, serviceSaldoContaGerencial, servicePlanejamentoOrcamentarioImpl, auxBuildIndiceGerencia, serviceGrupoEmpresa, serviceEmpresa);
        this.saldosContasGerenciais = params.getSaldosContasGerenciais();
    }

    @Override
    protected Double getSaldoContabilGerencial(PlanoContaGerencial pc, CentroCusto cc) {
        double ret = 0.0;
        List saldos = null;
        if (cc != null) {
            saldos = this.getSaldosPorCentroCusto(pc, cc);
            for (SaldoContaGerencial saldo : saldos) {
                ret += saldo.getSaldoAtualProv().doubleValue();
            }
        } else {
            saldos = this.getSaldos();
            for (SaldoContaGerencial saldo : saldos) {
                if (saldo.getCodigo() == null || !saldo.getCodigo().trim().equalsIgnoreCase(pc.getCodigo().trim())) continue;
                ret += saldo.getSaldoAtualProv().doubleValue();
            }
        }
        return ret;
    }

    private List getSaldos() {
        if (this.saldosContasGerenciais == null || this.saldosContasGerenciais.isEmpty()) {
            if (!ToolMethods.isNull((Object)this.getParams().getFiltroEmpresa()).booleanValue() && ToolMethods.isEquals((Object)this.getParams().getFiltroEmpresa(), (Object)EnumConstFiltroAnaliseOrcamentaria.GRUPO_EMPRESA)) {
                ArrayList<SaldoContaGerencial> aux = new ArrayList<SaldoContaGerencial>();
                List<Empresa> empresas = this.serviceGrupoEmpresa.importarEmpresasGrupo(((Empresa)this.serviceEmpresa.get(this.getParams().getIdEmpInicial())).getEmpresaDados().getGrupoEmpresa());
                for (Empresa empresa : empresas) {
                    aux.addAll(this.serviceSaldoContaGerencial.findSaldoGerencial(this.getParams().getDataInicial(), this.getParams().getDataFinal(), "010000000000000", "999999999999999", empresa.getIdentificador(), empresa.getIdentificador(), this.getParams().getProvisionadoInicial(), this.getParams().getProvisionadoFinal(), this.getParams().getTipoLancamento(), this.getParams().getTipoData()));
                }
                this.saldosContasGerenciais = aux;
            } else {
                this.saldosContasGerenciais = this.serviceSaldoContaGerencial.findSaldoGerencial(this.getParams().getDataInicial(), this.getParams().getDataFinal(), "010000000000000", "999999999999999", this.getParams().getIdEmpInicial(), this.getParams().getIdEmpFinal(), this.getParams().getProvisionadoInicial(), this.getParams().getProvisionadoFinal(), this.getParams().getTipoLancamento(), this.getParams().getTipoData());
            }
        }
        return this.saldosContasGerenciais;
    }

    private List getSaldosPorCentroCusto(PlanoContaGerencial pc, CentroCusto cc) {
        List<SaldoContaGerencial> aux = new ArrayList<SaldoContaGerencial>();
        if (!ToolMethods.isNull((Object)this.getParams().getFiltroEmpresa()).booleanValue() && ToolMethods.isEquals((Object)this.getParams().getFiltroEmpresa(), (Object)EnumConstFiltroAnaliseOrcamentaria.GRUPO_EMPRESA)) {
            List<Empresa> empresas = this.serviceGrupoEmpresa.importarEmpresasGrupo(((Empresa)this.serviceEmpresa.get(this.getParams().getIdEmpInicial())).getEmpresaDados().getGrupoEmpresa());
            for (Empresa empresa : empresas) {
                aux.addAll(this.serviceSaldoContaGerencial.findSaldoGerencial(this.getParams().getDataInicial(), this.getParams().getDataFinal(), pc.getCodigo(), pc.getCodigo(), empresa.getIdentificador(), empresa.getIdentificador(), this.getParams().getProvisionadoInicial(), this.getParams().getProvisionadoFinal(), this.getParams().getTipoLancamento(), this.getParams().getTipoData(), cc.getIdentificador(), cc.getIdentificador()));
            }
        } else {
            aux = this.serviceSaldoContaGerencial.findSaldoGerencial(this.getParams().getDataInicial(), this.getParams().getDataFinal(), pc.getCodigo(), pc.getCodigo(), this.getParams().getIdEmpInicial(), this.getParams().getIdEmpFinal(), this.getParams().getProvisionadoInicial(), this.getParams().getProvisionadoFinal(), this.getParams().getTipoLancamento(), this.getParams().getTipoData(), cc.getIdentificador(), cc.getIdentificador());
        }
        return aux;
    }

    @Override
    protected boolean canUse(AuxBuildIndiceGerencial.TokenType token) {
        switch (token.getType()) {
            case VALOR_FINAL_CONTA_VALORES: {
                return false;
            }
            case VALOR_INICIAL_CONTA_VALORES: {
                return false;
            }
            case VARIAVEL: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Double getValorLinha(IndiceGerencialCalculado.LinhaIndice ind) {
        return ind.getValorProvisionado();
    }
}

