/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.infadicionalpessoa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.InfAdicionalPesImg;
import com.touchcomp.basementor.model.vo.InfAdicionalPesInf;
import com.touchcomp.basementor.model.vo.InfAdicionalPessoa;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalPesInf;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementorbinary.model.InfAdicionaisImagemPes;
import com.touchcomp.basementorbinary.service.impl.inf_adicional_pes_img.ServiceBinaryInfAdicionalPesImgImpl;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoInfAdicionalPessoaImpl;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.modelofichatecnica.ServiceModeloFichaTecnicaImpl;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.image.ToolImage;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.touchvomodel.vo.infadicionalpesinf.web.DTOInfAdicionalPesInf;
import com.touchcomp.touchvomodel.vo.infadicionalpessoa.web.DTOInfAdicionalPessoa;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ServiceInfAdicionalPessoaImpl
extends ServiceGenericEntityImpl<InfAdicionalPessoa, Long, DaoInfAdicionalPessoaImpl> {
    ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnicaImpl;
    ServiceBinaryInfAdicionalPesImgImpl serviceBinaryInfAdicionalPesImgImpl;

    @Autowired
    public ServiceInfAdicionalPessoaImpl(DaoInfAdicionalPessoaImpl dao, ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnicaImpl, ServiceBinaryInfAdicionalPesImgImpl serviceBinaryInfAdicionalPesImgImpl) {
        super(dao);
        this.serviceModeloFichaTecnicaImpl = serviceModeloFichaTecnicaImpl;
        this.serviceBinaryInfAdicionalPesImgImpl = serviceBinaryInfAdicionalPesImgImpl;
    }

    @Override
    public InfAdicionalPessoa beforeSave(InfAdicionalPessoa vo) {
        if (this.isNotNull(vo.getInfAdicionalPesImg()).booleanValue()) {
            vo.getInfAdicionalPesImg().forEach(i -> i.setInfAdicionalPessoa(vo));
        }
        if (this.isNotNull(vo.getInfAdicionalPesInf()).booleanValue()) {
            for (InfAdicionalPesInf inf : vo.getInfAdicionalPesInf()) {
                inf.setInfAdicionalPessoa(vo);
                if (!this.isNotNull(inf.getItemInfAdicionalPesInf()).booleanValue()) continue;
                inf.getItemInfAdicionalPesInf().forEach(i -> i.setInfAdicionalPesInf(inf));
            }
        }
        return vo;
    }

    public Object buildImagemPessoa(String descricao, MultipartFile imagem) throws ExceptionInvalidData, IOException, ExceptionIO {
        if (this.isNull(imagem).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0832.001", new Object[0]);
        }
        String hexImg = this.buildImage(imagem);
        DTOInfAdicionalPessoa.DTOImagemPessoa dto = new DTOInfAdicionalPessoa.DTOImagemPessoa();
        dto.setHexFotoPessoa(hexImg);
        dto.setDescricao(descricao);
        return dto;
    }

    private Boolean imagensSecundariasMigradas(InfAdicionalPessoa inf) {
        List imagens = this.serviceBinaryInfAdicionalPesImgImpl.findImagensPessoa(inf.getIdentificador());
        return !imagens.isEmpty();
    }

    public void converterImagens() throws ExceptionIO {
        List<InfAdicionalPessoa> data;
        int regsTime = 30;
        int regs = 0;
        do {
            data = ((DaoInfAdicionalPessoaImpl)this.getDao()).getAllInfo(regsTime, regs);
            for (InfAdicionalPessoa inf : data) {
                Boolean imagensMigradas = this.imagensSecundariasMigradas(inf);
                if (imagensMigradas.booleanValue()) continue;
                for (InfAdicionalPesImg imgInf : inf.getInfAdicionalPesImg()) {
                    byte[] img = ((DaoInfAdicionalPessoaImpl)this.getDao()).getImagemAntiga(imgInf);
                    String str = this.processImage(img, ToolImage.SIZE_MEDIUM_THUMB_NAIL);
                    imgInf.setImagemPessoa(str);
                    InfAdicionaisImagemPes infImgAdc = new InfAdicionaisImagemPes();
                    infImgAdc.setDescricao(MessagesBaseMentor.getMsg((String)"padrao", (Object[])new Object[0]));
                    infImgAdc.setIdInfAdicional(inf.getIdentificador());
                    infImgAdc.setHexFotoPessoa(str);
                    this.serviceBinaryInfAdicionalPesImgImpl.saveOrUpdate((Object)infImgAdc);
                }
                this.saveOrUpdate(inf);
            }
            regs += regsTime;
        } while (TMethods.isWithData(data));
    }

    public String processImage(byte[] img, Dimension dimension) throws ExceptionIO {
        if (this.isNull(img).booleanValue()) {
            return null;
        }
        ToolImage.ImageFormat format = ToolImage.getImageFormat((byte[])img);
        if (!ToolMethods.isEquals((Object)format, (Object)ToolImage.ImageFormat.PNG)) {
            img = ToolImage.convertImage((byte[])img, (ToolImage.ImageFormat)ToolImage.ImageFormat.PNG);
        }
        File temp = ToolFile.createTempFile((String)"imagem.png");
        ToolFile.writeBytesOnFile((File)temp, (byte[])img);
        temp = ToolImage.resizeImageKeepAspectRatioIfGreater((File)temp, (Dimension)ToolImage.SIZE_MEDIUM_THUMB_NAIL);
        img = ToolFile.getBytesFromFile((File)temp);
        return ToolBase64.encodeBase64((byte[])img);
    }

    private String buildImage(MultipartFile imagem) throws ExceptionIO, IOException {
        byte[] img = imagem.getBytes();
        String str = this.processImage(img, ToolImage.SIZE_STANDARD);
        return str;
    }

    public void excluirImagemAdicional(Long idInfAdicionaisImagemPes) throws ExceptionObjNotFound {
        if (this.isNotNull(idInfAdicionaisImagemPes).booleanValue()) {
            this.serviceBinaryInfAdicionalPesImgImpl.deleteImagemAdicionalPessoa(idInfAdicionaisImagemPes);
        }
    }

    public Object getImagensPessoaWeb(Long idInfAdicional) {
        LinkedList<DTOInfAdicionalPessoa.DTOImagemPessoa> ret = new LinkedList<DTOInfAdicionalPessoa.DTOImagemPessoa>();
        List data = this.serviceBinaryInfAdicionalPesImgImpl.getImagensPessoa(idInfAdicional);
        if (ServiceInfAdicionalPessoaImpl.isWithData(data)) {
            for (Object[] inf : data) {
                DTOInfAdicionalPessoa.DTOImagemPessoa dto = new DTOInfAdicionalPessoa.DTOImagemPessoa();
                dto.setIdentificador((Long)inf[0]);
                dto.setDescricao((String)inf[1]);
                ret.add(dto);
            }
        }
        return ret;
    }

    public File getImagemPessoa(Long idInfAdicionaisImagemPes) throws ExceptionDecodeHexString, ExceptionIO, ExceptionDecodeHexString64 {
        InfAdicionaisImagemPes vo = this.serviceBinaryInfAdicionalPesImgImpl.getInfAdicionaisImagemPes(idInfAdicionaisImagemPes);
        if (this.isNull(vo).booleanValue() || !this.isStrWithData(vo.getHexFotoPessoa())) {
            return null;
        }
        File arquivo = ToolFile.createTempFile((String)"imagem", (String)".png");
        ToolFile.writeBytesOnFile((File)arquivo, (byte[])ToolBase64.decodeBase64((String)vo.getHexFotoPessoa()));
        return arquivo;
    }

    public List<DTOInfAdicionalPesInf> buildEspecificacoesModeloFichaTecnica(Long[] ids) {
        List listModeloFichaTecnica = this.serviceModeloFichaTecnicaImpl.gets(ids);
        LinkedList<InfAdicionalPesInf> listInfAdicionalPesInf = new LinkedList<InfAdicionalPesInf>();
        for (ModeloFichaTecnica modeloFicha : listModeloFichaTecnica) {
            InfAdicionalPesInf item = new InfAdicionalPesInf();
            item.setModeloFicha(modeloFicha);
            ArrayList<ItemInfAdicionalPesInf> listItemInfAdicionalPesInf = new ArrayList<ItemInfAdicionalPesInf>();
            for (ItemModeloFichaTecnica itemModelo : modeloFicha.getItensModeloFichaTecnica()) {
                ItemInfAdicionalPesInf itemInf = new ItemInfAdicionalPesInf();
                itemInf.setItensModeloFichaTecnica(itemModelo);
                itemInf.setInfAdicionalPesInf(item);
                itemInf.setChave(itemModelo.getDescricao());
                itemInf.setValorObrigatorio(itemModelo.getCampoObrigatorio());
                listItemInfAdicionalPesInf.add(itemInf);
            }
            item.setItemInfAdicionalPesInf(listItemInfAdicionalPesInf);
            listInfAdicionalPesInf.add(item);
        }
        return this.buildToDTOGeneric(listInfAdicionalPesInf, DTOInfAdicionalPesInf.class);
    }

    public TempSaveObj<InfAdicionalPessoa> salvarInformacaoAdicionalPessoa(DTOInfAdicionalPessoa dto, ValidGeneric<InfAdicionalPessoa> validator) {
        TempSaveObj<InfAdicionalPessoa> temp = new TempSaveObj<InfAdicionalPessoa>();
        temp.setValidator(validator);
        InfAdicionalPessoa toSave = (InfAdicionalPessoa)this.buildToEntity(dto);
        validator.clearContainer();
        validator.isValidData((InterfaceVO)toSave);
        if (validator.hasErrors()) {
            temp.setStatus(EnumConstantsMentorStatus.ERRO);
            return temp;
        }
        this.beforeSave(toSave);
        toSave = this.saveOrUpdate(toSave);
        this.salvarImagensProduto(dto.getImagensPessoa(), toSave);
        temp.setResult(toSave);
        return temp;
    }

    private void salvarImagensProduto(List<DTOInfAdicionalPessoa.DTOImagemPessoa> imgs, InfAdicionalPessoa vo) {
        if (ServiceInfAdicionalPessoaImpl.isWithData(imgs) && this.isNotNull(vo.getIdentificador()).booleanValue()) {
            for (DTOInfAdicionalPessoa.DTOImagemPessoa img : imgs) {
                this.serviceBinaryInfAdicionalPesImgImpl.newInfAdicionaisImgPessoa(vo.getIdentificador(), img.getDescricao(), img.getHexFotoPessoa());
            }
        }
    }
}

