/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.infadicionalproduto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.InfAdicionalProdImg;
import com.touchcomp.basementor.model.vo.InfAdicionalProdInf;
import com.touchcomp.basementor.model.vo.InfAdicionalProduto;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalProdInf;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementorbinary.model.InfAdicionaisImagemProd;
import com.touchcomp.basementorbinary.model.InfAdicionaisProduto;
import com.touchcomp.basementorbinary.service.impl.inf_adicionais_img_prod.ServiceBinaryInfAdicionaisImagemProdImpl;
import com.touchcomp.basementorbinary.service.impl.inf_adicional_produto.ServiceBinaryInfAdicionaisProdutoImpl;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoInfAdicionalProdutoImpl;
import com.touchcomp.basementorservice.helpers.impl.modelofichatecnica.HelperModeloFichaTecnica;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.modelofichatecnica.ServiceModeloFichaTecnicaImpl;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.image.ToolImage;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.touchvomodel.vo.infadicionalproduto.web.DTOInfAdicionalProduto;
import com.touchcomp.touchvomodel.vo.infadicionalproduto.web.DTOMobileInfAdicionalProdImg;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ServiceInfAdicionalProdutoImpl
extends ServiceGenericEntityImpl<InfAdicionalProduto, Long, DaoInfAdicionalProdutoImpl> {
    @Autowired
    private ServiceBinaryInfAdicionaisProdutoImpl serviceBinInfAdcProd;
    @Autowired
    private ServiceBinaryInfAdicionaisImagemProdImpl serviceBinInfImgAdcProd;
    @Autowired
    private ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnica;
    @Autowired
    private HelperModeloFichaTecnica helperModeloFichaTec;

    @Autowired
    public ServiceInfAdicionalProdutoImpl(DaoInfAdicionalProdutoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public InfAdicionalProduto beforeSave(InfAdicionalProduto vo) {
        vo.setDataUltModificacao(new Date());
        if (this.isNotNull(vo.getInfAdicionalProdImg()).booleanValue()) {
            vo.getInfAdicionalProdImg().forEach(i -> i.setInfAdicionalProduto(vo));
        }
        if (this.isNotNull(vo.getInfAdicionalProdInf()).booleanValue()) {
            for (InfAdicionalProdInf inf : vo.getInfAdicionalProdInf()) {
                inf.setInfAdicionalProduto(vo);
                if (!this.isNotNull(inf.getItemInfAdicionalProdInf()).booleanValue()) continue;
                inf.getItemInfAdicionalProdInf().forEach(i -> i.setInfAdicionalProdInf(inf));
            }
        }
        return vo;
    }

    public List<InfAdicionalProduto> getInfAdicionalProdutoByProduto(Long idProdutoL) {
        return ((DaoInfAdicionalProdutoImpl)this.getGenericDao()).getInfAdicionalProdutoByProduto(idProdutoL);
    }

    public InfAdicionalProduto findFirstInfAdicionalProdutoByProduto(Long idProdutoL) {
        return ((DaoInfAdicionalProdutoImpl)this.getGenericDao()).findFirstInfAdicionalProdutoByProduto(idProdutoL);
    }

    public void criarThumbImage() throws ExceptionIO, ExceptionDecodeHexString64 {
        List<InfAdicionalProduto> data;
        int regsTime = 30;
        int regs = 0;
        do {
            data = ((DaoInfAdicionalProdutoImpl)this.getDao()).getAllInfo(regsTime, regs);
            for (InfAdicionalProduto inf : data) {
                String imageBase64;
                String img = null;
                if (TMethods.isStrWithData((String)inf.getHexFotoProduto())) {
                    img = inf.getHexFotoProduto();
                }
                if (TMethods.isWithData((Collection)inf.getInfAdicionalProdImg()) && ToolMethods.isStrWithData((String)(imageBase64 = ((InfAdicionalProdImg)inf.getInfAdicionalProdImg().get(0)).getImagemProduto()))) {
                    byte[] imgByte = ToolBase64.decodeBase64((String)imageBase64);
                    img = this.processImage(imgByte, ToolImage.SIZE_MEDIUM_THUMB_NAIL);
                    inf.setHexFotoProduto(ToolBase64.encodeBase64((String)img));
                }
                this.saveOrUpdate(inf);
                InfAdicionaisProduto infAdicional = this.serviceBinInfAdcProd.getInfAdicionaisProduto(inf.getIdentificador());
                if (this.isNull(infAdicional).booleanValue()) {
                    infAdicional = new InfAdicionaisProduto();
                    infAdicional.setIdInfAdicional(inf.getIdentificador());
                }
                infAdicional.setHexFotoProduto(img);
                this.serviceBinInfAdcProd.saveOrUpdate((Object)infAdicional);
            }
            regs += regsTime;
        } while (TMethods.isWithData(data));
    }

    public List<DTOMobileInfAdicionalProdImg> getThumbImagesProdutos(Long[] idProdutos) {
        List<InfAdicionalProduto> infos = ((DaoInfAdicionalProdutoImpl)this.getDao()).getInfAdicionalProdutos(idProdutos);
        LinkedList<DTOMobileInfAdicionalProdImg> ret = new LinkedList<DTOMobileInfAdicionalProdImg>();
        for (InfAdicionalProduto info : infos) {
            DTOMobileInfAdicionalProdImg dto = new DTOMobileInfAdicionalProdImg();
            dto.setImage(info.getHexFotoProduto());
            dto.setProdutoIdentificador(info.getProduto().getIdentificador());
            ret.add(dto);
        }
        return ret;
    }

    public List<DTOMobileInfAdicionalProdImg> getImagensProduto(Long idProduto) {
        LinkedList<DTOMobileInfAdicionalProdImg> ret = new LinkedList<DTOMobileInfAdicionalProdImg>();
        InfAdicionalProduto info = ((DaoInfAdicionalProdutoImpl)this.getDao()).getInfAdicionalProduto(idProduto);
        if (info != null) {
            for (InfAdicionalProdImg infAdicionalProdImg : info.getInfAdicionalProdImg()) {
                DTOMobileInfAdicionalProdImg d = new DTOMobileInfAdicionalProdImg();
                d.setProdutoIdentificador(idProduto);
                d.setImage(infAdicionalProdImg.getImagemProduto());
                ret.add(d);
            }
        }
        return ret;
    }

    private Boolean imagensSecundariasMigradas(InfAdicionalProduto inf) {
        List imagens = this.serviceBinInfImgAdcProd.findImagensProduto(inf.getIdentificador());
        return !imagens.isEmpty();
    }

    public void converterImagens() throws ExceptionIO {
        List<InfAdicionalProduto> data;
        int regsTime = 30;
        int regs = 0;
        do {
            data = ((DaoInfAdicionalProdutoImpl)this.getDao()).getAllInfo(regsTime, regs);
            for (InfAdicionalProduto inf : data) {
                Boolean imagensMigradas = this.imagensSecundariasMigradas(inf);
                if (imagensMigradas.booleanValue()) continue;
                for (InfAdicionalProdImg imgInf : inf.getInfAdicionalProdImg()) {
                    byte[] img = ((DaoInfAdicionalProdutoImpl)this.getDao()).getImagemAntiga(imgInf);
                    String str = this.processImage(img, ToolImage.SIZE_MEDIUM_THUMB_NAIL);
                    imgInf.setImagemProduto(str);
                    InfAdicionaisImagemProd infImgAdc = new InfAdicionaisImagemProd();
                    infImgAdc.setDescricao(MessagesBaseMentor.getMsg((String)"padrao", (Object[])new Object[0]));
                    infImgAdc.setIdInfAdicional(inf.getIdentificador());
                    infImgAdc.setImagemProduto(str);
                    this.serviceBinInfImgAdcProd.saveOrUpdate((Object)infImgAdc);
                }
                this.saveOrUpdate(inf);
            }
            regs += regsTime;
        } while (TMethods.isWithData(data));
    }

    public String processImage(byte[] img, Dimension dimension) throws ExceptionIO {
        if (this.isNull(img).booleanValue()) {
            return null;
        }
        ToolImage.ImageFormat format = ToolImage.getImageFormat((byte[])img);
        if (!ToolMethods.isEquals((Object)format, (Object)ToolImage.ImageFormat.PNG)) {
            img = ToolImage.convertImage((byte[])img, (ToolImage.ImageFormat)ToolImage.ImageFormat.PNG);
        }
        File temp = ToolFile.createTempFile((String)"imagem.png");
        ToolFile.writeBytesOnFile((File)temp, (byte[])img);
        temp = ToolImage.resizeImageKeepAspectRatioIfGreater((File)temp, (Dimension)ToolImage.SIZE_MEDIUM_THUMB_NAIL);
        img = ToolFile.getBytesFromFile((File)temp);
        return ToolBase64.encodeBase64((byte[])img);
    }

    private String buildImage(MultipartFile imagem) throws ExceptionIO, IOException {
        byte[] img = imagem.getBytes();
        String str = this.processImage(img, ToolImage.SIZE_STANDARD);
        return str;
    }

    public DTOInfAdicionalProduto.DTOImagemPrincipalProduto buildImagemPrincipalProduto(MultipartFile imagem) throws ExceptionInvalidData, IOException, ExceptionIO {
        if (this.isNull(imagem).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0831.001", new Object[0]);
        }
        String hexImg = this.buildImage(imagem);
        DTOInfAdicionalProduto.DTOImagemPrincipalProduto dto = new DTOInfAdicionalProduto.DTOImagemPrincipalProduto();
        dto.setHexFotoProduto(hexImg);
        return dto;
    }

    public DTOInfAdicionalProduto.DTOImagemProduto buildImagemProduto(String descricao, MultipartFile imagem) throws ExceptionInvalidData, IOException, ExceptionIO {
        if (this.isNull(imagem).booleanValue() || !this.isStrWithData(descricao)) {
            throw new ExceptionInvalidData("E.ERP.0831.001", new Object[0]);
        }
        String hexImg = this.buildImage(imagem);
        DTOInfAdicionalProduto.DTOImagemProduto dto = new DTOInfAdicionalProduto.DTOImagemProduto();
        dto.setHexFotoProduto(hexImg);
        dto.setDescricao(descricao);
        return dto;
    }

    public InfAdicionaisProduto findByProduto(Long idProduto) {
        InfAdicionalProduto vo = this.findFirstInfAdicionalProdutoByProduto(idProduto);
        if (vo != null) {
            return this.serviceBinInfAdcProd.getInfAdicionaisProduto(vo.getIdentificador());
        }
        return null;
    }

    public File getImagemPrincipalProduto(Long idInfAdicionalProduto) throws ExceptionIO, ExceptionDecodeHexString64 {
        InfAdicionaisProduto vo = this.serviceBinInfAdcProd.getInfAdicionaisProduto(idInfAdicionalProduto);
        if (this.isNull(vo).booleanValue() || !this.isStrWithData(vo.getHexFotoProduto())) {
            return null;
        }
        File arquivo = ToolFile.createTempFile((String)"imagem", (String)".png");
        ToolFile.writeBytesOnFile((File)arquivo, (byte[])ToolBase64.decodeBase64((String)vo.getHexFotoProduto()));
        return arquivo;
    }

    public File getImagemProduto(Long identificador) throws ExceptionDecodeHexString64, ExceptionIO {
        String imagem = this.serviceBinInfImgAdcProd.getImagemProduto(identificador);
        if (!this.isStrWithData(imagem)) {
            return null;
        }
        File arquivo = ToolFile.createTempFile((String)"imagem", (String)".png");
        ToolFile.writeBytesOnFile((File)arquivo, (byte[])ToolBase64.decodeBase64((String)imagem));
        return arquivo;
    }

    public List<DTOInfAdicionalProduto.DTOImagemProduto> getImagensProdutoWeb(Long idInfAdicional) {
        LinkedList<DTOInfAdicionalProduto.DTOImagemProduto> ret = new LinkedList<DTOInfAdicionalProduto.DTOImagemProduto>();
        List data = this.serviceBinInfImgAdcProd.getImagensProduto(idInfAdicional);
        if (ServiceInfAdicionalProdutoImpl.isWithData(data)) {
            for (Object[] inf : data) {
                DTOInfAdicionalProduto.DTOImagemProduto dto = new DTOInfAdicionalProduto.DTOImagemProduto();
                dto.setIdentificador((Long)inf[0]);
                dto.setDescricao((String)inf[1]);
                ret.add(dto);
            }
        }
        return ret;
    }

    public DTOInfAdicionalProduto.DTOInfAdicionalProdInf buildInfTecAdicionalProduto(Long idModeloFichaTecnica) throws ExceptionObjNotFound {
        LinkedList<ItemInfAdicionalProdInf> dados = new LinkedList<ItemInfAdicionalProdInf>();
        ModeloFichaTecnica modelo = (ModeloFichaTecnica)this.serviceModeloFichaTecnica.getOrThrow(idModeloFichaTecnica);
        if (this.isNotNull(modelo).booleanValue()) {
            InfAdicionalProdInf vo = new InfAdicionalProdInf();
            vo.setModeloFicha(modelo);
            List<ItemModeloFichaTecnica> itens = this.helperModeloFichaTec.build(modelo).sortBySequece();
            for (ItemModeloFichaTecnica i : itens) {
                ItemInfAdicionalProdInf v = new ItemInfAdicionalProdInf();
                v.setItensModeloFichaTecnica(i);
                dados.add(v);
            }
            vo.setItemInfAdicionalProdInf(dados);
            return this.buildToDTOGeneric(vo, DTOInfAdicionalProduto.DTOInfAdicionalProdInf.class);
        }
        return null;
    }

    public void excluirImagemPrincipal(Long identificador) throws ExceptionObjNotFound {
        InfAdicionalProduto vo = (InfAdicionalProduto)this.getOrThrow(identificador);
        if (this.isNotNull(vo).booleanValue()) {
            this.serviceBinInfAdcProd.deleteInfPrincipal(vo.getIdentificador());
        }
    }

    public void excluirImagemAdicional(Long identificador) throws ExceptionObjNotFound {
        if (this.isNotNull(identificador).booleanValue()) {
            this.serviceBinInfImgAdcProd.deleteImagemAdicionalProd(identificador);
        }
    }

    public TempSaveObj salvarInformacaoAdicionalProduto(DTOInfAdicionalProduto dto, ValidGeneric<InfAdicionalProduto> validator) {
        TempSaveObj<InfAdicionalProduto> temp = new TempSaveObj<InfAdicionalProduto>();
        temp.setValidator(validator);
        InfAdicionalProduto toSave = (InfAdicionalProduto)this.buildToEntity(dto);
        validator.clearContainer();
        validator.isValidData((InterfaceVO)toSave);
        if (validator.hasErrors()) {
            temp.setStatus(EnumConstantsMentorStatus.ERRO);
            return temp;
        }
        this.beforeSave(toSave);
        toSave = this.saveOrUpdate(toSave);
        this.salvarImagemPrincipalProduto(dto.getImagemPrincipal(), toSave);
        this.salvarImagensProduto(dto.getImagensProduto(), toSave);
        temp.setResult(toSave);
        return temp;
    }

    private void salvarImagemPrincipalProduto(DTOInfAdicionalProduto.DTOImagemPrincipalProduto dto, InfAdicionalProduto vo) {
        if (this.isNotNull(dto).booleanValue() && this.isNotNull(vo.getIdentificador()).booleanValue() && this.isStrWithData(dto.getHexFotoProduto())) {
            this.serviceBinInfAdcProd.newInfAdicionaisProduto(vo.getIdentificador(), dto.getHexFotoProduto());
        }
    }

    private void salvarImagensProduto(List<DTOInfAdicionalProduto.DTOImagemProduto> imgs, InfAdicionalProduto vo) {
        if (ServiceInfAdicionalProdutoImpl.isWithData(imgs) && this.isNotNull(vo.getIdentificador()).booleanValue()) {
            for (DTOInfAdicionalProduto.DTOImagemProduto img : imgs) {
                this.serviceBinInfImgAdcProd.newInfAdicionaisImgProduto(vo.getIdentificador(), img.getDescricao(), img.getHexFotoProduto());
            }
        }
    }
}

