/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.informacoescomerciais;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsInformacoesComerciais;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorai.recommendation.AIRecommendProductBuilder;
import com.touchcomp.basementorai.recommendation.model.ItemSimilar;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoInformacoesComerciaisImpl;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.temp.informacoescomerciais.DTOInfoComercialProdutoRec;
import com.touchcomp.touchvomodel.temp.informacoescomerciais.DTOInfoComercialProdutoSug;
import com.touchcomp.touchvomodel.temp.informacoescomerciais.DTOInfoComercialVenda;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ServiceInformacoesComerciaisImpl
extends ServiceGenericImpl {
    DaoInformacoesComerciaisImpl daoInformacoesFinanceirasImpl;
    ServiceConfigServicosImpl serviceConfigServicosImpl;
    HelperConfigServicos helperConfigServicos;
    ServiceProdutoImpl serviceProdutoImpl;
    ServiceUnidadeFatClienteImpl serviceUnidadeFatClienteImpl;

    public ServiceInformacoesComerciaisImpl(DaoInformacoesComerciaisImpl daoInformacoesFinanceirasImpl, ServiceConfigServicosImpl serviceConfigServicosImpl, HelperConfigServicos helperConfigServicos, ServiceProdutoImpl serviceProdutoImpl, ServiceUnidadeFatClienteImpl serviceUnidadeFatClienteImpl) {
        this.daoInformacoesFinanceirasImpl = daoInformacoesFinanceirasImpl;
        this.serviceConfigServicosImpl = serviceConfigServicosImpl;
        this.helperConfigServicos = helperConfigServicos;
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceUnidadeFatClienteImpl = serviceUnidadeFatClienteImpl;
    }

    public DTOInfoComercialVenda getEstatisticasCliente(Long idCliente, Double valorVenda) throws ExceptionInvalidData {
        ConfigServicos config = this.serviceConfigServicosImpl.get(EnumConstConfigServicos.CONFIGURACOES_ESTATISTICAS_COMERCIAIS);
        if (config == null) {
            throw new ExceptionInvalidData("E.ERP.1996.001", new Object[0]);
        }
        Integer dias = this.helperConfigServicos.build(config).getValueAsInt(ConstantsInformacoesComerciais.DIAS_BUSCA_HISTORICO.getChave());
        if (!TMethods.isWithData((Number)dias)) {
            dias = 365;
        }
        Date dataBase = ToolDate.previousDays((Date)new Date(), (int)dias);
        DTOInfoComercialVenda info = this.daoInformacoesFinanceirasImpl.getEstatisticasCliente(idCliente, dataBase);
        info.setValorVenda(valorVenda);
        info.setDifVendaMediaVendas(Double.valueOf(valorVenda - info.getValorMedioVendas()));
        info.setDifVendaMaiorVenda(Double.valueOf(valorVenda - info.getMaiorVenda()));
        info.setDifVendaMaiorVendaPerc(ToolNumber.calcDifPercentual((Double)valorVenda, (Double)info.getMaiorVenda()));
        info.setDifVendaMediaVendasPerc(ToolNumber.calcDifPercentual((Double)valorVenda, (Double)info.getValorMedioVendas()));
        return info;
    }

    public List<DTOInfoComercialProdutoSug> getProdutosSugeridos(Long idProduto, Integer howMany) throws ExceptionInvalidData {
        ConfigServicos config = this.serviceConfigServicosImpl.get(EnumConstConfigServicos.CONFIGURACOES_ESTATISTICAS_COMERCIAIS);
        if (config == null) {
            throw new ExceptionInvalidData("E.ERP.1996.001", new Object[0]);
        }
        AIRecommendProductBuilder recommender = AIRecommendProductBuilder.getInstance();
        if (!recommender.isConfigured()) {
            throw new ExceptionInvalidData("E.ERP.1996.003", new Object[0]);
        }
        if (!TMethods.isWithData((Number)howMany)) {
            howMany = 5;
        }
        List itens = recommender.recommend(idProduto, howMany.intValue());
        LinkedList<Long> ids = new LinkedList<Long>();
        for (ItemSimilar item : itens) {
            ids.add(item.getIdItem());
        }
        List<DTOInfoComercialProdutoSug> produtos = this.serviceProdutoImpl.getProdutosSugeridos(ids);
        for (DTOInfoComercialProdutoSug pr : produtos) {
            Optional<ItemSimilar> found = itens.stream().filter(i -> this.isEquals(i.getIdItem(), pr.getIdentificador())).findFirst();
            if (!found.isPresent()) continue;
            pr.setFatorRelevancia(found.get().getFactor());
        }
        return produtos;
    }

    public List<DTOInfoComercialProdutoRec> getProdutosRecomendados(Long idCliente, Long[] idProdutosVendidos, Integer howMany) throws ExceptionInvalidData {
        Integer dias;
        ConfigServicos config = this.serviceConfigServicosImpl.get(EnumConstConfigServicos.CONFIGURACOES_ESTATISTICAS_COMERCIAIS);
        if (config == null) {
            throw new ExceptionInvalidData("E.ERP.1996.001", new Object[0]);
        }
        if (!TMethods.isWithData((Number)howMany)) {
            howMany = 5;
        }
        if (!TMethods.isWithData((Number)(dias = Integer.valueOf(this.helperConfigServicos.build(config).getValueAsInt(ConstantsInformacoesComerciais.DIAS_BUSCA_HISTORICO.getChave()))))) {
            dias = 365;
        }
        Date dataBase = ToolDate.previousDays((Date)new Date(), (int)dias);
        List<DTOInfoComercialProdutoRec> produtos = this.daoInformacoesFinanceirasImpl.getProdutosRecomendados(idCliente, idProdutosVendidos, dataBase, howMany);
        return produtos;
    }

    public Object getEstatisticasClienteUnidadeFaturamento(Long idUnidadeFatCliente, Double valorVenda) throws ExceptionInvalidData {
        Long idCliente = 0L;
        UnidadeFatCliente unid = (UnidadeFatCliente)this.serviceUnidadeFatClienteImpl.get(idUnidadeFatCliente);
        if (unid != null) {
            idCliente = unid.getCliente().getIdentificador();
        }
        return this.getEstatisticasCliente(idCliente, valorVenda);
    }

    public List<DTOInfoComercialProdutoRec> getProdutosRecomendadosUnidadeFaturamento(Long idUnidadeFatCliente, Long[] idProdutosVendidos, Integer nrRecomendacoes) throws ExceptionInvalidData {
        Long idCliente = 0L;
        UnidadeFatCliente unid = (UnidadeFatCliente)this.serviceUnidadeFatClienteImpl.get(idUnidadeFatCliente);
        if (unid != null) {
            idCliente = unid.getCliente().getIdentificador();
        }
        return this.getProdutosRecomendados(idCliente, idProdutosVendidos, nrRecomendacoes);
    }
}

