/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.informacoestecnicascliente;

import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.ClienteContSistemasCnpj;
import com.touchcomp.basementor.model.vo.InformacoesTecnicasCliente;
import com.touchcomp.basementor.model.vo.ServidorCliente;
import com.touchcomp.basementor.model.vo.VersaoMentor;
import com.touchcomp.basementorservice.dao.impl.DaoInformacoesTecnicasClienteImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.informacoestecnicascliente.DTOInfConfigTecnicasCliente;
import org.springframework.stereotype.Service;

@Service
public class ServiceInformacoesTecnicasClienteImpl
extends ServiceGenericEntityImpl<InformacoesTecnicasCliente, Long, DaoInformacoesTecnicasClienteImpl> {
    public ServiceInformacoesTecnicasClienteImpl(DaoInformacoesTecnicasClienteImpl genericDao) {
        super(genericDao);
    }

    public DTOInfConfigTecnicasCliente getConfiguracao(String codigoCliente, Class<DTOInfConfigTecnicasCliente> aClass) {
        InformacoesTecnicasCliente inf = this.getByCodigoCliente(codigoCliente);
        if (inf == null) {
            return null;
        }
        DTOInfConfigTecnicasCliente r = this.buildToDTO(inf, DTOInfConfigTecnicasCliente.class);
        r.getServidorCliente().clear();
        for (ServidorCliente s : inf.getServidorCliente()) {
            DTOInfConfigTecnicasCliente.ServidorCliente s1 = new DTOInfConfigTecnicasCliente.ServidorCliente();
            s1.setDescricao(s.getDescricao());
            s1.setObservacao(s.getObservacao());
            r.getServidorCliente().add(s1);
            if (!TMethods.isStrWithData((String)s1.getDescricao())) {
                s1.setDescricao(s1.getObservacao());
            }
            if (!TMethods.isStrWithData((String)s1.getDescricao())) {
                s1.setDescricao(s1.getObservacao());
            }
            if (TMethods.isStrWithData((String)s.getIpServidorExterno())) {
                DTOInfConfigTecnicasCliente.ServidorClienteConf c1 = new DTOInfConfigTecnicasCliente.ServidorClienteConf();
                c1.setDescricao("Externo " + s1.getDescricao());
                c1.setEndereco(s.getIpServidorExterno());
                c1.setPorta(s.getPortaServidorExternoHttp());
                c1.setIdentificador(s.getIdentificador());
                s1.getConfiguracoes().add(c1);
            }
            DTOInfConfigTecnicasCliente.ServidorClienteConf c2 = new DTOInfConfigTecnicasCliente.ServidorClienteConf();
            c2.setDescricao("Interno " + s1.getDescricao());
            c2.setIdentificador(s.getIdentificador());
            c2.setEndereco(s.getNomeServidor());
            if (TMethods.isAffirmative((Number)s.getUsarIPServidorAcesso())) {
                c2.setEndereco(s.getIpServidor());
            }
            c2.setPorta(s.getPortaServidorInternoHttp());
            s1.getConfiguracoes().add(c2);
        }
        return r;
    }

    public InformacoesTecnicasCliente getByCodigoCliente(String codigoCliente) {
        InformacoesTecnicasCliente inf = ((DaoInformacoesTecnicasClienteImpl)this.getDao()).getByCodigoCliente(codigoCliente);
        return inf;
    }

    public InformacoesTecnicasCliente getByClienteContSistemas(ClienteContSistemas clienteContSistemas) {
        return ((DaoInformacoesTecnicasClienteImpl)this.getDao()).getByClienteContSistemas(clienteContSistemas);
    }

    public InformacoesTecnicasCliente getOrCreate(ClienteContSistemasCnpj cli) {
        InformacoesTecnicasCliente in = this.getByCodigoCliente(cli.getChave());
        if (in == null) {
            in = this.getByClienteContSistemas(cli.getClienteContSistemas());
        }
        if (in == null) {
            in = new InformacoesTecnicasCliente();
            in.setClienteContSistemas(cli.getClienteContSistemas());
            in.setDescricao("criado automaticamente");
            in = this.saveOrUpdate(in);
        }
        return in;
    }

    public VersaoMentor getVersaoAtual(ClienteContSistemas clienteContSistemas) {
        return ((DaoInformacoesTecnicasClienteImpl)this.getDao()).getVersaoAtual(clienteContSistemas);
    }
}

