/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.infoultentradaproduto;

import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InfoUltEntradaProduto;
import com.touchcomp.basementorservice.dao.impl.DaoInfoUltEntradaProdutoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceInfoUltEntradaProdutoImpl
extends ServiceGenericEntityImpl<InfoUltEntradaProduto, Long, DaoInfoUltEntradaProdutoImpl> {
    ServiceNotaFiscalTerceirosImpl serviceNFTerc;
    ServiceNotaFiscalPropriaImpl serviceNFProp;

    @Autowired
    public ServiceInfoUltEntradaProdutoImpl(DaoInfoUltEntradaProdutoImpl dao, ServiceNotaFiscalTerceirosImpl serviceNFTerc, ServiceNotaFiscalPropriaImpl serviceNFProp) {
        super(dao);
        this.serviceNFTerc = serviceNFTerc;
        this.serviceNFProp = serviceNFProp;
    }

    public InfoUltEntradaProduto getUltInfoProd(Long idProduto) {
        return ((DaoInfoUltEntradaProdutoImpl)this.getDao()).getUltInfoProd(idProduto);
    }

    public Double getUltimoCustoNF(Long idProduto) {
        CustoProdutoUltimaNF data1 = this.serviceNFTerc.getUltimoCustoProd(idProduto);
        CustoProdutoUltimaNF data2 = this.serviceNFProp.getUltimoCustoProd(idProduto);
        Long d1 = data1 != null && data1.getDataUltCompra() != null ? data1.getDataUltCompra().getTime() : 0L;
        Long d2 = data2 != null && data2.getDataUltCompra() != null ? data2.getDataUltCompra().getTime() : 0L;
        Double v1 = data1 != null ? data1.getValorCusto() : 0.0;
        Double v2 = data2 != null ? data2.getValorCusto() : 0.0;
        return d1 > d2 ? v1 : v2;
    }

    public Double getUltimoCustoNF(Long idProduto, Long idEmpresa) {
        CustoProdutoUltimaNF data1 = this.serviceNFTerc.getUltimoCustoProd(idProduto, idEmpresa);
        CustoProdutoUltimaNF data2 = this.serviceNFProp.getUltimoCustoProd(idProduto, idEmpresa);
        if (data1 != null && data2 == null) {
            return data1.getValorCusto();
        }
        if (data1 == null && data2 != null) {
            return data2.getValorCusto();
        }
        if (data1 == null && data2 == null) {
            return 0.0;
        }
        Long d1 = data1 != null && data1.getDataUltCompra() != null ? data1.getDataUltCompra().getTime() : 0L;
        Long d2 = data2 != null && data2.getDataUltCompra() != null ? data2.getDataUltCompra().getTime() : 0L;
        Double v1 = data1 != null ? data1.getValorCusto() : null;
        Double v2 = data2 != null ? data2.getValorCusto() : null;
        return d1 > d2 ? v1 : v2;
    }

    public InfoUltEntradaProduto getUltInfoProd(Long idProduto, Long idEmpresa) {
        return ((DaoInfoUltEntradaProdutoImpl)this.getDao()).getUltInfoProd(idProduto, idEmpresa);
    }

    public Double getUltPrecoCompraNF(Long idProduto, Empresa emp) {
        CustoProdutoUltimaNF data1 = this.serviceNFTerc.getUltimoCustoProd(idProduto, emp.getIdentificador());
        CustoProdutoUltimaNF data2 = this.serviceNFProp.getUltimoCustoProd(idProduto, emp.getIdentificador());
        if (data1 != null && data2 == null) {
            return data1.getValorUltPrecoCompra();
        }
        if (data1 == null && data2 != null) {
            return data2.getValorUltPrecoCompra();
        }
        if (data1 == null && data2 == null) {
            return 0.0;
        }
        Long d1 = data1 != null && data1.getDataUltCompra() != null ? data1.getDataUltCompra().getTime() : 0L;
        Long d2 = data2 != null && data2.getDataUltCompra() != null ? data2.getDataUltCompra().getTime() : 0L;
        Double v1 = data1 != null ? data1.getValorUltPrecoCompra() : null;
        Double v2 = data2 != null ? data2.getValorUltPrecoCompra() : null;
        return d1 > d2 ? v1 : v2;
    }

    public Double getUltPrecoCompraNF(Long idProduto) {
        CustoProdutoUltimaNF data1 = this.serviceNFTerc.getUltimoCustoProd(idProduto);
        CustoProdutoUltimaNF data2 = this.serviceNFProp.getUltimoCustoProd(idProduto);
        if (data1 != null && data2 == null) {
            return data1.getValorUltPrecoCompra();
        }
        if (data1 == null && data2 != null) {
            return data2.getValorUltPrecoCompra();
        }
        if (data1 == null && data2 == null) {
            return 0.0;
        }
        Long d1 = data1 != null && data1.getDataUltCompra() != null ? data1.getDataUltCompra().getTime() : 0L;
        Long d2 = data2 != null && data2.getDataUltCompra() != null ? data2.getDataUltCompra().getTime() : 0L;
        Double v1 = data1 != null ? data1.getValorUltPrecoCompra() : null;
        Double v2 = data2 != null ? data2.getValorUltPrecoCompra() : null;
        return d1 > d2 ? v1 : v2;
    }
}

