/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integnfcecontrolecaixa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IntegNFCeControleCaixa;
import com.touchcomp.basementor.model.vo.IntegNfceContCaiContCaixa;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.dao.impl.DaoIntegNFCeControleCaixaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import com.touchcomp.basementorservice.service.impl.nfcecontrolecaixa.ServiceNFCeControleCaixaImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegNFCeControleCaixaImpl
extends ServiceGenericEntityImpl<IntegNFCeControleCaixa, Long, DaoIntegNFCeControleCaixaImpl> {
    @Autowired
    ServiceLoteContabilImpl serviceLoteContabil;
    @Autowired
    ServiceNFCeControleCaixaImpl serviceNFCeControleCaixa;
    @Autowired
    CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais;

    @Autowired
    public ServiceIntegNFCeControleCaixaImpl(DaoIntegNFCeControleCaixaImpl dao) {
        super(dao);
    }

    @Override
    public IntegNFCeControleCaixa beforeSave(IntegNFCeControleCaixa vo) {
        if (vo.getControlesCaixas() != null) {
            vo.getControlesCaixas().forEach(c -> c.setIntegNFCeControleCaixa(vo));
        }
        return vo;
    }

    public IntegNFCeControleCaixa salvarEContabilizarControles(IntegNFCeControleCaixa vo, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        ArrayList<NFCeControleCaixa> caixas = new ArrayList<NFCeControleCaixa>();
        if (vo.getControlesCaixas() != null) {
            for (IntegNfceContCaiContCaixa i : vo.getControlesCaixas()) {
                caixas.add((NFCeControleCaixa)this.serviceNFCeControleCaixa.get(i.getControleCaixa().getIdentificador()));
            }
        }
        LoteContabil loteContabil = this.contabilizarAgrupado(caixas, opcoesContabeis, empresaContabilidade, vo.getLoteContabil());
        vo.setLoteContabil(loteContabil);
        this.beforeSave(vo);
        return this.saveOrUpdate(vo);
    }

    public LoteContabil contabilizarAgrupado(List<NFCeControleCaixa> caixas, OpcoesContabeis opcoes, EmpresaContabilidade empresaContabilidade, LoteContabil lote) throws ExceptionInvalidData {
        LoteContabil newLote = this.compLancamentosEntradaSaidaFiscais.contabilizarAgrupado(caixas, opcoes, empresaContabilidade, lote);
        newLote = this.serviceLoteContabil.saveOrUpdateFlush(newLote);
        return newLote;
    }

    public void reprocessarLancamentosContabeis(Date dataInicial, Date dataFinal, Empresa logedEmpresa, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade) throws ExceptionObjectNotFound, ExceptionInvalidData {
        List<NFCeControleCaixa> controles = this.serviceNFCeControleCaixa.getControles(dataInicial, dataFinal, logedEmpresa);
        for (NFCeControleCaixa nfceControleCaixa : controles) {
            LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(nfceControleCaixa, opcoesContabeis, empresaContabilidade);
            nfceControleCaixa.setLoteContabil(loteContabil);
            this.serviceNFCeControleCaixa.saveOrUpdate(nfceControleCaixa);
        }
    }

    @Async
    public CompletableFuture<EnumConstantsMentorStatus> reprocessarLancamentosContabeisAsync(Date dataInicial, Date dataFinal, Empresa logedEmpresa, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade) throws ExceptionObjectNotFound, ExceptionInvalidData {
        this.reprocessarLancamentosContabeis(dataInicial, dataFinal, logedEmpresa, opcoesContabeis, empresaContabilidade);
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }

    public void reprocessarLancamentosContabeisImpostos(Date dataInicial, Date dataFinal, Empresa logedEmpresa, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade, Short reprocessarPisCofins, Short reprocessarIcms) throws ExceptionObjectNotFound, ExceptionInvalidData {
        List<NFCeControleCaixa> controles = this.serviceNFCeControleCaixa.getControles(dataInicial, dataFinal, logedEmpresa);
        for (NFCeControleCaixa nfceControleCaixa : controles) {
            LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizarImpostos(nfceControleCaixa, opcoesContabeis, empresaContabilidade);
            nfceControleCaixa.setLoteContabil(loteContabil);
            this.serviceNFCeControleCaixa.saveOrUpdate(nfceControleCaixa);
        }
    }

    @Async
    public CompletableFuture<EnumConstantsMentorStatus> reprocessarLancamentosContabeisImpostosAsync(Date dataInicial, Date dataFinal, Empresa logedEmpresa, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade, Short reprocessarPisCofins, Short reprocessarIcms) throws ExceptionObjectNotFound, ExceptionInvalidData {
        this.reprocessarLancamentosContabeisImpostos(dataInicial, dataFinal, logedEmpresa, opcoesContabeis, empresaContabilidade, reprocessarPisCofins, reprocessarIcms);
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }
}

