/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaoadiantamentoviagem;

import com.touchcomp.basementor.model.vo.FechamentoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.IntegAdiantViagemAdiantViagem;
import com.touchcomp.basementor.model.vo.IntegracaoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoAdiantamentoViagemImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.fechamentoadiantamentoviagem.ServiceFechamentoAdiantamentoViagemImpl;
import com.touchcomp.basementorservice.service.impl.integadiantviagemadiantviagem.ServiceIntegAdiantViagemAdiantViagemImpl;
import com.touchcomp.basementorservice.service.impl.lancamento.ServiceLancamentoImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceIntegracaoAdiantamentoViagemImpl
extends ServiceGenericEntityImpl<IntegracaoAdiantamentoViagem, Long, DaoIntegracaoAdiantamentoViagemImpl> {
    @Autowired
    ServiceFechamentoAdiantamentoViagemImpl serviceAdiantamentoViagem;
    @Autowired
    ServiceLancamentoImpl serviceLancamento;
    @Autowired
    ServiceLoteContabilImpl serviceLoteContabil;
    @Autowired
    ServiceIntegAdiantViagemAdiantViagemImpl serviceIntegAdiantViagemAdiantViagem;

    @Autowired
    public ServiceIntegracaoAdiantamentoViagemImpl(DaoIntegracaoAdiantamentoViagemImpl dao) {
        super(dao);
    }

    @Override
    public IntegracaoAdiantamentoViagem beforeSave(IntegracaoAdiantamentoViagem vo) {
        if (vo.getAdiantamentoViagem() != null) {
            vo.getAdiantamentoViagem().forEach(item -> item.setIntegracaoAdiantamentoViagem(vo));
        }
        return vo;
    }

    public void apagaLote(Long idAdiantamentoViagem) {
        IntegAdiantViagemAdiantViagem vo = this.serviceIntegAdiantViagemAdiantViagem.getByAdiantamentoViagem(idAdiantamentoViagem);
        if (vo != null && vo.getLoteContabil() != null) {
            this.serviceIntegAdiantViagemAdiantViagem.deleteLoteInIntegAdiantamento(vo.getLoteContabil());
            this.serviceLoteContabil.delete(vo.getLoteContabil());
        }
    }

    public void apagarRegistros(IntegracaoAdiantamentoViagem integracao) {
        if (integracao.getAdiantamentoViagem() != null) {
            for (IntegAdiantViagemAdiantViagem vo : integracao.getAdiantamentoViagem()) {
                this.serviceIntegAdiantViagemAdiantViagem.deleteLoteInIntegAdiantamento(vo.getLoteContabil());
                this.serviceIntegAdiantViagemAdiantViagem.delete(vo);
                this.serviceLoteContabil.delete(vo.getLoteContabil());
            }
        }
        this.delete(integracao);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public IntegracaoAdiantamentoViagem saveOrUpdateOnly(IntegracaoAdiantamentoViagem vo) {
        if (vo.getAdiantamentoViagem() != null) {
            for (IntegAdiantViagemAdiantViagem item : vo.getAdiantamentoViagem()) {
                item.setAdiantamentoViagem((FechamentoAdiantamentoViagem)this.serviceAdiantamentoViagem.get(item.getAdiantamentoViagem().getIdentificador()));
                LoteContabil lote = this.serviceLancamento.gerarLancamentosAdiantamentoViagem(item);
                if (lote == null) continue;
                item.setLoteContabil(lote);
            }
        }
        vo = ((DaoIntegracaoAdiantamentoViagemImpl)this.getDao()).saveOrUpdate(vo);
        return vo;
    }
}

