/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaobaixatitulos;

import com.touchcomp.basementor.capsules.impl.CapsGrEmpresa;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstTipoBaixaTitulos;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IntegracaoBaixaTituloGrupoBaixaFormas;
import com.touchcomp.basementor.model.vo.IntegracaoBaixaTitulos;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.opcoes.ExceptionOpBaixaTitulosNaoDefinidas;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompIntegBaixaTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoBaixaTitulosImpl;
import com.touchcomp.basementorservice.helpers.impl.baixatitulos.HelperBaixaTitulos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.grupodebaixa.ServiceGrupoDeBaixaFormas;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.integracaobaixatitulogrupobaixaformas.ServiceIntegracaoBaixaTituloGrupoBaixaFormas;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.LockMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoBaixaTitulosImpl
extends ServiceGenericEntityImpl<IntegracaoBaixaTitulos, Long, DaoIntegracaoBaixaTitulosImpl> {
    @Autowired
    CompIntegBaixaTitulos compIntegBaixaTitulos;
    @Autowired
    ServiceGrupoDeBaixaFormas serviceGrupoDeBaixaFormas;
    @Autowired
    HelperBaixaTitulos helperBaixaTitulos;
    @Autowired
    ServiceGrupoEmpresaImpl serviceGrupoEmpresa;
    @Autowired
    ServiceIntegracaoBaixaTituloGrupoBaixaFormas serviceIntegracaoBaixaTituloGrupoBaixaFormas;

    @Autowired
    public ServiceIntegracaoBaixaTitulosImpl(DaoIntegracaoBaixaTitulosImpl dao) {
        super(dao);
    }

    @Override
    public IntegracaoBaixaTitulos beforeSave(IntegracaoBaixaTitulos vo) {
        if (vo.getGruposDeBaixa() != null) {
            vo.getGruposDeBaixa().forEach(it -> it.setIntegracaoBaixaTitulos(vo));
        }
        return vo;
    }

    public void beforeShow(IntegracaoBaixaTitulos vo, CapsGrEmpresa grupoEmpresa) {
        GrupoEmpresa grupo = (GrupoEmpresa)this.serviceGrupoEmpresa.get(grupoEmpresa.get());
        vo.setGrupoEmpresa(grupo);
    }

    public IntegracaoBaixaTitulos saveIntegracao(IntegracaoBaixaTitulos vo, OpcoesContabeis opcCont, Empresa empresa) throws Exception {
        for (IntegracaoBaixaTituloGrupoBaixaFormas i : vo.getGruposDeBaixa()) {
            GrupoDeBaixaFormas grupoDeBaixaFormas = (GrupoDeBaixaFormas)this.serviceGrupoDeBaixaFormas.get(i.getGrupoDeBaixaFormas().getIdentificador());
            if (grupoDeBaixaFormas == null || grupoDeBaixaFormas.getGrupoDeBaixa() == null) continue;
            LoteContabil lote = this.compIntegBaixaTitulos.getLancamentosBaixa(grupoDeBaixaFormas, opcCont, empresa);
            i.setLoteContabil(lote);
        }
        vo = this.saveOrUpdate(vo);
        return vo;
    }

    public List<IntegracaoBaixaTituloGrupoBaixaFormas> buscaEContabilizaBaixas(Date dataInicial, Date dataFinal, OpcoesContabeis opcCont, Empresa empresa) throws ExceptionBase {
        ArrayList<IntegracaoBaixaTituloGrupoBaixaFormas> ret = new ArrayList<IntegracaoBaixaTituloGrupoBaixaFormas>();
        List<GrupoDeBaixaFormas> baixas = this.serviceGrupoDeBaixaFormas.baixasPorPeriodo(dataInicial, dataFinal, empresa.getEmpresaDados().getGrupoEmpresa());
        if (baixas != null) {
            for (GrupoDeBaixaFormas gr : baixas) {
                LoteContabil lote = this.compIntegBaixaTitulos.getLancamentosBaixa(gr, opcCont, empresa);
                if (lote == null) continue;
                ret.add(gr.getIntegracaoBaixaTituloGrupoBaixaFormas());
            }
        }
        return ret;
    }

    public List<GrupoDeBaixaFormas> buscaBaixas(Date dataInicial, Date dataFinal, OpcoesContabeis opcCont, Empresa empresa) throws ExceptionOpBaixaTitulosNaoDefinidas {
        List<GrupoDeBaixaFormas> baixas = this.serviceGrupoDeBaixaFormas.baixasPorPeriodo(dataInicial, dataFinal, empresa.getEmpresaDados().getGrupoEmpresa());
        return baixas;
    }

    public IntegracaoBaixaTituloGrupoBaixaFormas contabilizaBaixas(GrupoDeBaixaFormas gf, OpcoesContabeis opcCont, Empresa empresa) throws ExceptionBase {
        LoteContabil lote = this.compIntegBaixaTitulos.getLancamentosBaixa(gf, opcCont, empresa);
        if (lote != null) {
            return gf.getIntegracaoBaixaTituloGrupoBaixaFormas();
        }
        return null;
    }

    @Async
    public CompletableFuture<EnumConstantsMentorStatus> reprocessarBaixas(Date dataInicial, Date dataFinal, Short filtrarIdBaixa, Long idBaixa, Short atualizarPlanosConta, Empresa empresa, OpcoesContabeis opcCont, OpcoesGerenciais opcoesGerenciais) throws Exception {
        Integer first = 0;
        ((DaoIntegracaoBaixaTitulosImpl)this.getGenericDao()).getSession().lock((Object)empresa, LockMode.NONE);
        ((DaoIntegracaoBaixaTitulosImpl)this.getGenericDao()).getSession().lock((Object)opcCont, LockMode.NONE);
        ((DaoIntegracaoBaixaTitulosImpl)this.getGenericDao()).getSession().lock((Object)opcoesGerenciais, LockMode.NONE);
        List<Object> notas = new ArrayList();
        do {
            notas = this.serviceIntegracaoBaixaTituloGrupoBaixaFormas.baixasPorPeriodoPaginado(dataInicial, dataFinal, filtrarIdBaixa, idBaixa, 10, first);
            if (this.isAffimative(atualizarPlanosConta)) {
                for (IntegracaoBaixaTituloGrupoBaixaFormas integracaoBaixaTituloGrupoBaixaFormas : notas) {
                    GrupoDeBaixaFormas gbf = integracaoBaixaTituloGrupoBaixaFormas.getGrupoDeBaixaFormas();
                    for (BaixaTitulo bt : gbf.getBaixaTitulo()) {
                        this.helperBaixaTitulos.build(bt).createAndSetContasBaixa(bt.getTitulo(), EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_PADRAO, empresa, opcoesGerenciais);
                    }
                }
            }
            for (IntegracaoBaixaTituloGrupoBaixaFormas integracaoBaixaTituloGrupoBaixaFormas : notas) {
                GrupoDeBaixaFormas grupoDeBaixaFormas = (GrupoDeBaixaFormas)this.serviceGrupoDeBaixaFormas.get(integracaoBaixaTituloGrupoBaixaFormas.getGrupoDeBaixaFormas().getIdentificador());
                if (grupoDeBaixaFormas == null || grupoDeBaixaFormas.getGrupoDeBaixa() == null) continue;
                LoteContabil lote = this.compIntegBaixaTitulos.getLancamentosBaixa(grupoDeBaixaFormas, opcCont, empresa);
                integracaoBaixaTituloGrupoBaixaFormas.setLoteContabil(lote);
                this.serviceIntegracaoBaixaTituloGrupoBaixaFormas.saveOrUpdate(integracaoBaixaTituloGrupoBaixaFormas);
            }
            first = first + 10;
        } while (notas != null && !notas.isEmpty());
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }

    public List<IntegracaoBaixaTitulos> pesquisarIntegracaoBaixaTituloPorGrupoDeBaixa(GrupoDeBaixa grupoDeBaixa) {
        return ((DaoIntegracaoBaixaTitulosImpl)this.getGenericDao()).pesquisarIntegracaoBaixaTituloPorGrupoDeBaixa(grupoDeBaixa);
    }
}

