/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaocomunicadoproducao;

import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstOpContTpComReq;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.IntegComProdItemComunicadoProd;
import com.touchcomp.basementor.model.vo.IntegracaoComProducaoItem;
import com.touchcomp.basementor.model.vo.IntegracaoComunicadoProducao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisComProdReq;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbComProd;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.lancamentocentrocusto.comunicadoproducao.CompLancCtbCentroCustoComProd;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.comunicadoproducao.CompIntegComProducao;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.comunicadoproducao.CompComunicadoProdLancGer;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoComunicadoProducaoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.ServiceComunicadoProducaoImpl;
import com.touchcomp.basementorservice.service.impl.requisicao.ServiceRequisicaoImpl;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidResult;
import com.touchcomp.basementorvalidator.entities.impl.integracaocomunicadoproducao.ValidIntegracaoComunicadoProducao;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoComunicadoProducaoImpl
extends ServiceGenericEntityImpl<IntegracaoComunicadoProducao, Long, DaoIntegracaoComunicadoProducaoImpl> {
    @Autowired
    ServiceComunicadoProducaoImpl serviceComunicadoProducao;
    @Autowired
    ServiceRequisicaoImpl serviceRequisicaoImpl;
    @Autowired
    CompLancCtbCentroCustoComProd compIntegLancCentroCusto;
    @Autowired
    CompComunicadoProdLancGer compIntegLancGer;
    @Autowired
    CompIntegComProducao compInteg;
    @Autowired
    ValidIntegracaoComunicadoProducao validInteg;

    @Autowired
    public ServiceIntegracaoComunicadoProducaoImpl(DaoIntegracaoComunicadoProducaoImpl dao) {
        super(dao);
    }

    @Override
    public IntegracaoComunicadoProducao beforeSave(IntegracaoComunicadoProducao vo) {
        if (vo.getItensLotesContabeisDia() != null) {
            for (IntegracaoComProducaoItem i : vo.getItensLotesContabeisDia()) {
                i.setIntegracaoComunicadoProd(vo);
                if (i.getComunicadosProducao() != null) {
                    i.getComunicadosProducao().forEach(e -> e.setIntegracaoComProducaoItem(i));
                }
                if (i.getLancamentosCentroCusto() != null) {
                    i.getLancamentosCentroCusto().forEach(lc -> lc.setIntegracaoComProducaoItem(i));
                }
                if (i.getLancamentosCtbGerencial() == null) continue;
                i.getLancamentosCtbGerencial().forEach(lg -> lg.setIntegracaoComProducaoItem(i));
            }
        }
        if (vo.getEspecies() != null) {
            vo.getEspecies().forEach(e -> e.setIntegracaoComunicadoProducao(vo));
        }
        if (vo.getSubespecies() != null) {
            vo.getSubespecies().forEach(e -> e.setIntegracaoComunicadoProducao(vo));
        }
        return vo;
    }

    public IntegracaoComunicadoProducao filtrarComunicadosProducao(IntegracaoComunicadoProducao integracao, OpcoesContabeis opcoesContabeis) {
        List<ComunicadoProducao> comunicadosProducao = this.serviceComunicadoProducao.getComunicadosProducaoPorPeriodo(integracao.getDataInicial(), integracao.getDataFinal(), integracao.getEmpresa(), opcoesContabeis, integracao.getSubespecies(), integracao.getEspecies());
        List<IntegracaoComProducaoItem> itens = this.filtrarComunicadosDia(comunicadosProducao, integracao);
        integracao.setItensLotesContabeisDia(itens);
        return integracao;
    }

    public ValidResult<IntegracaoComunicadoProducao> gerarLancamentosComunicadoProducao(IntegracaoComunicadoProducao integracao, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData, ExceptionReflection {
        integracao = this.filtrarComunicadosProducao(integracao, opcoesContabeis);
        ArrayList<ParametrizacaoCtbComProd> cache = new ArrayList<ParametrizacaoCtbComProd>();
        ArrayList<ParametrizacaoCtbRequisicao> cacheParamReq = new ArrayList<ParametrizacaoCtbRequisicao>();
        OpcoesContabeisComProdReq opcoesContabeisComProdReq = opcoesContabeis.getOpcoesContabeisComProdReq();
        if (opcoesContabeisComProdReq != null && this.isEquals(opcoesContabeisComProdReq.getTipoIntegracaCom(), EnumConstOpContTpComReq.CONTABILIZAR_INTEG_COM_REQ.getValue())) {
            this.serviceRequisicaoImpl.atualizarPrecoMedioReq(integracao.getEmpresa(), integracao.getDataInicial(), integracao.getDataFinal());
        }
        this.validInteg.clearContainer();
        if (this.isAffimative(integracao.getGerarLancContabil())) {
            integracao = this.compInteg.gerarLancamentosContabeisComunicadoProducao(integracao, opcoesContabeis, cache, this.validInteg, cacheParamReq);
        }
        if (this.isAffimative(integracao.getGerarLancGerencial())) {
            this.compIntegLancGer.gerarLancamentosGerenciais(integracao, cache, this.validInteg);
        }
        if (this.isAffimative(integracao.getGerarLancCentroCusto())) {
            this.compIntegLancCentroCusto.gerarLancamentosCentroCusto(integracao);
        }
        if (this.isAffimative(integracao.getDesconsiderarComunicadosDeValorZerados())) {
            this.desconsiderarComunicadosDeValorZerados(integracao);
        }
        ValidResult res = new ValidResult((InterfaceVO)integracao, (ValidGenericEntitiesImpl)this.validInteg);
        return res;
    }

    void desconsiderarComunicadosDeValorZerados(IntegracaoComunicadoProducao integracao) {
        ArrayList<IntegracaoComProducaoItem> itensARemover = new ArrayList<IntegracaoComProducaoItem>();
        for (IntegracaoComProducaoItem i : integracao.getItensLotesContabeisDia()) {
            ArrayList<Lancamento> lancamentosARemover = new ArrayList<Lancamento>();
            if (i.getLoteContabil() == null) continue;
            for (Lancamento l : i.getLoteContabil().getLancamentos()) {
                if (!this.isEquals(l.getValor(), 0.0)) continue;
                lancamentosARemover.add(l);
            }
            i.getLoteContabil().getLancamentos().removeAll(lancamentosARemover);
            if (!i.getLoteContabil().getLancamentos().isEmpty()) continue;
            itensARemover.add(i);
        }
        integracao.getItensLotesContabeisDia().removeAll(itensARemover);
    }

    List<IntegracaoComProducaoItem> filtrarComunicadosDia(List<ComunicadoProducao> comunicadosProducao, IntegracaoComunicadoProducao integracao) {
        LinkedList<IntegracaoComProducaoItem> itens = new LinkedList<IntegracaoComProducaoItem>();
        for (ComunicadoProducao com : comunicadosProducao) {
            Optional<IntegracaoComProducaoItem> found = itens.stream().filter(it -> it.getDataLote().equals(com.getDataEntradaSaida())).findFirst();
            if (found.isPresent()) {
                IntegComProdItemComunicadoProd comunic = new IntegComProdItemComunicadoProd();
                comunic.setComunicadoProducao(com);
                comunic.setIntegracaoComProducaoItem(found.get());
                found.get().getComunicadosProducao().add(comunic);
                continue;
            }
            IntegracaoComProducaoItem item = new IntegracaoComProducaoItem();
            item.setDataLote(com.getDataEntradaSaida());
            item.setIntegracaoComunicadoProd(integracao);
            itens.add(item);
            IntegComProdItemComunicadoProd comunic = new IntegComProdItemComunicadoProd();
            comunic.setComunicadoProducao(com);
            comunic.setIntegracaoComProducaoItem(item);
            item.getComunicadosProducao().add(comunic);
        }
        integracao.setItensLotesContabeisDia(itens);
        return itens;
    }
}

