/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaocustoprodvendido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.messages.EnumConstStatusWebMessage;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoData;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoItem;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbModFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.nfce.ServiceNFCeImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.web.WebDTOMessage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AuxIntegracaoCustoProdVendido
extends BaseMethods {
    private final ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropria;
    private final ServiceNFCeImpl serviceNFCe;
    private final ServiceProdutoImpl serviceProduto;
    private final ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscal;
    private final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoque;

    public AuxIntegracaoCustoProdVendido(ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropria, ServiceNFCeImpl serviceNFCe, ServiceProdutoImpl serviceProduto, ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscal, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros, ServiceSaldoEstoqueImpl serviceSaldoEstoque) {
        this.serviceNotaFiscalPropria = serviceNotaFiscalPropria;
        this.serviceNFCe = serviceNFCe;
        this.serviceProduto = serviceProduto;
        this.serviceParametrizacaoCtbModFiscal = serviceParametrizacaoCtbModFiscal;
        this.serviceNotaFiscalTerceiros = serviceNotaFiscalTerceiros;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
    }

    public HashMap findIntegracaoCustoProdVendido(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesContabeis oc, EnumConstantsMentorSimNao gerarCtb, EnumConstantsMentorSimNao gerarGerencial) throws ExceptionObjNotFound {
        ArrayList<WebDTOMessage> error = new ArrayList<WebDTOMessage>();
        ArrayList<IntegCustoProdVendidoData> itens = new ArrayList<IntegCustoProdVendidoData>();
        Date dataInicialPadrao = dataInicial;
        while (ToolDate.diferenceDayBetweenDates((Date)dataInicialPadrao, (Date)dataFinal) >= 0) {
            ArrayList<HashMap> valores = new ArrayList<HashMap>();
            List valoresNFe = this.serviceNotaFiscalPropria.findProdutosValorDataNFPropria(dataInicialPadrao, empresa);
            List valoresNFCe = this.serviceNFCe.findProdutosValorDataNFCe(dataInicialPadrao, empresa);
            this.agruparItens(valores, valoresNFe, valoresNFCe, empresa);
            IntegCustoProdVendidoData iData = new IntegCustoProdVendidoData();
            iData.setDataIntegracao(dataInicialPadrao);
            ArrayList<IntegCustoProdVendidoItem> produtosContabilizar = new ArrayList<IntegCustoProdVendidoItem>();
            ArrayList parametrizacoes = new ArrayList();
            for (HashMap h : valores) {
                IntegCustoProdVendidoItem iProd = new IntegCustoProdVendidoItem();
                Long idProduto = (Long)h.get("ID_PRODUTO");
                Long idNatOperacao = (Long)h.get("ID_NATUREZA_OPERACAO");
                Long idModeloFiscal = (Long)h.get("ID_MODELO_FISCAL");
                Long idSubEspecie = (Long)h.get("ID_SUB_ESPECIE");
                Long idCategoria = (Long)h.get("ID_CATEGORIA_PESSOA");
                Long idClassificacao = (Long)h.get("ID_CLASSIFICACAO_CLIENTE");
                Long idUF = (Long)h.get("ID_UNIDADE_FEDERATIVA");
                Long idGrupoEmpresa = empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador();
                Double quantidade = (Double)h.get("QUANTIDADE");
                Produto produto = (Produto)this.serviceProduto.getOrThrow(idProduto);
                iProd.setProduto(produto);
                String chave = idModeloFiscal + "-" + idNatOperacao + "-" + idSubEspecie + "-" + idGrupoEmpresa;
                Boolean achou = false;
                Boolean contabilizado = true;
                if (!parametrizacoes.isEmpty()) {
                    for (HashMap hashMap : parametrizacoes) {
                        ParametrizacaoCtbModFiscal param = (ParametrizacaoCtbModFiscal)hashMap.get(chave);
                        if (param == null) continue;
                        this.putPlanoContaParametrizacao(param, iProd);
                        achou = true;
                    }
                }
                if (!achou.booleanValue()) {
                    ParametrizacaoCtbModFiscal param = this.getParametrizacao(oc, idModeloFiscal, idNatOperacao, idSubEspecie, empresa, idCategoria, idUF, idClassificacao);
                    if (param != null) {
                        if (this.isNull(param.getPlanoContaCredCustoProd()).booleanValue() && this.isAffimative(gerarCtb.getValue())) {
                            error.add(new WebDTOMessage("E.ERP.0971.002", MessagesBaseMentor.getErrorMsg((String)"E.ERP.0971.002", (Object[])new Object[]{produto, param}), EnumConstStatusWebMessage.WARNING));
                            contabilizado = false;
                        }
                        if (this.isNull(param.getPlanoContaDebCustoProd()).booleanValue() && this.isAffimative(gerarCtb.getValue())) {
                            error.add(new WebDTOMessage("E.ERP.0971.006", MessagesBaseMentor.getErrorMsg((String)"E.ERP.0971.006", (Object[])new Object[]{produto, param}), EnumConstStatusWebMessage.WARNING));
                            contabilizado = false;
                        }
                        if (this.isNull(param.getPlanoContaGerencialCustoProd()).booleanValue() && this.isAffimative(gerarGerencial.getValue())) {
                            error.add(new WebDTOMessage("E.ERP.0971.007", MessagesBaseMentor.getErrorMsg((String)"E.ERP.0971.007", (Object[])new Object[]{produto, param}), EnumConstStatusWebMessage.WARNING));
                            contabilizado = false;
                        }
                        if (!this.isNull(param.getPlanoContaCredCustoProd()).booleanValue() && !this.isNull(param.getPlanoContaDebCustoProd()).booleanValue()) {
                            HashMap<CallSite, ParametrizacaoCtbModFiscal> hashMap = new HashMap<CallSite, ParametrizacaoCtbModFiscal>();
                            hashMap.put((CallSite)((Object)chave), param);
                            parametrizacoes.add(hashMap);
                        }
                    } else {
                        error.add(new WebDTOMessage("E.ERP.0971.003", MessagesBaseMentor.getErrorMsg((String)"E.ERP.0971.003", (Object[])new Object[]{iProd.getProduto(), idModeloFiscal, idNatOperacao, idSubEspecie, empresa.getIdentificador(), empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador(), idCategoria, idUF, idClassificacao}), EnumConstStatusWebMessage.WARNING));
                        contabilizado = false;
                    }
                    if (contabilizado.booleanValue()) {
                        this.putPlanoContaParametrizacao(param, iProd);
                    }
                }
                if (contabilizado.booleanValue()) {
                    this.setarPrecosItem(produto, empresa, dataInicialPadrao, quantidade, iProd);
                }
                if (contabilizado.booleanValue() && iProd.getValorTotal() <= 0.0) {
                    error.add(new WebDTOMessage("E.ERP.0971.004", MessagesBaseMentor.getErrorMsg((String)"E.ERP.0971.004", (Object[])new Object[]{iProd.getProduto(), iProd.getPrecoMedio(), iProd.getQuantidade(), ToolDate.dateToStr((Date)dataInicialPadrao)}), EnumConstStatusWebMessage.WARNING));
                }
                if (iProd.getValorTotal() == null || !(iProd.getValorTotal() > 0.0) || !contabilizado.booleanValue()) continue;
                produtosContabilizar.add(iProd);
            }
            iData.setIntegCustoProdVendItem(produtosContabilizar);
            dataInicialPadrao = ToolDate.nextDays((Date)dataInicialPadrao, (int)1);
            if (produtosContabilizar.isEmpty()) continue;
            itens.add(iData);
        }
        if (itens.isEmpty()) {
            error.add(new WebDTOMessage("E.ERP.0971.005", MessagesBaseMentor.getErrorMsg((String)"E.ERP.0971.005", (Object[])new Object[0]), EnumConstStatusWebMessage.WARNING));
        }
        HashMap<String, ArrayList<Object>> hash = new HashMap<String, ArrayList<Object>>();
        hash.put("itens", itens);
        hash.put("erros", error);
        return hash;
    }

    public void setarPrecosItem(Produto produto, Empresa empresa, Date data, Double quantidade, IntegCustoProdVendidoItem iProd) {
        SaldoEstoqueGeralBasico saldo = this.serviceSaldoEstoque.findSaldoProdutoBasico(produto, empresa, data, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        if (this.isNull(saldo).booleanValue()) {
            CustoProdutoUltimaNF i = this.serviceNotaFiscalTerceiros.getUltimoCustoProd(produto.getIdentificador(), empresa.getIdentificador());
            if (this.isNotNull(i).booleanValue()) {
                iProd.setPrecoMedio(i.getValorCusto());
            } else {
                iProd.setPrecoMedio(Double.valueOf(0.0));
            }
        } else {
            iProd.setPrecoMedio(saldo.getValorMedio());
        }
        iProd.setQuantidade(quantidade);
        iProd.setValorTotal(Double.valueOf(iProd.getPrecoMedio() * iProd.getQuantidade()));
    }

    private ParametrizacaoCtbModFiscal getParametrizacao(OpcoesContabeis oc, Long idModeloFiscal, Long idNatOperacao, Long idSubEspecie, Empresa empresa, Long idCategoria, Long idUF, Long idClassificacao) {
        return this.serviceParametrizacaoCtbModFiscal.getByIds(oc, idModeloFiscal, idNatOperacao, idSubEspecie, empresa.getIdentificador(), empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador(), idCategoria, idUF, idClassificacao);
    }

    public void putPlanoContaParametrizacao(ParametrizacaoCtbModFiscal param, IntegCustoProdVendidoItem iProd) {
        if (!this.isNull(param.getPlanoContaCredCustoProd()).booleanValue()) {
            iProd.setPcCredito(param.getPlanoContaCredCustoProd());
        }
        if (!this.isNull(param.getPlanoContaDebCustoProd()).booleanValue()) {
            iProd.setPcDebito(param.getPlanoContaDebCustoProd());
        }
        if (!this.isNull(param.getPlanoContaGerencialCustoProd()).booleanValue()) {
            iProd.setPlanoContaGerencial(param.getPlanoContaGerencialCustoProd());
        }
    }

    private void agruparItens(List<HashMap> valores, List<HashMap> valoresNFe, List<HashMap> valoresNFCe, Empresa empresa) {
        for (HashMap h : valoresNFe) {
            this.verificarExisteItem(valores, h);
        }
        for (HashMap h : valoresNFCe) {
            if (this.isEquals(h.get("ID_UNIDADE_FEDERATIVA"), null)) {
                h.put("ID_UNIDADE_FEDERATIVA", empresa.getPessoa().getEndereco().getCidade().getUf().getIdentificador());
            }
            this.verificarExisteItem(valores, h);
        }
    }

    private void verificarExisteItem(List<HashMap> valores, HashMap h) {
        Boolean b = true;
        for (HashMap m : valores) {
            if (!this.isEquals(m.get("ID_PRODUTO"), h.get("ID_PRODUTO")) || !this.isEquals(m.get("ID_NATUREZA_OPERACAO"), h.get("ID_NATUREZA_OPERACAO")) || !this.isEquals(m.get("ID_MODELO_FISCAL"), h.get("ID_MODELO_FISCAL")) || !this.isEquals(m.get("ID_CATEGORIA_PESSOA"), h.get("ID_CATEGORIA_PESSOA")) || !this.isEquals(m.get("ID_CLASSIFICACAO_CLIENTE"), h.get("ID_CLASSIFICACAO_CLIENTE")) || !this.isEquals(m.get("ID_SUB_ESPECIE"), h.get("ID_SUB_ESPECIE")) || !this.isEquals(m.get("ID_UNIDADE_FEDERATIVA"), h.get("ID_UNIDADE_FEDERATIVA"))) continue;
            m.put("QUANTIDADE", (Double)m.get("QUANTIDADE") + (Double)h.get("QUANTIDADE"));
            b = false;
        }
        if (b.booleanValue()) {
            valores.add(h);
        }
    }
}

