/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaocustoprodvendido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.analisecustoprod.EnumAnaCustoTipoProcDevolucoes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoData;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoItem;
import com.touchcomp.basementor.model.vo.IntegracaoCustoProdVendido;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorservice.components.integracaocustoprodvendido.CompIntegracaoCustoProdutoVendido;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoCustoProdVendidoImpl;
import com.touchcomp.basementorservice.helpers.impl.bloqueioalteracaoestoque.HelperBloqueioAlteracaoEstoque;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.devolucaovendas.ServiceProcCustoDevolucaoVendasImpl;
import com.touchcomp.basementorservice.service.impl.integracaocustoprodvendido.AuxIntegracaoCustoProdVendido;
import com.touchcomp.basementorservice.service.impl.nfce.ServiceNFCeImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.integracaocustoprodvendido.web.DTOIntegracaoCustoProdVendido;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoCustoProdVendidoImpl
extends ServiceGenericEntityImpl<IntegracaoCustoProdVendido, Long, DaoIntegracaoCustoProdVendidoImpl> {
    private final ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropria;
    private final ServiceNFCeImpl serviceNFCe;
    private final ServiceProdutoImpl serviceProduto;
    private final ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscal;
    private final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    private final CompIntegracaoCustoProdutoVendido compIntegracaoCustoProdutoVendido;
    private final HelperBloqueioAlteracaoEstoque helperBloqueioAlteracaoEstoque;
    private final ServiceProcCustoDevolucaoVendasImpl serviceProcCustoDevolucaoVendasImpl;

    @Autowired
    public ServiceIntegracaoCustoProdVendidoImpl(DaoIntegracaoCustoProdVendidoImpl dao, ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropria, ServiceNFCeImpl serviceNFCe, ServiceProdutoImpl serviceProduto, ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscal, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros, ServiceSaldoEstoqueImpl serviceSaldoEstoque, CompIntegracaoCustoProdutoVendido compIntegracaoCustoProdutoVendido, HelperBloqueioAlteracaoEstoque helperBloqueioAlteracaoEstoque, ServiceProcCustoDevolucaoVendasImpl serviceProcCustoDevolucaoVendasImpl) {
        super(dao);
        this.serviceNFCe = serviceNFCe;
        this.serviceNotaFiscalPropria = serviceNotaFiscalPropria;
        this.serviceProduto = serviceProduto;
        this.serviceParametrizacaoCtbModFiscal = serviceParametrizacaoCtbModFiscal;
        this.serviceNotaFiscalTerceiros = serviceNotaFiscalTerceiros;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.compIntegracaoCustoProdutoVendido = compIntegracaoCustoProdutoVendido;
        this.helperBloqueioAlteracaoEstoque = helperBloqueioAlteracaoEstoque;
        this.serviceProcCustoDevolucaoVendasImpl = serviceProcCustoDevolucaoVendasImpl;
    }

    public List<IntegracaoCustoProdVendido> getBloqueio(Date dataInicial, Date dataFinal, Empresa empresa) {
        return ((DaoIntegracaoCustoProdVendidoImpl)this.getGenericDao()).verificaBloqueio(dataInicial, dataFinal, empresa);
    }

    public WebDTOResult findIntegracaoCustoProdVendido(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesContabeis oc, EnumConstantsMentorSimNao gerarCtb, EnumConstantsMentorSimNao gerarGerencial) throws ExceptionObjNotFound {
        HashMap hash = new AuxIntegracaoCustoProdVendido(this.serviceNotaFiscalPropria, this.serviceNFCe, this.serviceProduto, this.serviceParametrizacaoCtbModFiscal, this.serviceNotaFiscalTerceiros, this.serviceSaldoEstoque).findIntegracaoCustoProdVendido(dataInicial, dataFinal, empresa, oc, gerarCtb, gerarGerencial);
        WebDTOResult result = new WebDTOResult();
        result.setMessages((List)hash.get("erros"));
        List itens = (List)hash.get("itens");
        if (!TMethods.isNull((Object)itens).booleanValue()) {
            result.setResult(this.buildToDTOGeneric(itens, DTOIntegracaoCustoProdVendido.DTOIntegCustoProdVendidoData.class));
        }
        return result;
    }

    public HashMap findIntegracaoCustoProdVendidoContabilizado(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesContabeis oc, EnumConstantsMentorSimNao gerarCtb, EnumConstantsMentorSimNao gerarGerencial, Short gerarLancAnalitico) throws ExceptionObjNotFound {
        HashMap hash = new AuxIntegracaoCustoProdVendido(this.serviceNotaFiscalPropria, this.serviceNFCe, this.serviceProduto, this.serviceParametrizacaoCtbModFiscal, this.serviceNotaFiscalTerceiros, this.serviceSaldoEstoque).findIntegracaoCustoProdVendido(dataInicial, dataFinal, empresa, oc, gerarCtb, gerarGerencial);
        List itens = (List)hash.get("itens");
        for (IntegCustoProdVendidoData i : itens) {
            if (TMethods.isEquals((Object)gerarCtb, (Object)EnumConstantsMentorSimNao.SIM)) {
                this.compIntegracaoCustoProdutoVendido.contabilizarCustoProdVendido(i, empresa, gerarLancAnalitico);
            }
            if (!TMethods.isEquals((Object)gerarGerencial, (Object)EnumConstantsMentorSimNao.SIM)) continue;
            this.compIntegracaoCustoProdutoVendido.criaLancamentoCtbGerencialIntegrandoCustoProdVendido(i, empresa, gerarLancAnalitico);
        }
        hash.put("itens", itens);
        return hash;
    }

    @Override
    public IntegracaoCustoProdVendido beforeSave(IntegracaoCustoProdVendido vo) {
        try {
            this.compIntegracaoCustoProdutoVendido.haBloqueio(vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa());
            if (vo.getItemIntegCustoProdVendData() != null) {
                for (IntegCustoProdVendidoData i : vo.getItemIntegCustoProdVendData()) {
                    if (TMethods.isAffirmative((Number)vo.getGerarContabil())) {
                        this.compIntegracaoCustoProdutoVendido.contabilizarCustoProdVendido(i, vo.getEmpresa(), vo.getGerarLancAnalitico());
                    }
                    if (TMethods.isAffirmative((Number)vo.getGerarGerencial())) {
                        this.compIntegracaoCustoProdutoVendido.criaLancamentoCtbGerencialIntegrandoCustoProdVendido(i, vo.getEmpresa(), vo.getGerarLancAnalitico());
                    }
                    i.setIntegracaoCustoProdVendido(vo);
                    if (i.getIntegCustoProdVendItem() == null) continue;
                    for (IntegCustoProdVendidoItem it : i.getIntegCustoProdVendItem()) {
                        it.setIntegCustoProdVendData(i);
                    }
                }
            }
            return vo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IntegracaoCustoProdVendido afterSaveEntity(IntegracaoCustoProdVendido entity) {
        try {
            this.serviceProcCustoDevolucaoVendasImpl.reprocessarValorCustoNotasDevolucao(entity.getDataInicial(), entity.getDataFinal(), entity.getEmpresa(), EnumAnaCustoTipoProcDevolucoes.get((Object)entity.getTipoProcDevolucoes()));
            ((DaoIntegracaoCustoProdVendidoImpl)this.getDao()).flushData();
            entity.setBloqueioAlteracaoEstoque(this.helperBloqueioAlteracaoEstoque.novoBloqueio(entity));
            return entity;
        }
        catch (ExceptionInvalidData | ExceptionReflection | ExceptionValidacaoDadosRuntime ex) {
            throw new ExceptionRuntimeBase(ex.getMessage());
        }
    }
}

