/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaomovimentobancario;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IntegracaoMovBancarioMovimento;
import com.touchcomp.basementor.model.vo.IntegracaoMovimentoBancario;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoMovimentoBancarioImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.integracaomovbancariomovimento.ServiceIntegracaoMovBancarioMovimentoImpl;
import com.touchcomp.basementorservice.service.impl.lancamento.ServiceLancamentoImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import com.touchcomp.basementorservice.service.impl.movimentobancario.ServiceMovimentoBancarioImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceIntegracaoMovimentoBancarioImpl
extends ServiceGenericEntityImpl<IntegracaoMovimentoBancario, Long, DaoIntegracaoMovimentoBancarioImpl> {
    @Autowired
    ServiceLoteContabilImpl serviceLoteContabil;
    @Autowired
    ServiceIntegracaoMovBancarioMovimentoImpl serviceIntegracaoMovBancarioMovimento;
    @Autowired
    ServiceLancamentoImpl serviceLancamento;
    @Autowired
    ServiceMovimentoBancarioImpl serviceMovimentoBancario;

    @Autowired
    public ServiceIntegracaoMovimentoBancarioImpl(DaoIntegracaoMovimentoBancarioImpl dao) {
        super(dao);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public IntegracaoMovimentoBancario saveOrUpdateOnly(IntegracaoMovimentoBancario vo) {
        return this.saveIntegracao(vo);
    }

    @Override
    public IntegracaoMovimentoBancario beforeSave(IntegracaoMovimentoBancario vo) {
        if (vo.getMovimentosBancarios() != null) {
            vo.getMovimentosBancarios().forEach(it -> it.setIntegracaoMovimentoBancario(vo));
        }
        return vo;
    }

    public IntegracaoMovimentoBancario saveIntegracao(IntegracaoMovimentoBancario vo) {
        for (IntegracaoMovBancarioMovimento ob : vo.getMovimentosBancarios()) {
            ob.setMovimentoBancario((MovimentoBancario)this.serviceMovimentoBancario.get(ob.getMovimentoBancario().getIdentificador()));
            ob.setIntegracaoMovimentoBancario(vo);
            LoteContabil lote = this.serviceLancamento.gerarLancamentosMovimentoBancario(ob);
            if (lote == null) continue;
            lote = this.serviceLoteContabil.saveOrUpdate(lote);
            ob.setLoteContabil(lote);
        }
        vo = ((DaoIntegracaoMovimentoBancarioImpl)this.getGenericDao()).saveOrUpdate(vo);
        return vo;
    }

    public void apagarIntegracao(IntegracaoMovimentoBancario vo) {
        if (vo == null) {
            return;
        }
        super.delete(vo);
    }

    public List<MovimentoBancario> reprocessarPeriodo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Integer maxResults, Integer first) {
        List<MovimentoBancario> movimentos = this.serviceMovimentoBancario.findMovimentoPeriodoPaginado(dataInicial, dataFinal, grupoEmpresa, maxResults, first);
        for (MovimentoBancario m : movimentos) {
            IntegracaoMovBancarioMovimento intMov = m.getIntegracaoMovBancarioMovimento();
            LoteContabil lote = this.serviceLancamento.gerarLancamentosMovimentoBancario(intMov);
            intMov.setLoteContabil(lote);
            this.serviceIntegracaoMovBancarioMovimento.saveOrUpdate(intMov);
        }
        return movimentos;
    }

    @Async
    public CompletableFuture<EnumConstantsMentorStatus> reprocessarPeriodoAsync(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        Integer firstResult = 0;
        List<Object> movimentos = new ArrayList();
        do {
            movimentos = this.reprocessarPeriodo(dataInicial, dataFinal, grupoEmpresa, 10, firstResult);
            firstResult = firstResult + 10;
        } while (movimentos != null && !movimentos.isEmpty());
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }
}

