/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaomovimentofolha;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.IntegracaoMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementorexceptions.exceptions.impl.planoconta.ExceptionPlanoContaEventoNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha.CompLancamentoGerencialImpostoFolha;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha.CompLancamentoGerencialMovimentoFolha;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoMovimentoFolhaImpl
extends ServiceGenericEntityImpl<IntegracaoMovimentoFolha, Long, DaoIntegracaoMovimentoFolhaImpl> {
    @Autowired
    CompLancamentoGerencialMovimentoFolha compLancamentoGerencialMovimentoFolha;
    @Autowired
    CompLancamentoGerencialImpostoFolha compLancamentoGerencialImpostoFolha;
    @Autowired
    ServiceMovimentoFolhaImpl serviceMovimentoFolha;

    @Autowired
    public ServiceIntegracaoMovimentoFolhaImpl(DaoIntegracaoMovimentoFolhaImpl dao) {
        super(dao);
    }

    public IntegracaoMovimentoFolha salvarIntegracao(IntegracaoMovimentoFolha vo, OpcoesGerenciais opcoesGerenciais, EmpresaRh empresaRh) throws ExceptionValidacaoDados, ExceptionPlanoContaEventoNotFound {
        if (this.findExistenciaIntegracaoAbertura(vo.getAbertura()) != null) {
            throw new ExceptionValidacaoDados("E.ERP.1096.020", new Object[0]);
        }
        if (this.isAffimative(opcoesGerenciais.getGerarLancamentosGerenciais()) && vo != null && vo.getAbertura() != null) {
            for (MovimentoFolha mov : vo.getAbertura().getMovimentoFolha()) {
                this.compLancamentoGerencialMovimentoFolha.gerarLancamentoGerencialIntegracaoMovFolha(mov, vo);
                this.compLancamentoGerencialImpostoFolha.gerarLancamentosGerenciaisImpostoFolha(mov, vo, empresaRh);
            }
        }
        for (MovimentoFolha mov : vo.getAbertura().getMovimentoFolha()) {
            this.serviceMovimentoFolha.saveOrUpdate(mov);
        }
        return this.saveOrUpdate(vo);
    }

    public IntegracaoMovimentoFolha findExistenciaIntegracaoAbertura(AberturaPeriodo aberturaPeriodo) {
        return ((DaoIntegracaoMovimentoFolhaImpl)this.getGenericDao()).findExistenciaIntegracaoAbertura(aberturaPeriodo);
    }
}

