/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaonotafiscalpropria;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IntegracaoNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.IntegracaoNotaPropriaNotas;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.notapropria.CompCalculoNotaPropria;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.integracaonotaproprianotas.ServiceIntegracaoNotaPropriaNotasImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoNotaFiscalPropriaImpl
extends ServiceGenericEntityImpl<IntegracaoNotaFiscalPropria, Long, DaoIntegracaoNotaFiscalPropriaImpl> {
    @Autowired
    ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropria;
    @Autowired
    CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais;
    @Autowired
    CompParametrizacaoContabilNF compParametrizacaoContabilNF;
    @Autowired
    CompCalculoNotaPropria compCalculoNotaPropria;
    @Autowired
    ServiceLoteContabilImpl serviceLoteContabil;
    @Autowired
    ServiceIntegracaoNotaPropriaNotasImpl serviceIntegracaoNotaPropriaNotas;
    @Autowired
    private SCompPlanoConta scPlanoConta;

    @Autowired
    public ServiceIntegracaoNotaFiscalPropriaImpl(DaoIntegracaoNotaFiscalPropriaImpl dao) {
        super(dao);
    }

    @Override
    public IntegracaoNotaFiscalPropria beforeSave(IntegracaoNotaFiscalPropria vo) {
        if (vo.getNotasProprias() != null) {
            vo.getNotasProprias().forEach(it -> it.setIntegracaoNotaFiscalPropria(vo));
        }
        return vo;
    }

    public IntegracaoNotaFiscalPropria saveIntegracao(IntegracaoNotaFiscalPropria integ, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        for (IntegracaoNotaPropriaNotas vo : integ.getNotasProprias()) {
            NotaFiscalPropria nota = (NotaFiscalPropria)this.serviceNotaFiscalPropria.get(vo.getNotaPropria().getIdentificador());
            LoteContabil lote = this.compLancamentosEntradaSaidaFiscais.contabilizar(nota, opcoesContabeis);
            vo.setLoteContabil(lote);
            vo.setNotaPropria(nota);
        }
        integ = this.saveOrUpdate(integ);
        return integ;
    }

    public void desvinculaLoteItemIntegracao(Long identificadorItem) {
        this.serviceIntegracaoNotaPropriaNotas.desvinculaLoteItemIntegracao(identificadorItem);
    }

    @Async
    public CompletableFuture<EnumConstantsMentorStatus> reprocessar(Date dataInicial, Date dataFinal, Short filtrarNumeroSerie, String serie, Integer numeroInicial, Integer numeroFinal, Short atualizarPlanosConta, Short reprocessarNotasDevolucao, OpcoesContabeis opcoesContabeis, GrupoEmpresa grupoEmpresa) throws ExceptionInvalidData, ExceptionParametrizacao, ExceptionAvaliadorExpressoes, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        List notasProprias = new ArrayList();
        int first = 0;
        int step = 10;
        do {
            notasProprias = reprocessarNotasDevolucao.equals(EnumConstantsMentorSimNao.NAO.getValue()) ? this.serviceNotaFiscalPropria.findNotasPeriodoPaginado(dataInicial, dataFinal, step, first, filtrarNumeroSerie, serie, numeroInicial, numeroFinal, grupoEmpresa) : this.serviceNotaFiscalPropria.findNotasOrigemDevolucaoPeriodoPaginado(dataInicial, dataFinal, step, first, grupoEmpresa);
            for (NotaFiscalPropria vo : notasProprias) {
                IntegracaoNotaPropriaNotas i;
                if (atualizarPlanosConta.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                    this.atualizarPlanosConta(vo, opcoesContabeis);
                }
                if ((i = vo.getIntegracaoNotaPropriaNotas()) != null) {
                    LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(vo, opcoesContabeis);
                    i.setLoteContabil(loteContabil);
                    this.serviceIntegracaoNotaPropriaNotas.saveOrUpdate(i);
                }
                this.serviceNotaFiscalPropria.saveOrUpdate(vo);
            }
            first += step;
        } while (notasProprias.size() > 0);
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }

    private void atualizarPlanosConta(NotaFiscalPropria vo, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        try {
            for (ItemNotaFiscalPropria i : vo.getItensNotaPropria()) {
                CompParametrizacaoContabilNF.DadosContas dados = this.compParametrizacaoContabilNF.getPlanoContasNfPropria(i.getModeloFiscal(), i.getProduto(), vo.getUnidadeFatCliente(), vo.getNaturezaOperacao(), vo.getEmpresa(), vo.getUnidadeFatCliente().getCliente().getFaturamento().getCategoriaPessoa(), opcoesContabeis, i.getItemNotaLivroFiscal() != null ? i.getItemNotaLivroFiscal().getCfop() : null);
                i.setPlanoContaCred(dados.getPlanoContaCred());
                Pedido p = null;
                if (vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
                    p = vo.getExpedicao().getPedido();
                }
                PlanoConta planoConta = this.scPlanoConta.getPlanoContaAntecAtivo(vo.getUnidadeFatCliente().getCliente());
                if (p != null && p.getGeracaoTituloPedido() != null && planoConta != null) {
                    i.setPlanoContaDeb(planoConta);
                } else {
                    i.setPlanoContaDeb(dados.getPlanoContaDeb());
                }
                i.setPlanoContaGerencial(dados.getPcGerencial());
            }
            List livros = this.compCalculoNotaPropria.getLivroFiscaisResumo(vo.getItensNotaPropria(), new ArrayList(), vo.getModeloDocFiscal(), vo.getSituacaoDocumento());
            vo.getLivrosFiscais().clear();
            vo.getLivrosFiscais().addAll(livros);
        }
        catch (ExceptionParametrizacao ex) {
            TLogger.get(((Object)((Object)ex)).getClass()).error((Throwable)ex);
            throw ex;
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            TLogger.get(((Object)((Object)ex)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }
}

