/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaonotafiscalterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.IntegracaoNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.IntegracaoNotaTerceirosNotas;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.livrofiscal.impl.CompLivroFiscalNotaTerceiros;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.integracaonotaterceirosnotas.ServiceIntegracaoNotaTerceirosNotasImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoNotaFiscalTerceirosImpl
extends ServiceGenericEntityImpl<IntegracaoNotaFiscalTerceiros, Long, DaoIntegracaoNotaFiscalTerceirosImpl> {
    @Autowired
    private CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais;
    @Autowired
    private ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    @Autowired
    private ServiceIntegracaoNotaTerceirosNotasImpl serviceIntegracaoNotaTerceirosNotas;
    @Autowired
    private CompParametrizacaoContabilNF compParametrizacaoContabilNF;
    @Autowired
    private CompLivroFiscalNotaTerceiros compLivroFiscalNotaTerceiros;

    @Autowired
    public ServiceIntegracaoNotaFiscalTerceirosImpl(DaoIntegracaoNotaFiscalTerceirosImpl dao) {
        super(dao);
    }

    @Override
    public IntegracaoNotaFiscalTerceiros beforeSave(IntegracaoNotaFiscalTerceiros vo) {
        if (vo.getNotaTerceiros() != null) {
            vo.getNotaTerceiros().forEach(i -> i.setIntegracaoNotaFiscalTerceiros(vo));
        }
        return vo;
    }

    public IntegracaoNotaFiscalTerceiros saveIntegracao(IntegracaoNotaFiscalTerceiros vo, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        for (IntegracaoNotaTerceirosNotas i : vo.getNotaTerceiros()) {
            NotaFiscalTerceiros notaTerceiros = (NotaFiscalTerceiros)this.serviceNotaFiscalTerceiros.get(i.getNotaFiscalTerceiros().getIdentificador());
            LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(notaTerceiros, opcoesContabeis);
            i.setLoteContabil(loteContabil);
            i.setNotaFiscalTerceiros(notaTerceiros);
        }
        this.saveOrUpdate(vo);
        return vo;
    }

    @Async
    public CompletableFuture<EnumConstantsMentorStatus> reprocessar(Date dataIn, Date dataFim, Short filtrarNumeroSerie, String serie, Integer numeroInicial, Integer numeroFinal, Short atualizarPlanosConta, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData, ExceptionParametrizacao, ExceptionAvaliadorExpressoes {
        List<NotaFiscalTerceiros> notas;
        Integer first = 0;
        do {
            notas = this.serviceNotaFiscalTerceiros.findNotasPorPeriodoPaginado(dataIn, dataFim, 10, first, filtrarNumeroSerie, serie, numeroInicial, numeroFinal);
            for (NotaFiscalTerceiros nota : notas) {
                IntegracaoNotaTerceirosNotas i;
                if (this.isAffimative(atualizarPlanosConta)) {
                    nota = this.atualizarPlanosConta(nota, opcoesContabeis);
                }
                if ((i = nota.getIntegracaoNotaTerceiros()) != null) {
                    LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(nota, opcoesContabeis);
                    i.setLoteContabil(loteContabil);
                    this.serviceIntegracaoNotaTerceirosNotas.saveOrUpdate(i);
                }
                this.serviceNotaFiscalTerceiros.saveOrUpdate(nota);
            }
            first = first + 10;
        } while (notas != null && !notas.isEmpty());
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }

    public NotaFiscalTerceiros atualizarPlanosConta(NotaFiscalTerceiros vo, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        for (ItemNotaTerceiros i : vo.getItemNotaTerceiros()) {
            CompParametrizacaoContabilNF.DadosContas dados = this.compParametrizacaoContabilNF.getPlanoContasNfTerceiros(i.getModeloFiscal(), i.getProduto(), vo.getUnidadeFatFornecedor(), i.getNaturezaOperacao(), vo.getEmpresa(), vo.getUnidadeFatFornecedor().getCategoriaPessoa(), opcoesContabeis);
            i.setPlanoContaCred(dados.getPlanoContaCred());
            i.setPlanoContaDeb(dados.getPlanoContaDeb());
            i.setPlanoContaGerencial(dados.getPcGerencial());
        }
        this.compLivroFiscalNotaTerceiros.regerarLivrosFiscaisNotasTerceiros(vo);
        return vo;
    }
}

