/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaorequisicao;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BloqueioRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoItem;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.bloqueiocontabil.ExceptionBloqueioRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.integrandorequisicoes.CompIntegracaoRequisicao;
import com.touchcomp.basementorservice.components.lancamentocentrocusto.requisicao.CompLancCtbCentroCustoReq;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.requisicao.CompLancamentoRequisicao;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.requisicao.CompRequisicaoProdLancGer;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoRequisicaoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import com.touchcomp.basementorservice.service.impl.requisicao.ServiceRequisicaoImpl;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidResult;
import com.touchcomp.basementorvalidator.entities.impl.integracaorequisicao.ValidIntegracaoRequisicao;
import com.touchcomp.touchvomodel.vo.integracaorequisicao.web.DTOIntegracaoRequisicao;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoRequisicaoImpl
extends ServiceGenericEntityImpl<IntegracaoRequisicao, Long, DaoIntegracaoRequisicaoImpl> {
    CompLancamentoRequisicao compLancRequisicao;
    CompRequisicaoProdLancGer compRequisicaoProdLancGer;
    CompLancCtbCentroCustoReq compLancCtbCentroCustoReq;
    ServiceRequisicaoImpl serviceRequisicao;
    ValidIntegracaoRequisicao validIntegracaoRequisicao;
    CompIntegracaoRequisicao compIntegracaoRequisicao;
    ServiceLoteContabilImpl serviceLoteContabil;

    @Autowired
    public ServiceIntegracaoRequisicaoImpl(DaoIntegracaoRequisicaoImpl dao, CompLancamentoRequisicao compLancRequisicao, CompRequisicaoProdLancGer compRequisicaoProdLancGer, CompLancCtbCentroCustoReq compLancCtbCentroCustoReq, ServiceRequisicaoImpl serviceRequisicao, ValidIntegracaoRequisicao validIntegracaoRequisicao, CompIntegracaoRequisicao compIntegracaoRequisicao, ServiceLoteContabilImpl serviceLoteContabil) {
        super(dao);
        this.compLancRequisicao = compLancRequisicao;
        this.compRequisicaoProdLancGer = compRequisicaoProdLancGer;
        this.compLancCtbCentroCustoReq = compLancCtbCentroCustoReq;
        this.serviceRequisicao = serviceRequisicao;
        this.validIntegracaoRequisicao = validIntegracaoRequisicao;
        this.compIntegracaoRequisicao = compIntegracaoRequisicao;
        this.serviceLoteContabil = serviceLoteContabil;
    }

    @Override
    public IntegracaoRequisicao beforeSave(IntegracaoRequisicao vo) {
        try {
            this.compIntegracaoRequisicao.checkBloqueios(vo);
            if (vo.getItens() != null) {
                for (IntegracaoRequisicaoItem i2 : vo.getItens()) {
                    i2.setIntegracaoRequisicao(vo);
                    this.serviceLoteContabil.beforeSave(i2.getLoteContabil());
                    i2.setRequisicoes(this.getRequisicoesIntegracao(i2));
                }
            }
            if (vo.getEspecies() != null) {
                vo.getEspecies().forEach(i -> i.setIntegracaoRequisicao(vo));
            }
            if (vo.getSubespecies() != null) {
                vo.getSubespecies().forEach(i -> i.setIntegracaoRequisicao(vo));
            }
            if (vo.getNaturezasRequisicao() != null) {
                vo.getNaturezasRequisicao().forEach(i -> i.setIntegracaoRequisicao(vo));
            }
            return vo;
        }
        catch (ExceptionInvalidData e) {
            throw new RuntimeException(e);
        }
        catch (ExceptionBloqueioRequisicao e) {
            throw new RuntimeException(e);
        }
    }

    public List<Requisicao> getRequisicoesIntegracao(IntegracaoRequisicaoItem i) {
        ArrayList<Requisicao> aux = new ArrayList<Requisicao>();
        if (i.getRequisicoes() != null) {
            for (Requisicao r : i.getRequisicoes()) {
                aux.add((Requisicao)this.serviceRequisicao.get(r.getIdentificador()));
            }
            i.setRequisicoes(aux);
        }
        return aux;
    }

    public IntegracaoRequisicao pesquisarIntegrandoRequisicaoPorRequisicao(Requisicao requisicao) {
        return ((DaoIntegracaoRequisicaoImpl)this.getDao()).getIntegracaoRequisicaoPorRequisicao(requisicao);
    }

    @Async
    public CompletableFuture integrarRequisicoesPeriodoComBloqueio(IntegracaoRequisicao integ, OpcoesContabeis opcoesContabeis, OpcoesGerenciais opGerenciais) throws ExceptionInvalidData, ExceptionReflection, ExceptionBloqueioRequisicao {
        try {
            WebDTOResult w = new WebDTOResult();
            ValidResult<IntegracaoRequisicao> result = this.integrarRequisicoesPeriodo(integ, opcoesContabeis, opGerenciais);
            integ = (IntegracaoRequisicao)result.getData();
            if (result.hasErrors() || integ == null) {
                throw new ExceptionRuntimeBase(result.getErrors().toString());
            }
            w.setResult(this.buildToDTOGeneric(integ.getItens(), DTOIntegracaoRequisicao.DTOIntegracaoRequisicaoItem.class));
            return CompletableFuture.completedFuture(w);
        }
        catch (Exception e) {
            this.logError(e);
            return CompletableFuture.completedFuture(new WebDTOResult((Throwable)e));
        }
    }

    public List<IntegracaoRequisicaoItem> requisicoesPeriodo(IntegracaoRequisicao integ) throws ExceptionBloqueioRequisicao, ExceptionInvalidData {
        List<BloqueioRequisicao> bloqueios = this.compIntegracaoRequisicao.checkBloqueios(integ);
        if (bloqueios == null || bloqueios.isEmpty()) {
            this.serviceRequisicao.atualizarPrecoMedioReq(integ.getEmpresa(), integ.getDataInicial(), integ.getDataFinal());
            List<Requisicao> requisicoes = this.serviceRequisicao.getRequisicosPorPeriodo(integ.getDataInicial(), integ.getDataFinal(), integ.getEspecies(), integ.getSubespecies(), integ.getEmpresa(), integ.getNaturezasRequisicao());
            List<IntegracaoRequisicaoItem> itens = this.filtrarRequisicoesDia(requisicoes, integ);
            return itens;
        }
        return new ArrayList<IntegracaoRequisicaoItem>();
    }

    public ValidResult<IntegracaoRequisicao> integrarRequisicoesPeriodo(IntegracaoRequisicao integ, OpcoesContabeis opcoesContabeis, OpcoesGerenciais opGerenciais) throws ExceptionInvalidData, ExceptionReflection, ExceptionBloqueioRequisicao {
        List<IntegracaoRequisicaoItem> itens = this.requisicoesPeriodo(integ);
        integ.setItens(itens);
        ArrayList<ParametrizacaoCtbRequisicao> cache = new ArrayList<ParametrizacaoCtbRequisicao>();
        this.validIntegracaoRequisicao.clearContainer();
        if (this.isEquals(integ.getGerarLancContabil(), (short)1)) {
            this.compLancRequisicao.gerarLancamentos(integ, opcoesContabeis, cache, this.validIntegracaoRequisicao);
        }
        if (this.isEquals(integ.getGerarLancGerencial(), (short)1)) {
            this.compRequisicaoProdLancGer.gerarLancamentosGerenciais(integ, cache, this.validIntegracaoRequisicao, opGerenciais);
        }
        if (this.isEquals(integ.getGerarLancCentroCusto(), (short)1)) {
            this.compLancCtbCentroCustoReq.gerarLancamentosCentroCusto(integ);
        }
        ValidResult result = new ValidResult((InterfaceVO)integ, (ValidGenericEntitiesImpl)this.validIntegracaoRequisicao);
        return result;
    }

    private List<IntegracaoRequisicaoItem> filtrarRequisicoesDia(List<Requisicao> comunicadosProducao, IntegracaoRequisicao integracao) {
        LinkedList<IntegracaoRequisicaoItem> itens = new LinkedList<IntegracaoRequisicaoItem>();
        for (Requisicao com : comunicadosProducao) {
            Optional<IntegracaoRequisicaoItem> found = itens.stream().filter(it -> it.getDataLote().equals(com.getDataRequisicao())).findFirst();
            if (found.isPresent()) {
                found.get().getRequisicoes().add(com);
                continue;
            }
            IntegracaoRequisicaoItem item = new IntegracaoRequisicaoItem();
            item.setDataLote(com.getDataRequisicao());
            item.setIntegracaoRequisicao(integracao);
            itens.add(item);
            item.getRequisicoes().add(com);
        }
        integracao.setItens(itens);
        return itens;
    }
}

