/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.integracaotaxacambial;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IntegracaoTaxaCambial;
import com.touchcomp.basementor.model.vo.ItemIntegracaoTaxaCambial;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.dao.impl.DaoIntegracaoTaxaCambialImpl;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceIntegracaoTaxaCambialImpl
extends ServiceGenericEntityImpl<IntegracaoTaxaCambial, Long, DaoIntegracaoTaxaCambialImpl> {
    HelperLoteContabil helperLoteContabil;

    public ServiceIntegracaoTaxaCambialImpl(DaoIntegracaoTaxaCambialImpl dao, ServiceLoteContabilImpl serviceLoteContabil, HelperLoteContabil helperLoteContabil) {
        super(dao);
        this.helperLoteContabil = helperLoteContabil;
    }

    @Override
    public DaoIntegracaoTaxaCambialImpl getDao() {
        return (DaoIntegracaoTaxaCambialImpl)super.getDao();
    }

    public List<ItemIntegracaoTaxaCambial> criarListaItemIntegracaoTaxaCambial(List<Titulo> titulos, Empresa empresa, EmpresaContabilidade empresaContabilidade, Date dataLote, Double valorTaxa) throws Exception {
        ArrayList<ItemIntegracaoTaxaCambial> listItensIntracaoCambial = new ArrayList<ItemIntegracaoTaxaCambial>();
        for (Titulo titulo : titulos) {
            ItemIntegracaoTaxaCambial item = new ItemIntegracaoTaxaCambial();
            item.setTitulo(titulo);
            Double diferencialOutraMoeda = this.calcularDiferencialOutraMoeda(titulo, valorTaxa);
            if (!this.isEquals(diferencialOutraMoeda, 0.0)) {
                LoteContabil loteContabil = this.helperLoteContabil.criaRecriaLoteContabil(item.getLoteContabil(), dataLote, empresa, ConstEnumOrigemLoteContabil.ITEM_INTEGRACAO_TAXA_CAMBIAL);
                this.addLancamentoLote(loteContabil, diferencialOutraMoeda, empresaContabilidade, titulo.getPagRec(), titulo.getAntecipado(), empresa);
                item.setLoteContabil(loteContabil);
            }
            listItensIntracaoCambial.add(item);
        }
        return listItensIntracaoCambial;
    }

    private void addLancamentoLote(LoteContabil lote, Double diferencialOutraMoeda, EmpresaContabilidade empresaContabilidade, Short pagRec, Short antecipado, Empresa empresa) throws Exception {
        Lancamento lancamento = CompLancamentoBase.newLancamento(lote, empresa);
        lancamento.setHistorico("Integra\u00e7\u00e3o Taxa Cambial.");
        if (this.isEquals(antecipado, (short)0)) {
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialVariacao(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Varia\u00e7\u00e3o (Recebimento) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialDespesa(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Despesa (Recebimento) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialReceita(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Receita (Recebimento) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialVariacaoPag(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Varia\u00e7\u00e3o (Pagamento) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialDespesaPag(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Despesa (Pagamento) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialReceitaPag(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Receita (Pagamento) na Empresa Contabilidade");
            }
            if (this.isEquals(pagRec, (short)1)) {
                if (diferencialOutraMoeda < 0.0) {
                    diferencialOutraMoeda = Math.abs(diferencialOutraMoeda);
                    lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialVariacao());
                    lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialDespesa());
                } else {
                    lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialReceita());
                    lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialVariacao());
                }
            } else if (diferencialOutraMoeda < 0.0) {
                diferencialOutraMoeda = Math.abs(diferencialOutraMoeda);
                lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialVariacaoPag());
                lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialDespesaPag());
            } else {
                lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialReceitaPag());
                lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialVariacaoPag());
            }
        } else if (this.isEquals(antecipado, (short)1)) {
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialVariacaoAntecipado(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Varia\u00e7\u00e3o (Recebimento Antecipado) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialDespesaAntecipado(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Despesa (Recebimento Antecipado) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialReceitaAntecipado(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Receita (Recebimento Antecipado) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialVariacaoPagAntecipado(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Varia\u00e7\u00e3o (Pagamento Antecipado) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialDespesaPagAntecipado(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Despesa (Pagamento Antecipado) na Empresa Contabilidade");
            }
            if (this.isEquals(empresaContabilidade.getPlanoContaTaxaCambialReceitaPagAntecipado(), null)) {
                throw new Exception("Informe o Plano de Conta de Taxa Cambial Receita (Pagamento Antecipado) na Empresa Contabilidade");
            }
            if (this.isEquals(pagRec, (short)1)) {
                if (diferencialOutraMoeda < 0.0) {
                    diferencialOutraMoeda = Math.abs(diferencialOutraMoeda);
                    lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialVariacaoAntecipado());
                    lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialDespesaAntecipado());
                } else {
                    lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialReceitaAntecipado());
                    lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialVariacaoAntecipado());
                }
            } else if (diferencialOutraMoeda < 0.0) {
                diferencialOutraMoeda = Math.abs(diferencialOutraMoeda);
                lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialVariacaoPagAntecipado());
                lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialDespesaPagAntecipado());
            } else {
                lancamento.setPlanoContaCred(empresaContabilidade.getPlanoContaTaxaCambialReceitaPagAntecipado());
                lancamento.setPlanoContaDeb(empresaContabilidade.getPlanoContaTaxaCambialVariacaoPagAntecipado());
            }
        }
        lancamento.setValor(diferencialOutraMoeda);
        lancamento.setLoteContabil(lote);
        lote.getLancamentos().add(lancamento);
    }

    private Double calcularDiferencialOutraMoeda(Titulo t, Double valorTaxa) {
        if (!this.isEquals(t.getCotacaoMoeda(), null)) {
            Double valorTitulo = t.getValorSaldo();
            Double valorTituloOutraMoeda = t.getValorOutraMoeda();
            return valorTituloOutraMoeda * valorTaxa - valorTitulo;
        }
        return 0.0;
    }
}

