/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.itemcotacaocompra;

import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoItemCotacaoCompra;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cotacaocompra.ServiceFornecedorItemCotacaoCompraImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOCotacaoCompra;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceItemCotacaoCompraImpl
extends ServiceGenericEntityImpl<ItemCotacaoCompra, Long, DaoItemCotacaoCompra> {
    @Autowired
    private ServiceFornecedorItemCotacaoCompraImpl serviceFornecedorItemCotacaoCompra;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;

    @Autowired
    public ServiceItemCotacaoCompraImpl(DaoItemCotacaoCompra genericDao) {
        super(genericDao);
    }

    public List<DTOCotacaoCompra.DTOItemCotacaoCompra> getItens(Long identificador) throws ExceptionReflection {
        List<ItemCotacaoCompra> itens = ((DaoItemCotacaoCompra)this.getGenericDao()).getItensCotacao(identificador);
        List<FornecedorItemCotacaoCompra> fornecedores = this.serviceFornecedorItemCotacaoCompra.getFornecedores(identificador);
        ArrayList<FornecedorItemCotacaoCompra> updated = new ArrayList<FornecedorItemCotacaoCompra>(fornecedores);
        for (ItemCotacaoCompra i : itens) {
            ArrayList<FornecedorItemCotacaoCompra> toSet = new ArrayList<FornecedorItemCotacaoCompra>();
            fornecedores = new ArrayList<FornecedorItemCotacaoCompra>(updated);
            for (FornecedorItemCotacaoCompra f : fornecedores) {
                if (!ToolMethods.isEquals((Object)f.getItemCotacaoCompra(), (Object)i)) continue;
                toSet.add(f);
                updated.remove(f);
            }
            i.setFornecedoresItemCotacaoCompra(toSet);
        }
        return this.buildToDTOGeneric(itens, DTOCotacaoCompra.DTOItemCotacaoCompra.class);
    }

    public DTOCotacaoCompra.DTOItemCotacaoCompra setarItemSubstituto(Long idGradeCor, DTOCotacaoCompra.DTOItemCotacaoCompra item) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        if (this.isNull(idGradeCor).booleanValue() || idGradeCor < 0L) {
            throw new ExceptionValidacaoDados("E.ERP.1066.033", new Object[0]);
        }
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.getOrThrow(idGradeCor);
        if (!this.isNull(gradeCor).booleanValue()) {
            if (this.isNull(item.getGradeCorOriginalIdentificador()).booleanValue()) {
                item.setGradeCorOriginalIdentificador(item.getGradeCorIdentificador());
                item.setGradeCorOriginal(item.getGradeCor());
            }
            item.setGradeCorIdentificador(gradeCor.getIdentificador());
            item.setGradeCor(gradeCor.toString());
            item.setProduto(gradeCor.getProdutoGrade().getProduto().getNome());
            item.setProdutoIdentificador(gradeCor.getProdutoGrade().getProduto().getIdentificador());
            item.setUnidadeMedidaIdentificador(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida().getIdentificador());
            item.setUnidadeMedida(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida().toString());
            item.setFatorConversao(Double.valueOf(1.0));
        }
        return item;
    }

    public ItemCotacaoCompra setarItemSubstituto(Long idGradeCor, ItemCotacaoCompra item) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        if (this.isNull(idGradeCor).booleanValue() || this.isNull(item).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1066.033", new Object[0]);
        }
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.getOrThrow(idGradeCor);
        if (this.isNull(item.getGradeCorOriginal()).booleanValue()) {
            item.setGradeCorOriginal(item.getGradeCor());
        }
        item.setGradeCor(gradeCor);
        return item;
    }
}

