/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.itemgradeformulaproduto;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProdutoSubstituto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.components.gradeformulaproduto.CompGradeFormulaProduto;
import com.touchcomp.basementorservice.dao.impl.DaoItemGradeFormulaProdutoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.conversorexpressoesdinamico.ServiceConversorExpressoesDinamicoImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.touchvomodel.vo.gradeformulaproduto.web.DTOGradeFormulaProduto;
import com.touchcomp.touchvomodel.web.WebDTOInputObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceItemGradeFormulaProdutoImpl
extends ServiceGenericEntityImpl<ItemGradeFormulaProduto, Long, DaoItemGradeFormulaProdutoImpl> {
    private CompGradeFormulaProduto compGradeFormulaProduto;
    private ServiceGradeCorImpl serviceGradeCor;
    private ServiceConversorExpressoesDinamicoImpl serviceConversorExpressoesDinamico;

    @Autowired
    public ServiceItemGradeFormulaProdutoImpl(DaoItemGradeFormulaProdutoImpl dao, CompGradeFormulaProduto compGradeFormulaProduto, ServiceGradeCorImpl serviceGradeCor, ServiceConversorExpressoesDinamicoImpl serviceConversorExpressoesDinamico) {
        super(dao);
        this.compGradeFormulaProduto = compGradeFormulaProduto;
        this.serviceGradeCor = serviceGradeCor;
        this.serviceConversorExpressoesDinamico = serviceConversorExpressoesDinamico;
    }

    public ItemGradeFormulaProduto getItemGradeFormulaProduto(Long identificador, Empresa empresa) throws ExceptionParamCtbRequisicao, ExceptionInvalidData {
        GradeCor g = this.serviceGradeCor.getGradeSeProdutoAtivo(identificador);
        return this.compGradeFormulaProduto.getItemGradeFormulaProduto(g, empresa);
    }

    public ItemGradeFormulaProdutoSubstituto getItemGradeFormulaProdutoSubstituto(Long identificador) throws ExceptionInvalidData {
        GradeCor g = this.serviceGradeCor.getGradeSeProdutoAtivo(identificador);
        return this.compGradeFormulaProduto.getItemGradeFormulaProdutoSubstituto(g);
    }

    public List<ItemGradeFormulaProduto> getItemGradeFormulaProduto(String codigoAux, Empresa empresa) throws ExceptionParamCtbRequisicao, ExceptionInvalidData {
        List<GradeCor> g = this.serviceGradeCor.getByCodAuxProdutoAtivo(codigoAux);
        return this.compGradeFormulaProduto.getItemGradeFormulaProduto(g, empresa);
    }

    public List<ItemGradeFormulaProduto> getItemGradeFormulaProdutoByProduto(Long identificador, Empresa empresa) throws ExceptionParamCtbRequisicao, ExceptionInvalidData {
        List<GradeCor> g = this.serviceGradeCor.getByIdProdutoAtivo(identificador);
        return this.compGradeFormulaProduto.getItemGradeFormulaProduto(g, empresa);
    }

    public Double buildResultadoExpressao(WebDTOInputObject<DTOGradeFormulaProduto.DTOItemGradeFormulaProduto> input) throws ExceptionInvalidData {
        if (input == null || input.getInput() == null) {
            return 0.0;
        }
        ItemGradeFormulaProduto source = (ItemGradeFormulaProduto)this.buildToEntity((DTOGradeFormulaProduto.DTOItemGradeFormulaProduto)input.getInput());
        return this.serviceConversorExpressoesDinamico.getResultadoExpressao(source.getConversorExpressoesDinamico(), ((DTOGradeFormulaProduto.DTOItemGradeFormulaProduto)input.getInput()).getTokensExpressao(), source);
    }
}

