/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.itemrequisicao;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.paramcentroestoque.EnumConstParamCenEstEntSai;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.paramcentroestoque.ServiceParamCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompItemRequisicaoImpl
extends ServiceGenericImpl {
    ServiceGradeCorImpl serviceGradeCor;
    ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    ServiceParamCentroEstoqueImpl serviceParamCentroEstoqueImpl;

    public ItemRequisicao showItemRequisicao(Date dataRequisicao, Produto p, OpcoesEstoque oe, Empresa emp, Usuario u) {
        ItemRequisicao i = new ItemRequisicao();
        CentroEstoque ce = this.serviceParamCentroEstoqueImpl.getCentroEstoque(oe, emp, p, u, EnumConstParamCenEstEntSai.SAIDA);
        i.setCentroEstoque(ce);
        List<GradeItemRequisicao> listGcIr = this.getGradesItemRequisicao(p, dataRequisicao, ce, emp);
        i.setGradeItemRequisicao(listGcIr);
        i.setProduto(p);
        return i;
    }

    public List<GradeItemRequisicao> getGradesItemRequisicao(Produto p, Date dataRequisicao, CentroEstoque ce, Empresa emp) {
        GradeCor gc = this.serviceGradeCor.getGradePrincipalbyProduto(p);
        ArrayList<GradeItemRequisicao> listGcIr = new ArrayList<GradeItemRequisicao>();
        if (this.isNull(gc).booleanValue()) {
            List<GradeCor> listGrades = this.serviceGradeCor.getByIdProduto(p.getIdentificador());
            listGrades.forEach(c -> listGcIr.add(this.createGradeItemRequisicao(dataRequisicao, (GradeCor)c, ce, emp)));
        } else {
            listGcIr.add(this.createGradeItemRequisicao(dataRequisicao, gc, ce, emp));
        }
        return listGcIr;
    }

    public GradeItemRequisicao createGradeItemRequisicao(Date dataRequisicao, GradeCor g, CentroEstoque centroEstoque, Empresa emp) throws ExceptionObjectNotFound {
        EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc;
        LoteFabricacao lote;
        GradeItemRequisicao gir = new GradeItemRequisicao();
        gir.setGradeCor(g);
        if (this.isNull(dataRequisicao).booleanValue()) {
            dataRequisicao = new Date();
        }
        if (this.isNull(lote = this.serviceSaldoEstoque.findMelhorLoteFabricacaoPorCentroEstoque(g, emp, dataRequisicao, centroEstoque, tipoCentroEstPropTerc = this.isNull(centroEstoque) == false ? EnumConstCentroEstTipoPropTerc.get((Object)centroEstoque.getTipoEstProprioTerceiros()) : EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO)).booleanValue() && g.getProdutoGrade().getProduto().getLoteUnico() == 1) {
            lote = this.serviceLoteFabricacao.findLoteUnico(g.getProdutoGrade().getProduto());
        }
        if (this.isNull(lote).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.289.001", new Object[]{g.getProdutoGrade().getProduto(), emp}));
        }
        gir.setLoteFabricacao(lote);
        return gir;
    }

    public List<GradeItemRequisicao> findGradesItemRequisicaoProduto(Produto p, Empresa emp, Date dataRequisicao, CentroEstoque centroEstoque) {
        ArrayList<GradeItemRequisicao> res = new ArrayList<GradeItemRequisicao>();
        List<GradeCor> listGrades = this.serviceGradeCor.getByIdProduto(p.getIdentificador());
        if (this.isNull(dataRequisicao).booleanValue()) {
            dataRequisicao = new Date();
        }
        for (GradeCor g : listGrades) {
            GradeItemRequisicao gI = new GradeItemRequisicao(g);
            if (this.isEquals(g.getProdutoGrade().getProduto().getLoteUnico(), (short)1)) {
                gI.setLoteFabricacao(this.serviceLoteFabricacao.findLoteUnico(g.getProdutoGrade().getProduto()));
            } else if (centroEstoque != null) {
                EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc = this.isNull(centroEstoque) == false ? EnumConstCentroEstTipoPropTerc.get((Object)centroEstoque.getTipoEstProprioTerceiros()) : EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO;
                gI.setLoteFabricacao(this.serviceSaldoEstoque.findMelhorLoteFabricacaoPorCentroEstoque(g, emp, dataRequisicao, centroEstoque, tipoCentroEstPropTerc));
            } else {
                gI.setLoteFabricacao(this.serviceSaldoEstoque.findMelhorLoteFabricacao(new Date(), g, emp, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO));
            }
            if (!this.isNotNull(gI.getLoteFabricacao()).booleanValue()) continue;
            res.add(gI);
        }
        if (!SCompItemRequisicaoImpl.isWithData(res)) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.289.001", new Object[]{p, emp}));
        }
        return res;
    }

    public Double calcularQuantidadeItemRequisicao(ItemRequisicao itemRequisicao) {
        return itemRequisicao.getGradeItemRequisicao().stream().mapToDouble(v -> v.getQuantidade()).sum();
    }

    public ItemRequisicao getItemRequisicao(Date dataMovimento, GradeCor gc, NaturezaRequisicao nat, CentroCusto cc, Empresa emp, GradeCor gcSubstituto) {
        ItemRequisicao ir = new ItemRequisicao();
        ir.setNaturezaRequisicao(nat);
        ir.setCentroCusto(cc);
        ir.setProduto(gc.getProdutoGrade().getProduto());
        if (!this.isNull(gcSubstituto).booleanValue()) {
            ir.setProdutoSubstituto(gcSubstituto.getProdutoGrade().getProduto());
        }
        GradeItemRequisicao gr = new GradeItemRequisicao();
        gr.setGradeCor(gc);
        gr.setDataMovimentacao(dataMovimento);
        gr.setLoteFabricacao(null);
        gr.setEmpresa(emp);
        if (gc.getProdutoGrade().getProduto().getLoteUnico().equals((short)1)) {
            LoteFabricacao lf = this.serviceLoteFabricacao.findLoteUnico(gc.getProdutoGrade().getProduto());
            gr.setLoteFabricacao(lf);
        }
        gr.setItemRequisicao(ir);
        ir.getGradeItemRequisicao().add(gr);
        return ir;
    }

    @Generated
    public SCompItemRequisicaoImpl(ServiceGradeCorImpl serviceGradeCor, ServiceLoteFabricacaoImpl serviceLoteFabricacao, ServiceSaldoEstoqueImpl serviceSaldoEstoque, ServiceParamCentroEstoqueImpl serviceParamCentroEstoqueImpl) {
        this.serviceGradeCor = serviceGradeCor;
        this.serviceLoteFabricacao = serviceLoteFabricacao;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.serviceParamCentroEstoqueImpl = serviceParamCentroEstoqueImpl;
    }
}

