/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.itemrequisicao;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoItemRequisicaoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.itemrequisicao.SCompItemRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbrequisicao.ServiceParametrizacaoCtbRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import com.touchcomp.touchvomodel.vo.gradeitemrequisicao.web.DTOGradeItemRequisicao;
import com.touchcomp.touchvomodel.vo.itemrequisicao.web.DTOItemRequisicao;
import com.touchcomp.touchvomodel.vo.requisicao.web.DTORequisicao;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceItemRequisicaoImpl
extends ServiceGenericEntityImpl<ItemRequisicao, Long, DaoItemRequisicaoImpl> {
    SCompItemRequisicaoImpl sCompItemRequisicaoImpl;
    ServiceProdutoImpl serviceProdutoImpl;
    ServiceCentroEstoqueImpl serviceCentroEstoqueImpl;
    ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl;
    ServiceParametrizacaoCtbRequisicaoImpl serviceParametrizacaoCtbRequisicaoImpl;
    ServiceGradeCorImpl serviceGradeCorImpl;
    ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;

    @Autowired
    public ServiceItemRequisicaoImpl(DaoItemRequisicaoImpl dao, SCompItemRequisicaoImpl sCompItemRequisicaoImpl, ServiceProdutoImpl serviceProdutoImpl, ServiceCentroEstoqueImpl serviceCentroEstoqueImpl, ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl, ServiceParametrizacaoCtbRequisicaoImpl serviceParametrizacaoCtbRequisicaoImpl, ServiceGradeCorImpl serviceGradeCorImpl, ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl) {
        super(dao);
        this.sCompItemRequisicaoImpl = sCompItemRequisicaoImpl;
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceCentroEstoqueImpl = serviceCentroEstoqueImpl;
        this.serviceNaturezaRequisicaoImpl = serviceNaturezaRequisicaoImpl;
        this.serviceParametrizacaoCtbRequisicaoImpl = serviceParametrizacaoCtbRequisicaoImpl;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
    }

    public DTOItemRequisicao getItemRequisicao(Long dtRequisicao, Long idProduto, OpcoesEstoque opcoesEstoque, Empresa empresa, Usuario usuario) throws ExceptionObjNotFound {
        Date dataRequisicao = new Date(dtRequisicao);
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        ItemRequisicao itemRequisicao = this.sCompItemRequisicaoImpl.showItemRequisicao(this.isNotNull(dataRequisicao) != false ? dataRequisicao : new Date(), produto, opcoesEstoque, empresa, usuario);
        return this.buildToDTOGeneric(itemRequisicao, DTOItemRequisicao.class);
    }

    public List<DTOGradeItemRequisicao> buscarGradeCor(Long dtRequisicao, Long idProduto, Long idCentroEstoque, Empresa empresa) throws ExceptionObjNotFound {
        Date dataRequisicao = new Date(dtRequisicao);
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        CentroEstoque centroEstoque = (CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(idCentroEstoque);
        List<GradeItemRequisicao> listaGradeItemRequisicao = this.sCompItemRequisicaoImpl.findGradesItemRequisicaoProduto(produto, empresa, this.isNotNull(dataRequisicao) != false ? dataRequisicao : new Date(), centroEstoque);
        return this.buildToDTOGeneric(listaGradeItemRequisicao, DTOGradeItemRequisicao.class);
    }

    public List<DTOEntidadeRes> updateComboLoteFabricacao(Long idGrade, Long idCentroEstoque, Empresa empresa) throws ExceptionObjNotFound {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCorImpl.getOrThrow(idGrade);
        CentroEstoque centroEstoque = (CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(idCentroEstoque);
        List<LoteFabricacao> listaLoteFabricacao = this.serviceSaldoEstoqueImpl.getLotesByGradeCentroEstoqueEmpresa(gradeCor, centroEstoque, empresa);
        return this.buildToDTOGeneric(listaLoteFabricacao, DTOEntidadeRes.class);
    }

    public List<DTOGradeItemRequisicao> getGradesItemRequisicaoLong(Long dtRequisicao, Long idProduto, Long idCentroEstoque, Empresa empresa) throws ExceptionObjNotFound {
        Date dataRequisicao = new Date(dtRequisicao);
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        CentroEstoque centroEstoque = (CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(idCentroEstoque);
        List<GradeItemRequisicao> listaGradeItemRequisicao = this.sCompItemRequisicaoImpl.getGradesItemRequisicao(produto, this.isNotNull(dataRequisicao) != false ? dataRequisicao : new Date(), centroEstoque, empresa);
        return this.buildToDTOGeneric(listaGradeItemRequisicao, DTOGradeItemRequisicao.class);
    }

    public DTORequisicao.DTOParametrizacaoCtbRequisicao exibirContas(Long idNatureza, Long idProduto, GrupoEmpresa grupoEmpresa) throws ExceptionObjNotFound {
        NaturezaRequisicao naturezaRequisicao = (NaturezaRequisicao)this.serviceNaturezaRequisicaoImpl.getOrThrow(idNatureza);
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        return this.serviceParametrizacaoCtbRequisicaoImpl.getOrThrow(DTORequisicao.DTOParametrizacaoCtbRequisicao.class, grupoEmpresa, produto, naturezaRequisicao);
    }
}

