/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.itemsobraformproduto;

import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemSobraFormProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.gradeformulaproduto.CompGradeFormulaProduto;
import com.touchcomp.basementorservice.dao.impl.DaoItemSobraFormProdutoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceItemSobraFormProdutoImpl
extends ServiceGenericEntityImpl<ItemSobraFormProduto, Long, DaoItemSobraFormProdutoImpl> {
    private CompGradeFormulaProduto compGradeFormulaProduto;
    private ServiceGradeCorImpl serviceGradeCor;

    @Autowired
    public ServiceItemSobraFormProdutoImpl(DaoItemSobraFormProdutoImpl dao, CompGradeFormulaProduto compGradeFormulaProduto, ServiceGradeCorImpl serviceGradeCor) {
        super(dao);
        this.compGradeFormulaProduto = compGradeFormulaProduto;
        this.serviceGradeCor = serviceGradeCor;
    }

    public ItemSobraFormProduto getItemSobraFormProduto(Long identificador) throws ExceptionInvalidData {
        GradeCor g = this.serviceGradeCor.getGradeSeProdutoAtivo(identificador);
        return this.compGradeFormulaProduto.getItemSobraFormProduto(g);
    }

    public List<ItemSobraFormProduto> getItemSobraFormProduto(String codigoAux) throws ExceptionInvalidData {
        List<GradeCor> g = this.serviceGradeCor.getByCodAuxProdutoAtivo(codigoAux);
        return this.compGradeFormulaProduto.getItemSobraFormProduto(g);
    }

    public List<ItemSobraFormProduto> getItemSobraFormProdutoByProduto(Long identificador) throws ExceptionInvalidData {
        List<GradeCor> g = this.serviceGradeCor.getByIdProdutoAtivo(identificador);
        return this.compGradeFormulaProduto.getItemSobraFormProduto(g);
    }
}

