/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.itemtransfcentroestoque;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompItemTransfCentroEstoqueImpl
extends ServiceGenericImpl {
    ServiceGradeCorImpl serviceGradeCorImpl;
    ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;
    ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;

    public ItemTransfCentroEstoque showItemTransfCentroEstoque(Date dataTransferencia, Produto produto, CentroEstoque centroEstoqueOrigem, CentroEstoque centroEstoqueDestino, Empresa empresa) {
        ItemTransfCentroEstoque itemTransfCentroEstoque = new ItemTransfCentroEstoque();
        List<GradeItemTransfCentroEstoque> listGcItce = this.getGradeItemTransfCentroEstoque(produto, dataTransferencia, centroEstoqueOrigem, centroEstoqueDestino, empresa);
        itemTransfCentroEstoque.setGradeItemTransCentroEst(listGcItce);
        itemTransfCentroEstoque.setProduto(produto);
        itemTransfCentroEstoque.setOrigem(centroEstoqueOrigem);
        itemTransfCentroEstoque.setDestino(centroEstoqueDestino);
        return itemTransfCentroEstoque;
    }

    public List<GradeItemTransfCentroEstoque> getGradeItemTransfCentroEstoque(Produto produto, Date dataTransferencia, CentroEstoque centroEstoqueOrigem, CentroEstoque centroEstoqueDestino, Empresa empresa) {
        GradeCor gc = this.serviceGradeCorImpl.getGradePrincipalbyProduto(produto);
        ArrayList<GradeItemTransfCentroEstoque> listGcItce = new ArrayList<GradeItemTransfCentroEstoque>();
        if (this.isNull(gc).booleanValue()) {
            List<GradeCor> listGrades = this.serviceGradeCorImpl.getByIdProduto(produto.getIdentificador());
            listGrades.forEach(g -> listGcItce.add(this.createGradeItemTransfCentroEstoque(dataTransferencia, (GradeCor)g, centroEstoqueOrigem, centroEstoqueDestino, empresa)));
        } else {
            listGcItce.add(this.createGradeItemTransfCentroEstoque(dataTransferencia, gc, centroEstoqueOrigem, centroEstoqueDestino, empresa));
        }
        return listGcItce;
    }

    public GradeItemTransfCentroEstoque createGradeItemTransfCentroEstoque(Date dataTransferencia, GradeCor gradeCor, CentroEstoque centroEstoqueOrigem, CentroEstoque centroEstoqueDestino, Empresa empresa) {
        GradeItemTransfCentroEstoque gradeItemTransfCentroEstoque = new GradeItemTransfCentroEstoque();
        gradeItemTransfCentroEstoque.setGradeCor(gradeCor);
        gradeItemTransfCentroEstoque.setEmpresa(empresa);
        gradeItemTransfCentroEstoque.setOrigem(centroEstoqueOrigem);
        gradeItemTransfCentroEstoque.setDestino(centroEstoqueDestino);
        if (this.isNull(dataTransferencia).booleanValue()) {
            dataTransferencia = new Date();
        }
        gradeItemTransfCentroEstoque.setDataTransferencia(dataTransferencia);
        EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc = this.isNotNull(centroEstoqueOrigem) != false ? EnumConstCentroEstTipoPropTerc.get((Object)centroEstoqueOrigem.getTipoEstProprioTerceiros()) : EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO;
        LoteFabricacao lote = this.serviceSaldoEstoqueImpl.findMelhorLoteFabricacaoPorCentroEstoque(gradeCor, empresa, dataTransferencia, centroEstoqueOrigem, tipoCentroEstPropTerc);
        if (this.isNull(lote).booleanValue() && this.isEquals(gradeCor.getProdutoGrade().getProduto().getLoteUnico(), EnumConstantsMentorSimNao.SIM.getValue())) {
            lote = this.serviceLoteFabricacaoImpl.findLoteUnico(gradeCor.getProdutoGrade().getProduto());
        }
        if (this.isNull(lote).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.818.001", new Object[]{gradeCor.getProdutoGrade().getProduto(), empresa}));
        }
        gradeItemTransfCentroEstoque.setLoteFabricacao(lote);
        return gradeItemTransfCentroEstoque;
    }

    public ItemTransfCentroEstoque createItemTransfCentroEstoque(Date dataTransferencia, CentroEstoque centroEstoqueOrigem, CentroEstoque centroEstoqueDestino, Produto produto, GradeCor gradeCor, Double quantidadeTotal, Empresa empresa) {
        ItemTransfCentroEstoque itemTransfCentroEstoque = new ItemTransfCentroEstoque();
        itemTransfCentroEstoque.setOrigem(centroEstoqueOrigem);
        itemTransfCentroEstoque.setDestino(centroEstoqueDestino);
        itemTransfCentroEstoque.setProduto(produto);
        itemTransfCentroEstoque.setQuantidadeTotal(quantidadeTotal);
        GradeItemTransfCentroEstoque gradeItemTransfCentroEstoque = this.createGradeItemTransfCentroEstoque(dataTransferencia, gradeCor, centroEstoqueOrigem, centroEstoqueDestino, empresa);
        gradeItemTransfCentroEstoque.setItemTransfCentroEst(itemTransfCentroEstoque);
        gradeItemTransfCentroEstoque.setQuantidade(quantidadeTotal);
        itemTransfCentroEstoque.getGradeItemTransCentroEst().add(gradeItemTransfCentroEstoque);
        return itemTransfCentroEstoque;
    }

    public List<GradeItemTransfCentroEstoque> getGradesItemTransferenciaCentroEstoqueProdutoLoteFabricacao(Date dataTransferencia, Produto produto, Empresa empresa) {
        List<GradeCor> listGrades = this.serviceGradeCorImpl.getByIdProduto(produto.getIdentificador());
        List<GradeItemTransfCentroEstoque> gradeItemTransfCentroEstoque = listGrades.stream().map(i -> {
            GradeItemTransfCentroEstoque item = new GradeItemTransfCentroEstoque();
            if (this.isEquals(i.getProdutoGrade().getProduto().getLoteUnico(), EnumConstantsMentorSimNao.SIM.getValue())) {
                item.setLoteFabricacao(this.serviceLoteFabricacaoImpl.findLoteUnico(i.getProdutoGrade().getProduto()));
            } else {
                item.setLoteFabricacao(this.serviceSaldoEstoqueImpl.findMelhorLoteFabricacao(dataTransferencia, (GradeCor)i, empresa, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO));
            }
            if (this.isNull(item.getLoteFabricacao()).booleanValue()) {
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.818.001", new Object[]{i.getProdutoGrade().getProduto(), empresa}));
            }
            return item;
        }).collect(Collectors.toList());
        return gradeItemTransfCentroEstoque;
    }

    @Generated
    public SCompItemTransfCentroEstoqueImpl(ServiceGradeCorImpl serviceGradeCorImpl, ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl) {
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
    }
}

