/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.itemtransfcentroestoque;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoItemTransfCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.itemtransfcentroestoque.SCompItemTransfCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.touchvomodel.vo.gradeitemtransfcentroestoque.web.DTOGradeItemTransfCentroEstoque;
import com.touchcomp.touchvomodel.vo.itemtransfcentroestoque.web.DTOItemTransfCentroEstoque;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceItemTransfCentroEstoqueImpl
extends ServiceGenericEntityImpl<ItemTransfCentroEstoque, Long, DaoItemTransfCentroEstoqueImpl> {
    ServiceEmpresaImpl serviceEmpresaImpl;
    ServiceProdutoImpl serviceProdutoImpl;
    ServiceCentroEstoqueImpl serviceCentroEstoqueImpl;
    SCompItemTransfCentroEstoqueImpl sCompItemTransfCentroEstoqueImpl;

    @Autowired
    public ServiceItemTransfCentroEstoqueImpl(DaoItemTransfCentroEstoqueImpl dao, ServiceEmpresaImpl serviceEmpresaImpl, ServiceProdutoImpl serviceProdutoImpl, ServiceCentroEstoqueImpl serviceCentroEstoqueImpl, SCompItemTransfCentroEstoqueImpl sCompItemTransfCentroEstoqueImpl) {
        super(dao);
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceCentroEstoqueImpl = serviceCentroEstoqueImpl;
        this.sCompItemTransfCentroEstoqueImpl = sCompItemTransfCentroEstoqueImpl;
    }

    public DTOItemTransfCentroEstoque getItemTransfCentroEstoque(Long dtTransferencia, Long idProduto, Long idCentroEstoqueOrigem, Long idCentroEstoqueDestino, CapsEmpresa capsEmpresa) throws ExceptionObjNotFound {
        Date dataTransferencia = new Date(dtTransferencia);
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        CentroEstoque centroEstoqueOrigem = (CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(idCentroEstoqueOrigem);
        CentroEstoque centroEstoqueDestino = (CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(idCentroEstoqueDestino);
        ItemTransfCentroEstoque itemTransfCentroEstoque = this.sCompItemTransfCentroEstoqueImpl.showItemTransfCentroEstoque(this.isNotNull(dataTransferencia) != false ? dataTransferencia : new Date(), produto, centroEstoqueOrigem, centroEstoqueDestino, empresa);
        return this.buildToDTOGeneric(itemTransfCentroEstoque, DTOItemTransfCentroEstoque.class);
    }

    public List<DTOGradeItemTransfCentroEstoque> pesquisarGrade(Long dtTransferencia, Long idProduto, Long idCentroEstoqueOrigem, Long idCentroEstoqueDestino, CapsEmpresa capsEmpresa) throws ExceptionObjNotFound {
        Date dataTransferencia = new Date(dtTransferencia);
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        CentroEstoque centroEstoqueOrigem = (CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(idCentroEstoqueOrigem);
        CentroEstoque centroEstoqueDestino = (CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(idCentroEstoqueDestino);
        List<GradeItemTransfCentroEstoque> gradeItemTransfCentroEstoque = this.sCompItemTransfCentroEstoqueImpl.getGradeItemTransfCentroEstoque(produto, this.isNotNull(dataTransferencia) != false ? dataTransferencia : new Date(), centroEstoqueOrigem, centroEstoqueDestino, empresa);
        return this.buildToDTOGeneric(gradeItemTransfCentroEstoque, DTOGradeItemTransfCentroEstoque.class);
    }
}

